package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link JvmJsonService.GaugePointRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GaugePointRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "JvmJsonService.GaugePointRequestBase"})
@Immutable
final class GaugePointRequest extends JvmJsonService.GaugePointRequestBase {
  private final long from;
  private final long to;
  private final ImmutableList<String> gaugeNames;
  private final int rollupLevel;

  private GaugePointRequest(GaugePointRequest.Builder builder) {
    this.from = builder.from;
    this.to = builder.to;
    this.gaugeNames = builder.gaugeNamesBuilder.build();
    this.rollupLevel = builder.rollupLevel;
  }

  private GaugePointRequest(
      GaugePointRequest original,
      long from,
      long to,
      ImmutableList<String> gaugeNames,
      int rollupLevel) {
    this.from = from;
    this.to = to;
    this.gaugeNames = gaugeNames;
    this.rollupLevel = rollupLevel;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public long from() {
    return from;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public long to() {
    return to;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code gaugeNames} attribute
   */
  @JsonProperty("gaugeNames")
  @Override
  public ImmutableList<String> gaugeNames() {
    return gaugeNames;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rollupLevel} attribute
   */
  @JsonProperty("rollupLevel")
  @Override
  public int rollupLevel() {
    return rollupLevel;
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.GaugePointRequestBase#from() from}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for from
   * @return modified copy of the {@code this} object
   */
  public final GaugePointRequest withFrom(long value) {
    if (this.from == value) {
      return this;
    }
    long newValue = value;
    return new GaugePointRequest(this, newValue, this.to, this.gaugeNames, this.rollupLevel);
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.GaugePointRequestBase#to() to}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for to
   * @return modified copy of the {@code this} object
   */
  public final GaugePointRequest withTo(long value) {
    if (this.to == value) {
      return this;
    }
    long newValue = value;
    return new GaugePointRequest(this, this.from, newValue, this.gaugeNames, this.rollupLevel);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link JvmJsonService.GaugePointRequestBase#gaugeNames() gaugeNames}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugePointRequest withGaugeNames(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new GaugePointRequest(this, this.from, this.to, newValue, this.rollupLevel);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link JvmJsonService.GaugePointRequestBase#gaugeNames() gaugeNames}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of gaugeNames elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugePointRequest withGaugeNames(Iterable<String> elements) {
    if (this.gaugeNames == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new GaugePointRequest(this, this.from, this.to, newValue, this.rollupLevel);
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.GaugePointRequestBase#rollupLevel() rollupLevel}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for rollupLevel
   * @return modified copy of the {@code this} object
   */
  public final GaugePointRequest withRollupLevel(int value) {
    if (this.rollupLevel == value) {
      return this;
    }
    int newValue = value;
    return new GaugePointRequest(this, this.from, this.to, this.gaugeNames, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GaugePointRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GaugePointRequest && equalTo((GaugePointRequest) another));
  }
  
  private boolean equalTo(GaugePointRequest another) {
    return from == another.from
        && to == another.to
        && gaugeNames.equals(another.gaugeNames)
        && rollupLevel == another.rollupLevel;
  }
  
  /**
   * Computes hash code from attributes: {@code from}, {@code to}, {@code gaugeNames}, {@code rollupLevel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(from);
    h = h * 17 + Longs.hashCode(to);
    h = h * 17 + gaugeNames.hashCode();
    h = h * 17 + rollupLevel;
    return h;
  }
  
  /**
   * Prints immutable value {@code GaugePointRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GaugePointRequest")
        .add("from", from)
        .add("to", to)
        .add("gaugeNames", gaugeNames)
        .add("rollupLevel", rollupLevel)
        .toString();
  }
  
  @JsonCreator
  public static GaugePointRequest fromAllAttributes(
      @JsonProperty("from") @Nullable Long from,
      @JsonProperty("to") @Nullable Long to,
      @JsonProperty("gaugeNames") @Nullable ImmutableList<String> gaugeNames,
      @JsonProperty("rollupLevel") @Nullable Integer rollupLevel) {
    GaugePointRequest.Builder builder = GaugePointRequest.builder();
    if (from != null) {
      builder.from(from);
    }
    if (to != null) {
      builder.to(to);
    }
    if (gaugeNames != null) {
      builder.addAllGaugeNames(gaugeNames);
    }
    if (rollupLevel != null) {
      builder.rollupLevel(rollupLevel);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link JvmJsonService.GaugePointRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable GaugePointRequest instance
   */
  static GaugePointRequest copyOf(JvmJsonService.GaugePointRequestBase instance) {
    if (instance instanceof GaugePointRequest) {
      return (GaugePointRequest) instance;
    }
    return GaugePointRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.GaugePointRequest}.
   * @return new GaugePointRequest builder
   */
  static GaugePointRequest.Builder builder() {
    return new GaugePointRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.GaugePointRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_FROM = 0x1L;
    private static final long INITIALIZED_BIT_TO = 0x2L;
    private static final long INITIALIZED_BIT_ROLLUP_LEVEL = 0x4L;
    private long initializedBitset;
  
    private long from;
    private long to;
    private ImmutableList.Builder<String> gaugeNamesBuilder = ImmutableList.builder();
    private int rollupLevel;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link JvmJsonService.GaugePointRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(JvmJsonService.GaugePointRequestBase instance) {
      Preconditions.checkNotNull(instance);
      from(instance.from());
      to(instance.to());
      addAllGaugeNames(instance.gaugeNames());
      rollupLevel(instance.rollupLevel());
      return this;
    }
  
    /**
     * Initializes value for {@link JvmJsonService.GaugePointRequestBase#from() from}.
     * @param from value for from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(long from) {
      this.from = from;
      initializedBitset |= INITIALIZED_BIT_FROM;
      return this;
    }
  
    /**
     * Initializes value for {@link JvmJsonService.GaugePointRequestBase#to() to}.
     * @param to value for to
     * @return {@code this} builder for chained invocation
     */
    public final Builder to(long to) {
      this.to = to;
      initializedBitset |= INITIALIZED_BIT_TO;
      return this;
    }
  
    /**
     * Adds one element to {@link JvmJsonService.GaugePointRequestBase#gaugeNames() gaugeNames} list.
     * @param element gaugeNames element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addGaugeNames(String element) {
      gaugeNamesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link JvmJsonService.GaugePointRequestBase#gaugeNames() gaugeNames} list.
     * @param elements array of gaugeNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addGaugeNames(String... elements) {
      gaugeNamesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link JvmJsonService.GaugePointRequestBase#gaugeNames() gaugeNames} list.
     * @param elements iterable of gaugeNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder gaugeNames(Iterable<String> elements) {
      gaugeNamesBuilder = ImmutableList.builder();
      return addAllGaugeNames(elements);
    }
  
    /**
     * Adds elements to {@link JvmJsonService.GaugePointRequestBase#gaugeNames() gaugeNames} list.
     * @param elements iterable of gaugeNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllGaugeNames(Iterable<String> elements) {
      gaugeNamesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link JvmJsonService.GaugePointRequestBase#rollupLevel() rollupLevel}.
     * @param rollupLevel value for rollupLevel
     * @return {@code this} builder for chained invocation
     */
    public final Builder rollupLevel(int rollupLevel) {
      this.rollupLevel = rollupLevel;
      initializedBitset |= INITIALIZED_BIT_ROLLUP_LEVEL;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.GaugePointRequest}.
     * @return immutable instance of GaugePointRequest
     */
    public org.glowroot.local.ui.GaugePointRequest build() {
      checkRequiredAttributes();
      return new GaugePointRequest(this);
    }
  
    private boolean fromIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM) != 0;
    }
  
    private boolean toIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TO) != 0;
    }
  
    private boolean rollupLevelIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ROLLUP_LEVEL) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!fromIsSet()) {
        attributes.add("from");
      }
      if (!toIsSet()) {
        attributes.add("to");
      }
      if (!rollupLevelIsSet()) {
        attributes.add("rollupLevel");
      }
      return "Cannot build GaugePointRequest, some of required attributes are not set " + attributes;
    }
  }
}
