package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.LazyHistogram;

/**
 * Immutable implementation of {@link AggregateMerging.HistogramMergedAggregateBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code HistogramMergedAggregate.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AggregateMerging.HistogramMergedAggregateBase"})
@Immutable
public final class HistogramMergedAggregate
    extends AggregateMerging.HistogramMergedAggregateBase {
  private final LazyHistogram histogram;
  private final long totalMicros;
  private final long transactionCount;
  private final long percentile1;
  private final long percentile2;
  private final long percentile3;

  private HistogramMergedAggregate(HistogramMergedAggregate.Builder builder) {
    this.histogram = builder.histogram;
    this.totalMicros = builder.totalMicros;
    this.transactionCount = builder.transactionCount;
    this.percentile1 = super.percentile1();
    this.percentile2 = super.percentile2();
    this.percentile3 = super.percentile3();
  }

  private HistogramMergedAggregate(
      HistogramMergedAggregate original,
      LazyHistogram histogram,
      long totalMicros,
      long transactionCount) {
    this.histogram = histogram;
    this.totalMicros = totalMicros;
    this.transactionCount = transactionCount;
    this.percentile1 = super.percentile1();
    this.percentile2 = super.percentile2();
    this.percentile3 = super.percentile3();
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code histogram} attribute
   */
  @JsonIgnore
  @JsonProperty("histogram")
  @Override
  public LazyHistogram histogram() {
    return histogram;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalMicros} attribute
   */
  @JsonProperty("totalMicros")
  @Override
  public long totalMicros() {
    return totalMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCount} attribute
   */
  @JsonProperty("transactionCount")
  @Override
  public long transactionCount() {
    return transactionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code percentile1} attribute
   */
  @JsonProperty("percentile1")
  @Override
  public long percentile1() {
    return percentile1;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code percentile2} attribute
   */
  @JsonProperty("percentile2")
  @Override
  public long percentile2() {
    return percentile2;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code percentile3} attribute
   */
  @JsonProperty("percentile3")
  @Override
  public long percentile3() {
    return percentile3;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.HistogramMergedAggregateBase#histogram() histogram}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for histogram
   * @return modified copy of the {@code this} object
   */
  public final HistogramMergedAggregate withHistogram(LazyHistogram value) {
    if (this.histogram == value) {
      return this;
    }
    LazyHistogram newValue = Preconditions.checkNotNull(value);
    return new HistogramMergedAggregate(this, newValue, this.totalMicros, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.HistogramMergedAggregateBase#totalMicros() totalMicros}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalMicros
   * @return modified copy of the {@code this} object
   */
  public final HistogramMergedAggregate withTotalMicros(long value) {
    if (this.totalMicros == value) {
      return this;
    }
    long newValue = value;
    return new HistogramMergedAggregate(this, this.histogram, newValue, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.HistogramMergedAggregateBase#transactionCount() transactionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionCount
   * @return modified copy of the {@code this} object
   */
  public final HistogramMergedAggregate withTransactionCount(long value) {
    if (this.transactionCount == value) {
      return this;
    }
    long newValue = value;
    return new HistogramMergedAggregate(this, this.histogram, this.totalMicros, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code HistogramMergedAggregate} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof HistogramMergedAggregate && equalTo((HistogramMergedAggregate) another));
  }
  
  private boolean equalTo(HistogramMergedAggregate another) {
    return histogram.equals(another.histogram)
        && totalMicros == another.totalMicros
        && transactionCount == another.transactionCount
        && percentile1 == another.percentile1
        && percentile2 == another.percentile2
        && percentile3 == another.percentile3;
  }
  
  /**
   * Computes hash code from attributes: {@code histogram}, {@code totalMicros}, {@code transactionCount}, {@code percentile1}, {@code percentile2}, {@code percentile3}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + histogram.hashCode();
    h = h * 17 + Longs.hashCode(totalMicros);
    h = h * 17 + Longs.hashCode(transactionCount);
    h = h * 17 + Longs.hashCode(percentile1);
    h = h * 17 + Longs.hashCode(percentile2);
    h = h * 17 + Longs.hashCode(percentile3);
    return h;
  }
  
  /**
   * Prints immutable value {@code HistogramMergedAggregate{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HistogramMergedAggregate")
        .add("histogram", histogram)
        .add("totalMicros", totalMicros)
        .add("transactionCount", transactionCount)
        .add("percentile1", percentile1)
        .add("percentile2", percentile2)
        .add("percentile3", percentile3)
        .toString();
  }
  
  @JsonCreator
  public static HistogramMergedAggregate fromAllAttributes(
      @JsonProperty("histogram") @Nullable LazyHistogram histogram,
      @JsonProperty("totalMicros") @Nullable Long totalMicros,
      @JsonProperty("transactionCount") @Nullable Long transactionCount) {
    HistogramMergedAggregate.Builder builder = HistogramMergedAggregate.builder();
    if (histogram != null) {
      builder.histogram(histogram);
    }
    if (totalMicros != null) {
      builder.totalMicros(totalMicros);
    }
    if (transactionCount != null) {
      builder.transactionCount(transactionCount);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link AggregateMerging.HistogramMergedAggregateBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable HistogramMergedAggregate instance
   */
  public static HistogramMergedAggregate copyOf(AggregateMerging.HistogramMergedAggregateBase instance) {
    if (instance instanceof HistogramMergedAggregate) {
      return (HistogramMergedAggregate) instance;
    }
    return HistogramMergedAggregate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.HistogramMergedAggregate}.
   * @return new HistogramMergedAggregate builder
   */
  public static HistogramMergedAggregate.Builder builder() {
    return new HistogramMergedAggregate.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.HistogramMergedAggregate}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_HISTOGRAM = 0x1L;
    private static final long INITIALIZED_BIT_TOTAL_MICROS = 0x2L;
    private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 0x4L;
    private long initializedBitset;
  
    private @Nullable LazyHistogram histogram;
    private long totalMicros;
    private long transactionCount;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link AggregateMerging.HistogramMergedAggregateBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(AggregateMerging.HistogramMergedAggregateBase instance) {
      Preconditions.checkNotNull(instance);
      histogram(instance.histogram());
      totalMicros(instance.totalMicros());
      transactionCount(instance.transactionCount());
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.HistogramMergedAggregateBase#histogram() histogram}.
     * @param histogram value for histogram
     * @return {@code this} builder for chained invocation
     */
    public final Builder histogram(LazyHistogram histogram) {
      this.histogram = Preconditions.checkNotNull(histogram);
      initializedBitset |= INITIALIZED_BIT_HISTOGRAM;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.HistogramMergedAggregateBase#totalMicros() totalMicros}.
     * @param totalMicros value for totalMicros
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalMicros(long totalMicros) {
      this.totalMicros = totalMicros;
      initializedBitset |= INITIALIZED_BIT_TOTAL_MICROS;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.HistogramMergedAggregateBase#transactionCount() transactionCount}.
     * @param transactionCount value for transactionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_COUNT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.HistogramMergedAggregate}.
     * @return immutable instance of HistogramMergedAggregate
     */
    public HistogramMergedAggregate build() {
      checkRequiredAttributes();
      return new HistogramMergedAggregate(this);
    }
  
    private boolean histogramIsSet() {
      return (initializedBitset & INITIALIZED_BIT_HISTOGRAM) != 0;
    }
  
    private boolean totalMicrosIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TOTAL_MICROS) != 0;
    }
  
    private boolean transactionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_COUNT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!histogramIsSet()) {
        attributes.add("histogram");
      }
      if (!totalMicrosIsSet()) {
        attributes.add("totalMicros");
      }
      if (!transactionCountIsSet()) {
        attributes.add("transactionCount");
      }
      return "Cannot build HistogramMergedAggregate, some of required attributes are not set " + attributes;
    }
  }
}
