package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.api.weaving.MethodModifier;
import org.glowroot.config.CaptureKind;

/**
 * Immutable implementation of {@link InstrumentationJsonService.InstrumentationConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code InstrumentationConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.InstrumentationConfigDtoBase"})
@Immutable
final class InstrumentationConfigDto
    extends InstrumentationJsonService.InstrumentationConfigDtoBase {
  private final String className;
  private final String methodName;
  private final ImmutableList<String> methodParameterTypes;
  private final Optional<String> methodReturnType;
  private final ImmutableList<MethodModifier> methodModifiers;
  private final CaptureKind captureKind;
  private final Optional<String> timerName;
  private final Optional<String> traceEntryTemplate;
  private final @Nullable Long traceEntryStackThresholdMillis;
  private final Optional<Boolean> traceEntryCaptureSelfNested;
  private final Optional<String> transactionType;
  private final Optional<String> transactionNameTemplate;
  private final Optional<String> transactionUserTemplate;
  private final ImmutableMap<String, String> transactionCustomAttributeTemplates;
  private final @Nullable Long traceStoreThresholdMillis;
  private final Optional<String> enabledProperty;
  private final Optional<String> traceEntryEnabledProperty;
  private final @Nullable String version;

  private InstrumentationConfigDto(InstrumentationConfigDto.Builder builder) {
    this.className = builder.className;
    this.methodName = builder.methodName;
    this.methodParameterTypes = builder.methodParameterTypesBuilder.build();
    this.methodReturnType = builder.methodReturnType;
    this.methodModifiers = builder.methodModifiersBuilder.build();
    this.captureKind = builder.captureKind;
    this.timerName = builder.timerName;
    this.traceEntryTemplate = builder.traceEntryTemplate;
    this.traceEntryStackThresholdMillis = builder.traceEntryStackThresholdMillis;
    this.traceEntryCaptureSelfNested = builder.traceEntryCaptureSelfNested;
    this.transactionType = builder.transactionType;
    this.transactionNameTemplate = builder.transactionNameTemplate;
    this.transactionUserTemplate = builder.transactionUserTemplate;
    this.transactionCustomAttributeTemplates = builder.transactionCustomAttributeTemplatesBuilder.build();
    this.traceStoreThresholdMillis = builder.traceStoreThresholdMillis;
    this.enabledProperty = builder.enabledProperty;
    this.traceEntryEnabledProperty = builder.traceEntryEnabledProperty;
    this.version = builder.version;
  }

  private InstrumentationConfigDto(
      InstrumentationConfigDto original,
      String className,
      String methodName,
      ImmutableList<String> methodParameterTypes,
      Optional<String> methodReturnType,
      ImmutableList<MethodModifier> methodModifiers,
      CaptureKind captureKind,
      Optional<String> timerName,
      Optional<String> traceEntryTemplate,
      @Nullable Long traceEntryStackThresholdMillis,
      Optional<Boolean> traceEntryCaptureSelfNested,
      Optional<String> transactionType,
      Optional<String> transactionNameTemplate,
      Optional<String> transactionUserTemplate,
      ImmutableMap<String, String> transactionCustomAttributeTemplates,
      @Nullable Long traceStoreThresholdMillis,
      Optional<String> enabledProperty,
      Optional<String> traceEntryEnabledProperty,
      @Nullable String version) {
    this.className = className;
    this.methodName = methodName;
    this.methodParameterTypes = methodParameterTypes;
    this.methodReturnType = methodReturnType;
    this.methodModifiers = methodModifiers;
    this.captureKind = captureKind;
    this.timerName = timerName;
    this.traceEntryTemplate = traceEntryTemplate;
    this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
    this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
    this.transactionType = transactionType;
    this.transactionNameTemplate = transactionNameTemplate;
    this.transactionUserTemplate = transactionUserTemplate;
    this.transactionCustomAttributeTemplates = transactionCustomAttributeTemplates;
    this.traceStoreThresholdMillis = traceStoreThresholdMillis;
    this.enabledProperty = enabledProperty;
    this.traceEntryEnabledProperty = traceEntryEnabledProperty;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code className} attribute
   */
  @JsonProperty("className")
  @Override
  public String className() {
    return className;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodName} attribute
   */
  @JsonProperty("methodName")
  @Override
  public String methodName() {
    return methodName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodParameterTypes} attribute
   */
  @JsonProperty("methodParameterTypes")
  @Override
  public ImmutableList<String> methodParameterTypes() {
    return methodParameterTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodReturnType} attribute
   */
  @JsonProperty("methodReturnType")
  @Override
  public Optional<String> methodReturnType() {
    return methodReturnType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodModifiers} attribute
   */
  @JsonProperty("methodModifiers")
  @Override
  public ImmutableList<MethodModifier> methodModifiers() {
    return methodModifiers;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureKind} attribute
   */
  @JsonProperty("captureKind")
  @Override
  public CaptureKind captureKind() {
    return captureKind;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timerName} attribute
   */
  @JsonProperty("timerName")
  @Override
  public Optional<String> timerName() {
    return timerName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryTemplate} attribute
   */
  @JsonProperty("traceEntryTemplate")
  @Override
  public Optional<String> traceEntryTemplate() {
    return traceEntryTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryStackThresholdMillis} attribute
   */
  @Nullable
  @JsonProperty("traceEntryStackThresholdMillis")
  @Override
  public Long traceEntryStackThresholdMillis() {
    return traceEntryStackThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryCaptureSelfNested} attribute
   */
  @JsonProperty("traceEntryCaptureSelfNested")
  @Override
  public Optional<Boolean> traceEntryCaptureSelfNested() {
    return traceEntryCaptureSelfNested;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public Optional<String> transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionNameTemplate} attribute
   */
  @JsonProperty("transactionNameTemplate")
  @Override
  public Optional<String> transactionNameTemplate() {
    return transactionNameTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionUserTemplate} attribute
   */
  @JsonProperty("transactionUserTemplate")
  @Override
  public Optional<String> transactionUserTemplate() {
    return transactionUserTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCustomAttributeTemplates} attribute
   */
  @JsonProperty("transactionCustomAttributeTemplates")
  @Override
  public ImmutableMap<String, String> transactionCustomAttributeTemplates() {
    return transactionCustomAttributeTemplates;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceStoreThresholdMillis} attribute
   */
  @Nullable
  @JsonProperty("traceStoreThresholdMillis")
  @Override
  public Long traceStoreThresholdMillis() {
    return traceStoreThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabledProperty} attribute
   */
  @JsonProperty("enabledProperty")
  @Override
  public Optional<String> enabledProperty() {
    return enabledProperty;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryEnabledProperty} attribute
   */
  @JsonProperty("traceEntryEnabledProperty")
  @Override
  public Optional<String> traceEntryEnabledProperty() {
    return traceEntryEnabledProperty;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @Nullable
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#className() className}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for className
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withClassName(String value) {
    if (this.className == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfigDto(
        this,
        newValue,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodName() methodName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for methodName
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withMethodName(String value) {
    if (this.methodName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        newValue,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodParameterTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        newValue,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodParameterTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodParameterTypes(Iterable<String> elements) {
    if (this.methodParameterTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        newValue,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodReturnType() methodReturnType}.
   * @param value value for methodReturnType
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodReturnType(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        newValue,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodReturnType() methodReturnType}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for methodReturnType
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodReturnType(Optional<String> optional) {
    if (this.methodReturnType == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        newValue,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodModifiers(MethodModifier... elements) {
    ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        newValue,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodModifiers elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodModifiers(Iterable<? extends MethodModifier> elements) {
    if (this.methodModifiers == elements) {
      return this;
    }
    ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        newValue,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#captureKind() captureKind}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureKind
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withCaptureKind(CaptureKind value) {
    if (this.captureKind == value) {
      return this;
    }
    CaptureKind newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        newValue,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#timerName() timerName}.
   * @param value value for timerName
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTimerName(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        newValue,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#timerName() timerName}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for timerName
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTimerName(Optional<String> optional) {
    if (this.timerName == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        newValue,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryTemplate() traceEntryTemplate}.
   * @param value value for traceEntryTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryTemplate(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        newValue,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryTemplate() traceEntryTemplate}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for traceEntryTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryTemplate(Optional<String> optional) {
    if (this.traceEntryTemplate == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        newValue,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryStackThresholdMillis() traceEntryStackThresholdMillis}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceEntryStackThresholdMillis, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryStackThresholdMillis(@Nullable Long value) {
    if (this.traceEntryStackThresholdMillis == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        newValue,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
   * @param value value for traceEntryCaptureSelfNested
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryCaptureSelfNested(boolean value) {
    Optional<Boolean> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        newValue,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for traceEntryCaptureSelfNested
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryCaptureSelfNested(Optional<Boolean> optional) {
    if (this.traceEntryCaptureSelfNested == optional) {
      return this;
    }
    Optional<Boolean> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        newValue,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionType() transactionType}.
   * @param value value for transactionType
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionType(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        newValue,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionType() transactionType}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for transactionType
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionType(Optional<String> optional) {
    if (this.transactionType == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        newValue,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionNameTemplate() transactionNameTemplate}.
   * @param value value for transactionNameTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionNameTemplate(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        newValue,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionNameTemplate() transactionNameTemplate}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for transactionNameTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionNameTemplate(Optional<String> optional) {
    if (this.transactionNameTemplate == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        newValue,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionUserTemplate() transactionUserTemplate}.
   * @param value value for transactionUserTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionUserTemplate(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        newValue,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionUserTemplate() transactionUserTemplate}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for transactionUserTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionUserTemplate(Optional<String> optional) {
    if (this.transactionUserTemplate == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        newValue,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by replacing {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to transactionCustomAttributeTemplates map
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
    if (this.transactionCustomAttributeTemplates == entries) {
      return this;
    }
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        newValue,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceStoreThresholdMillis, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withTraceStoreThresholdMillis(@Nullable Long value) {
    if (this.traceStoreThresholdMillis == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        newValue,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#enabledProperty() enabledProperty}.
   * @param value value for enabledProperty
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withEnabledProperty(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        newValue,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#enabledProperty() enabledProperty}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for enabledProperty
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withEnabledProperty(Optional<String> optional) {
    if (this.enabledProperty == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        newValue,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
   * @param value value for traceEntryEnabledProperty
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryEnabledProperty(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for traceEntryEnabledProperty
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryEnabledProperty(Optional<String> optional) {
    if (this.traceEntryEnabledProperty == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withVersion(@Nullable String value) {
    if (this.version == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new InstrumentationConfigDto(
        this,
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code InstrumentationConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof InstrumentationConfigDto && equalTo((InstrumentationConfigDto) another));
  }
  
  private boolean equalTo(InstrumentationConfigDto another) {
    return className.equals(another.className)
        && methodName.equals(another.methodName)
        && methodParameterTypes.equals(another.methodParameterTypes)
        && methodReturnType.equals(another.methodReturnType)
        && methodModifiers.equals(another.methodModifiers)
        && captureKind.equals(another.captureKind)
        && timerName.equals(another.timerName)
        && traceEntryTemplate.equals(another.traceEntryTemplate)
        && Objects.equal(traceEntryStackThresholdMillis, another.traceEntryStackThresholdMillis)
        && traceEntryCaptureSelfNested.equals(another.traceEntryCaptureSelfNested)
        && transactionType.equals(another.transactionType)
        && transactionNameTemplate.equals(another.transactionNameTemplate)
        && transactionUserTemplate.equals(another.transactionUserTemplate)
        && transactionCustomAttributeTemplates.equals(another.transactionCustomAttributeTemplates)
        && Objects.equal(traceStoreThresholdMillis, another.traceStoreThresholdMillis)
        && enabledProperty.equals(another.enabledProperty)
        && traceEntryEnabledProperty.equals(another.traceEntryEnabledProperty)
        && Objects.equal(version, another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code className}, {@code methodName}, {@code methodParameterTypes}, {@code methodReturnType}, {@code methodModifiers}, {@code captureKind}, {@code timerName}, {@code traceEntryTemplate}, {@code traceEntryStackThresholdMillis}, {@code traceEntryCaptureSelfNested}, {@code transactionType}, {@code transactionNameTemplate}, {@code transactionUserTemplate}, {@code transactionCustomAttributeTemplates}, {@code traceStoreThresholdMillis}, {@code enabledProperty}, {@code traceEntryEnabledProperty}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + className.hashCode();
    h = h * 17 + methodName.hashCode();
    h = h * 17 + methodParameterTypes.hashCode();
    h = h * 17 + methodReturnType.hashCode();
    h = h * 17 + methodModifiers.hashCode();
    h = h * 17 + captureKind.hashCode();
    h = h * 17 + timerName.hashCode();
    h = h * 17 + traceEntryTemplate.hashCode();
    h = h * 17 + Objects.hashCode(traceEntryStackThresholdMillis);
    h = h * 17 + traceEntryCaptureSelfNested.hashCode();
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + transactionNameTemplate.hashCode();
    h = h * 17 + transactionUserTemplate.hashCode();
    h = h * 17 + transactionCustomAttributeTemplates.hashCode();
    h = h * 17 + Objects.hashCode(traceStoreThresholdMillis);
    h = h * 17 + enabledProperty.hashCode();
    h = h * 17 + traceEntryEnabledProperty.hashCode();
    h = h * 17 + Objects.hashCode(version);
    return h;
  }
  
  /**
   * Prints immutable value {@code InstrumentationConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstrumentationConfigDto")
        .add("className", className)
        .add("methodName", methodName)
        .add("methodParameterTypes", methodParameterTypes)
        .add("methodReturnType", methodReturnType)
        .add("methodModifiers", methodModifiers)
        .add("captureKind", captureKind)
        .add("timerName", timerName)
        .add("traceEntryTemplate", traceEntryTemplate)
        .add("traceEntryStackThresholdMillis", traceEntryStackThresholdMillis)
        .add("traceEntryCaptureSelfNested", traceEntryCaptureSelfNested)
        .add("transactionType", transactionType)
        .add("transactionNameTemplate", transactionNameTemplate)
        .add("transactionUserTemplate", transactionUserTemplate)
        .add("transactionCustomAttributeTemplates", transactionCustomAttributeTemplates)
        .add("traceStoreThresholdMillis", traceStoreThresholdMillis)
        .add("enabledProperty", enabledProperty)
        .add("traceEntryEnabledProperty", traceEntryEnabledProperty)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static InstrumentationConfigDto fromAllAttributes(
      @JsonProperty("className") @Nullable String className,
      @JsonProperty("methodName") @Nullable String methodName,
      @JsonProperty("methodParameterTypes") @Nullable ImmutableList<String> methodParameterTypes,
      @JsonProperty("methodReturnType") @Nullable Optional<String> methodReturnType,
      @JsonProperty("methodModifiers") @Nullable ImmutableList<MethodModifier> methodModifiers,
      @JsonProperty("captureKind") @Nullable CaptureKind captureKind,
      @JsonProperty("timerName") @Nullable Optional<String> timerName,
      @JsonProperty("traceEntryTemplate") @Nullable Optional<String> traceEntryTemplate,
      @JsonProperty("traceEntryStackThresholdMillis") @Nullable Long traceEntryStackThresholdMillis,
      @JsonProperty("traceEntryCaptureSelfNested") @Nullable Optional<Boolean> traceEntryCaptureSelfNested,
      @JsonProperty("transactionType") @Nullable Optional<String> transactionType,
      @JsonProperty("transactionNameTemplate") @Nullable Optional<String> transactionNameTemplate,
      @JsonProperty("transactionUserTemplate") @Nullable Optional<String> transactionUserTemplate,
      @JsonProperty("transactionCustomAttributeTemplates") @Nullable Map<String, String> transactionCustomAttributeTemplates,
      @JsonProperty("traceStoreThresholdMillis") @Nullable Long traceStoreThresholdMillis,
      @JsonProperty("enabledProperty") @Nullable Optional<String> enabledProperty,
      @JsonProperty("traceEntryEnabledProperty") @Nullable Optional<String> traceEntryEnabledProperty,
      @JsonProperty("version") @Nullable String version) {
    InstrumentationConfigDto.Builder builder = InstrumentationConfigDto.builder();
    if (className != null) {
      builder.className(className);
    }
    if (methodName != null) {
      builder.methodName(methodName);
    }
    if (methodParameterTypes != null) {
      builder.addAllMethodParameterTypes(methodParameterTypes);
    }
    if (methodReturnType != null) {
      builder.methodReturnType(methodReturnType);
    }
    if (methodModifiers != null) {
      builder.addAllMethodModifiers(methodModifiers);
    }
    if (captureKind != null) {
      builder.captureKind(captureKind);
    }
    if (timerName != null) {
      builder.timerName(timerName);
    }
    if (traceEntryTemplate != null) {
      builder.traceEntryTemplate(traceEntryTemplate);
    }
    if (traceEntryStackThresholdMillis != null) {
      builder.traceEntryStackThresholdMillis(traceEntryStackThresholdMillis);
    }
    if (traceEntryCaptureSelfNested != null) {
      builder.traceEntryCaptureSelfNested(traceEntryCaptureSelfNested);
    }
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (transactionNameTemplate != null) {
      builder.transactionNameTemplate(transactionNameTemplate);
    }
    if (transactionUserTemplate != null) {
      builder.transactionUserTemplate(transactionUserTemplate);
    }
    if (transactionCustomAttributeTemplates != null) {
      builder.putAllTransactionCustomAttributeTemplates(transactionCustomAttributeTemplates);
    }
    if (traceStoreThresholdMillis != null) {
      builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
    }
    if (enabledProperty != null) {
      builder.enabledProperty(enabledProperty);
    }
    if (traceEntryEnabledProperty != null) {
      builder.traceEntryEnabledProperty(traceEntryEnabledProperty);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.InstrumentationConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable InstrumentationConfigDto instance
   */
  static InstrumentationConfigDto copyOf(InstrumentationJsonService.InstrumentationConfigDtoBase instance) {
    if (instance instanceof InstrumentationConfigDto) {
      return (InstrumentationConfigDto) instance;
    }
    return InstrumentationConfigDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.InstrumentationConfigDto}.
   * @return new InstrumentationConfigDto builder
   */
  static InstrumentationConfigDto.Builder builder() {
    return new InstrumentationConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.InstrumentationConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_CLASS_NAME = 0x1L;
    private static final long INITIALIZED_BIT_METHOD_NAME = 0x2L;
    private static final long INITIALIZED_BIT_CAPTURE_KIND = 0x4L;
    private long initializedBitset;
  
    private @Nullable String className;
    private @Nullable String methodName;
    private ImmutableList.Builder<String> methodParameterTypesBuilder = ImmutableList.builder();
    private Optional<String> methodReturnType = Optional.absent();
    private ImmutableList.Builder<MethodModifier> methodModifiersBuilder = ImmutableList.builder();
    private @Nullable CaptureKind captureKind;
    private Optional<String> timerName = Optional.absent();
    private Optional<String> traceEntryTemplate = Optional.absent();
    private @Nullable Long traceEntryStackThresholdMillis;
    private Optional<Boolean> traceEntryCaptureSelfNested = Optional.absent();
    private Optional<String> transactionType = Optional.absent();
    private Optional<String> transactionNameTemplate = Optional.absent();
    private Optional<String> transactionUserTemplate = Optional.absent();
    private ImmutableMap.Builder<String, String> transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
    private @Nullable Long traceStoreThresholdMillis;
    private Optional<String> enabledProperty = Optional.absent();
    private Optional<String> traceEntryEnabledProperty = Optional.absent();
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link InstrumentationJsonService.InstrumentationConfigDtoBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(InstrumentationJsonService.InstrumentationConfigDtoBase instance) {
      Preconditions.checkNotNull(instance);
      className(instance.className());
      methodName(instance.methodName());
      addAllMethodParameterTypes(instance.methodParameterTypes());
      Optional<String> methodReturnTypeOptional = instance.methodReturnType();
      if (methodReturnTypeOptional.isPresent()) {
        methodReturnType(methodReturnTypeOptional);
      }
      addAllMethodModifiers(instance.methodModifiers());
      captureKind(instance.captureKind());
      Optional<String> timerNameOptional = instance.timerName();
      if (timerNameOptional.isPresent()) {
        timerName(timerNameOptional);
      }
      Optional<String> traceEntryTemplateOptional = instance.traceEntryTemplate();
      if (traceEntryTemplateOptional.isPresent()) {
        traceEntryTemplate(traceEntryTemplateOptional);
      }
      @Nullable Long traceEntryStackThresholdMillisValue = instance.traceEntryStackThresholdMillis();
      if (traceEntryStackThresholdMillisValue != null) {
        traceEntryStackThresholdMillis(traceEntryStackThresholdMillisValue);
      }
      Optional<Boolean> traceEntryCaptureSelfNestedOptional = instance.traceEntryCaptureSelfNested();
      if (traceEntryCaptureSelfNestedOptional.isPresent()) {
        traceEntryCaptureSelfNested(traceEntryCaptureSelfNestedOptional);
      }
      Optional<String> transactionTypeOptional = instance.transactionType();
      if (transactionTypeOptional.isPresent()) {
        transactionType(transactionTypeOptional);
      }
      Optional<String> transactionNameTemplateOptional = instance.transactionNameTemplate();
      if (transactionNameTemplateOptional.isPresent()) {
        transactionNameTemplate(transactionNameTemplateOptional);
      }
      Optional<String> transactionUserTemplateOptional = instance.transactionUserTemplate();
      if (transactionUserTemplateOptional.isPresent()) {
        transactionUserTemplate(transactionUserTemplateOptional);
      }
      putAllTransactionCustomAttributeTemplates(instance.transactionCustomAttributeTemplates());
      @Nullable Long traceStoreThresholdMillisValue = instance.traceStoreThresholdMillis();
      if (traceStoreThresholdMillisValue != null) {
        traceStoreThresholdMillis(traceStoreThresholdMillisValue);
      }
      Optional<String> enabledPropertyOptional = instance.enabledProperty();
      if (enabledPropertyOptional.isPresent()) {
        enabledProperty(enabledPropertyOptional);
      }
      Optional<String> traceEntryEnabledPropertyOptional = instance.traceEntryEnabledProperty();
      if (traceEntryEnabledPropertyOptional.isPresent()) {
        traceEntryEnabledProperty(traceEntryEnabledPropertyOptional);
      }
      @Nullable String versionValue = instance.version();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#className() className}.
     * @param className value for className
     * @return {@code this} builder for chained invocation
     */
    public final Builder className(String className) {
      this.className = Preconditions.checkNotNull(className);
      initializedBitset |= INITIALIZED_BIT_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodName() methodName}.
     * @param methodName value for methodName
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodName(String methodName) {
      this.methodName = Preconditions.checkNotNull(methodName);
      initializedBitset |= INITIALIZED_BIT_METHOD_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes} list.
     * @param element methodParameterTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodParameterTypes(String element) {
      methodParameterTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes} list.
     * @param elements array of methodParameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodParameterTypes(String... elements) {
      methodParameterTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes} list.
     * @param elements iterable of methodParameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodParameterTypes(Iterable<String> elements) {
      methodParameterTypesBuilder = ImmutableList.builder();
      return addAllMethodParameterTypes(elements);
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes} list.
     * @param elements iterable of methodParameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodParameterTypes(Iterable<String> elements) {
      methodParameterTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodReturnType() methodReturnType}.
     * @param methodReturnType value for methodReturnType
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodReturnType(String methodReturnType) {
      this.methodReturnType = Optional.of(methodReturnType);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodReturnType() methodReturnType}.
     * @param methodReturnType value for methodReturnType
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodReturnType(Optional<String> methodReturnType) {
      this.methodReturnType = Preconditions.checkNotNull(methodReturnType);
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers} list.
     * @param element methodModifiers element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodModifiers(MethodModifier element) {
      methodModifiersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers} list.
     * @param elements array of methodModifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodModifiers(MethodModifier... elements) {
      methodModifiersBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers} list.
     * @param elements iterable of methodModifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodModifiers(Iterable<? extends MethodModifier> elements) {
      methodModifiersBuilder = ImmutableList.builder();
      return addAllMethodModifiers(elements);
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers} list.
     * @param elements iterable of methodModifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodModifiers(Iterable<? extends MethodModifier> elements) {
      methodModifiersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#captureKind() captureKind}.
     * @param captureKind value for captureKind
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureKind(CaptureKind captureKind) {
      this.captureKind = Preconditions.checkNotNull(captureKind);
      initializedBitset |= INITIALIZED_BIT_CAPTURE_KIND;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#timerName() timerName}.
     * @param timerName value for timerName
     * @return {@code this} builder for chained invocation
     */
    public final Builder timerName(String timerName) {
      this.timerName = Optional.of(timerName);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#timerName() timerName}.
     * @param timerName value for timerName
     * @return {@code this} builder for chained invocation
     */
    public final Builder timerName(Optional<String> timerName) {
      this.timerName = Preconditions.checkNotNull(timerName);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryTemplate() traceEntryTemplate}.
     * @param traceEntryTemplate value for traceEntryTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryTemplate(String traceEntryTemplate) {
      this.traceEntryTemplate = Optional.of(traceEntryTemplate);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryTemplate() traceEntryTemplate}.
     * @param traceEntryTemplate value for traceEntryTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryTemplate(Optional<String> traceEntryTemplate) {
      this.traceEntryTemplate = Preconditions.checkNotNull(traceEntryTemplate);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryStackThresholdMillis() traceEntryStackThresholdMillis}.
     * @param traceEntryStackThresholdMillis value for traceEntryStackThresholdMillis, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryStackThresholdMillis(@Nullable Long traceEntryStackThresholdMillis) {
      this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
     * @param traceEntryCaptureSelfNested value for traceEntryCaptureSelfNested
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryCaptureSelfNested(boolean traceEntryCaptureSelfNested) {
      this.traceEntryCaptureSelfNested = Optional.of(traceEntryCaptureSelfNested);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
     * @param traceEntryCaptureSelfNested value for traceEntryCaptureSelfNested
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryCaptureSelfNested(Optional<Boolean> traceEntryCaptureSelfNested) {
      this.traceEntryCaptureSelfNested = Preconditions.checkNotNull(traceEntryCaptureSelfNested);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      this.transactionType = Optional.of(transactionType);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(Optional<String> transactionType) {
      this.transactionType = Preconditions.checkNotNull(transactionType);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionNameTemplate() transactionNameTemplate}.
     * @param transactionNameTemplate value for transactionNameTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionNameTemplate(String transactionNameTemplate) {
      this.transactionNameTemplate = Optional.of(transactionNameTemplate);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionNameTemplate() transactionNameTemplate}.
     * @param transactionNameTemplate value for transactionNameTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionNameTemplate(Optional<String> transactionNameTemplate) {
      this.transactionNameTemplate = Preconditions.checkNotNull(transactionNameTemplate);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionUserTemplate() transactionUserTemplate}.
     * @param transactionUserTemplate value for transactionUserTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionUserTemplate(String transactionUserTemplate) {
      this.transactionUserTemplate = Optional.of(transactionUserTemplate);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionUserTemplate() transactionUserTemplate}.
     * @param transactionUserTemplate value for transactionUserTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionUserTemplate(Optional<String> transactionUserTemplate) {
      this.transactionUserTemplate = Preconditions.checkNotNull(transactionUserTemplate);
      return this;
    }
  
    /**
     * Put one entry to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map.
     * @param key the key in transactionCustomAttributeTemplates map
     * @param value the associated value in transactionCustomAttributeTemplates map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putTransactionCustomAttributeTemplates(String key, String value) {
      transactionCustomAttributeTemplatesBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putTransactionCustomAttributeTemplates(Map.Entry<String, ? extends String> entry) {
      transactionCustomAttributeTemplatesBuilder.put(entry);
      return this;
    }
  
    /**
     * Sets or replaces all mappings from specified map as entries for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map. Nulls are not permitted
     * @param entries to be added to transactionCustomAttributeTemplates map
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
      transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
      return putAllTransactionCustomAttributeTemplates(entries);
    }
  
    /**
     * Put all mappings from specified map as entries to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map. Nulls are not permitted
     * @param entries to be added to transactionCustomAttributeTemplates map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
      transactionCustomAttributeTemplatesBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.
     * @param traceStoreThresholdMillis value for traceStoreThresholdMillis, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceStoreThresholdMillis(@Nullable Long traceStoreThresholdMillis) {
      this.traceStoreThresholdMillis = traceStoreThresholdMillis;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#enabledProperty() enabledProperty}.
     * @param enabledProperty value for enabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabledProperty(String enabledProperty) {
      this.enabledProperty = Optional.of(enabledProperty);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#enabledProperty() enabledProperty}.
     * @param enabledProperty value for enabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabledProperty(Optional<String> enabledProperty) {
      this.enabledProperty = Preconditions.checkNotNull(enabledProperty);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
     * @param traceEntryEnabledProperty value for traceEntryEnabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryEnabledProperty(String traceEntryEnabledProperty) {
      this.traceEntryEnabledProperty = Optional.of(traceEntryEnabledProperty);
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
     * @param traceEntryEnabledProperty value for traceEntryEnabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryEnabledProperty(Optional<String> traceEntryEnabledProperty) {
      this.traceEntryEnabledProperty = Preconditions.checkNotNull(traceEntryEnabledProperty);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#version() version}.
     * @param version value for version, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.InstrumentationConfigDto}.
     * @return immutable instance of InstrumentationConfigDto
     */
    public org.glowroot.local.ui.InstrumentationConfigDto build() {
      checkRequiredAttributes();
      return new InstrumentationConfigDto(this);
    }
  
    private boolean classNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CLASS_NAME) != 0;
    }
  
    private boolean methodNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_METHOD_NAME) != 0;
    }
  
    private boolean captureKindIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_KIND) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!classNameIsSet()) {
        attributes.add("className");
      }
      if (!methodNameIsSet()) {
        attributes.add("methodName");
      }
      if (!captureKindIsSet()) {
        attributes.add("captureKind");
      }
      return "Cannot build InstrumentationConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
