package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstrumentationJsonService.InstrumentationConfigResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code InstrumentationConfigResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.InstrumentationConfigResponseBase"})
@Immutable
final class InstrumentationConfigResponse
    extends InstrumentationJsonService.InstrumentationConfigResponseBase {
  private final InstrumentationConfigDto config;
  private final ImmutableList<MethodSignature> methodSignatures;

  private InstrumentationConfigResponse(InstrumentationConfigResponse.Builder builder) {
    this.config = builder.config;
    this.methodSignatures = builder.methodSignaturesBuilder.build();
  }

  private InstrumentationConfigResponse(
      InstrumentationConfigResponse original,
      InstrumentationConfigDto config,
      ImmutableList<MethodSignature> methodSignatures) {
    this.config = config;
    this.methodSignatures = methodSignatures;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public InstrumentationConfigDto config() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodSignatures} attribute
   */
  @JsonProperty("methodSignatures")
  @Override
  public ImmutableList<MethodSignature> methodSignatures() {
    return methodSignatures;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigResponseBase#config() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigResponse withConfig(InstrumentationConfigDto value) {
    if (this.config == value) {
      return this;
    }
    InstrumentationConfigDto newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfigResponse(this, newValue, this.methodSignatures);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigResponse withMethodSignatures(MethodSignature... elements) {
    ImmutableList<MethodSignature> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigResponse(this, this.config, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodSignatures elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigResponse withMethodSignatures(Iterable<? extends MethodSignature> elements) {
    if (this.methodSignatures == elements) {
      return this;
    }
    ImmutableList<MethodSignature> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigResponse(this, this.config, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code InstrumentationConfigResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof InstrumentationConfigResponse && equalTo((InstrumentationConfigResponse) another));
  }
  
  private boolean equalTo(InstrumentationConfigResponse another) {
    return config.equals(another.config)
        && methodSignatures.equals(another.methodSignatures);
  }
  
  /**
   * Computes hash code from attributes: {@code config}, {@code methodSignatures}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + methodSignatures.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code InstrumentationConfigResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstrumentationConfigResponse")
        .add("config", config)
        .add("methodSignatures", methodSignatures)
        .toString();
  }
  
  @JsonCreator
  public static InstrumentationConfigResponse fromAllAttributes(
      @JsonProperty("config") @Nullable InstrumentationConfigDto config,
      @JsonProperty("methodSignatures") @Nullable ImmutableList<MethodSignature> methodSignatures) {
    InstrumentationConfigResponse.Builder builder = InstrumentationConfigResponse.builder();
    if (config != null) {
      builder.config(config);
    }
    if (methodSignatures != null) {
      builder.addAllMethodSignatures(methodSignatures);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.InstrumentationConfigResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable InstrumentationConfigResponse instance
   */
  static InstrumentationConfigResponse copyOf(InstrumentationJsonService.InstrumentationConfigResponseBase instance) {
    if (instance instanceof InstrumentationConfigResponse) {
      return (InstrumentationConfigResponse) instance;
    }
    return InstrumentationConfigResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.InstrumentationConfigResponse}.
   * @return new InstrumentationConfigResponse builder
   */
  static InstrumentationConfigResponse.Builder builder() {
    return new InstrumentationConfigResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.InstrumentationConfigResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_CONFIG = 0x1L;
    private long initializedBitset;
  
    private @Nullable InstrumentationConfigDto config;
    private ImmutableList.Builder<MethodSignature> methodSignaturesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link InstrumentationJsonService.InstrumentationConfigResponseBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(InstrumentationJsonService.InstrumentationConfigResponseBase instance) {
      Preconditions.checkNotNull(instance);
      config(instance.config());
      addAllMethodSignatures(instance.methodSignatures());
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigResponseBase#config() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(InstrumentationConfigDto config) {
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures} list.
     * @param element methodSignatures element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodSignatures(MethodSignature element) {
      methodSignaturesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures} list.
     * @param elements array of methodSignatures elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodSignatures(MethodSignature... elements) {
      methodSignaturesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures} list.
     * @param elements iterable of methodSignatures elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodSignatures(Iterable<? extends MethodSignature> elements) {
      methodSignaturesBuilder = ImmutableList.builder();
      return addAllMethodSignatures(elements);
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures} list.
     * @param elements iterable of methodSignatures elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodSignatures(Iterable<? extends MethodSignature> elements) {
      methodSignaturesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.InstrumentationConfigResponse}.
     * @return immutable instance of InstrumentationConfigResponse
     */
    public org.glowroot.local.ui.InstrumentationConfigResponse build() {
      checkRequiredAttributes();
      return new InstrumentationConfigResponse(this);
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!configIsSet()) {
        attributes.add("config");
      }
      return "Cannot build InstrumentationConfigResponse, some of required attributes are not set " + attributes;
    }
  }
}
