package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstrumentationJsonService.MethodSignatureBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MethodSignature.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.MethodSignatureBase"})
@Immutable
final class MethodSignature extends InstrumentationJsonService.MethodSignatureBase {
  private final String name;
  private final ImmutableList<String> parameterTypes;
  private final String returnType;
  private final ImmutableList<String> modifiers;

  private MethodSignature(MethodSignature.Builder builder) {
    this.name = builder.name;
    this.parameterTypes = builder.parameterTypesBuilder.build();
    this.returnType = builder.returnType;
    this.modifiers = builder.modifiersBuilder.build();
  }

  private MethodSignature(
      MethodSignature original,
      String name,
      ImmutableList<String> parameterTypes,
      String returnType,
      ImmutableList<String> modifiers) {
    this.name = name;
    this.parameterTypes = parameterTypes;
    this.returnType = returnType;
    this.modifiers = modifiers;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code parameterTypes} attribute
   */
  @JsonProperty("parameterTypes")
  @Override
  public ImmutableList<String> parameterTypes() {
    return parameterTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code returnType} attribute
   */
  @JsonProperty("returnType")
  @Override
  public String returnType() {
    return returnType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code modifiers} attribute
   */
  @JsonProperty("modifiers")
  @Override
  public ImmutableList<String> modifiers() {
    return modifiers;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.MethodSignatureBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final MethodSignature withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MethodSignature(this, newValue, this.parameterTypes, this.returnType, this.modifiers);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.MethodSignatureBase#parameterTypes() parameterTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final MethodSignature withParameterTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MethodSignature(this, this.name, newValue, this.returnType, this.modifiers);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.MethodSignatureBase#parameterTypes() parameterTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of parameterTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final MethodSignature withParameterTypes(Iterable<String> elements) {
    if (this.parameterTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MethodSignature(this, this.name, newValue, this.returnType, this.modifiers);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.MethodSignatureBase#returnType() returnType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for returnType
   * @return modified copy of the {@code this} object
   */
  public final MethodSignature withReturnType(String value) {
    if (this.returnType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MethodSignature(this, this.name, this.parameterTypes, newValue, this.modifiers);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.MethodSignatureBase#modifiers() modifiers}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final MethodSignature withModifiers(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MethodSignature(this, this.name, this.parameterTypes, this.returnType, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.MethodSignatureBase#modifiers() modifiers}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of modifiers elements to set
   * @return modified copy of {@code this} object
   */
  public final MethodSignature withModifiers(Iterable<String> elements) {
    if (this.modifiers == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MethodSignature(this, this.name, this.parameterTypes, this.returnType, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MethodSignature} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MethodSignature && equalTo((MethodSignature) another));
  }
  
  private boolean equalTo(MethodSignature another) {
    return name.equals(another.name)
        && parameterTypes.equals(another.parameterTypes)
        && returnType.equals(another.returnType)
        && modifiers.equals(another.modifiers);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code parameterTypes}, {@code returnType}, {@code modifiers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + parameterTypes.hashCode();
    h = h * 17 + returnType.hashCode();
    h = h * 17 + modifiers.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code MethodSignature{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MethodSignature")
        .add("name", name)
        .add("parameterTypes", parameterTypes)
        .add("returnType", returnType)
        .add("modifiers", modifiers)
        .toString();
  }
  
  @JsonCreator
  public static MethodSignature fromAllAttributes(
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("parameterTypes") @Nullable ImmutableList<String> parameterTypes,
      @JsonProperty("returnType") @Nullable String returnType,
      @JsonProperty("modifiers") @Nullable ImmutableList<String> modifiers) {
    MethodSignature.Builder builder = MethodSignature.builder();
    if (name != null) {
      builder.name(name);
    }
    if (parameterTypes != null) {
      builder.addAllParameterTypes(parameterTypes);
    }
    if (returnType != null) {
      builder.returnType(returnType);
    }
    if (modifiers != null) {
      builder.addAllModifiers(modifiers);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.MethodSignatureBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable MethodSignature instance
   */
  static MethodSignature copyOf(InstrumentationJsonService.MethodSignatureBase instance) {
    if (instance instanceof MethodSignature) {
      return (MethodSignature) instance;
    }
    return MethodSignature.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.MethodSignature}.
   * @return new MethodSignature builder
   */
  static MethodSignature.Builder builder() {
    return new MethodSignature.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.MethodSignature}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_RETURN_TYPE = 0x2L;
    private long initializedBitset;
  
    private @Nullable String name;
    private ImmutableList.Builder<String> parameterTypesBuilder = ImmutableList.builder();
    private @Nullable String returnType;
    private ImmutableList.Builder<String> modifiersBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link InstrumentationJsonService.MethodSignatureBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(InstrumentationJsonService.MethodSignatureBase instance) {
      Preconditions.checkNotNull(instance);
      name(instance.name());
      addAllParameterTypes(instance.parameterTypes());
      returnType(instance.returnType());
      addAllModifiers(instance.modifiers());
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.MethodSignatureBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.MethodSignatureBase#parameterTypes() parameterTypes} list.
     * @param element parameterTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addParameterTypes(String element) {
      parameterTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.MethodSignatureBase#parameterTypes() parameterTypes} list.
     * @param elements array of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addParameterTypes(String... elements) {
      parameterTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link InstrumentationJsonService.MethodSignatureBase#parameterTypes() parameterTypes} list.
     * @param elements iterable of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder parameterTypes(Iterable<String> elements) {
      parameterTypesBuilder = ImmutableList.builder();
      return addAllParameterTypes(elements);
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.MethodSignatureBase#parameterTypes() parameterTypes} list.
     * @param elements iterable of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllParameterTypes(Iterable<String> elements) {
      parameterTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.MethodSignatureBase#returnType() returnType}.
     * @param returnType value for returnType
     * @return {@code this} builder for chained invocation
     */
    public final Builder returnType(String returnType) {
      this.returnType = Preconditions.checkNotNull(returnType);
      initializedBitset |= INITIALIZED_BIT_RETURN_TYPE;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.MethodSignatureBase#modifiers() modifiers} list.
     * @param element modifiers element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addModifiers(String element) {
      modifiersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.MethodSignatureBase#modifiers() modifiers} list.
     * @param elements array of modifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addModifiers(String... elements) {
      modifiersBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link InstrumentationJsonService.MethodSignatureBase#modifiers() modifiers} list.
     * @param elements iterable of modifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder modifiers(Iterable<String> elements) {
      modifiersBuilder = ImmutableList.builder();
      return addAllModifiers(elements);
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.MethodSignatureBase#modifiers() modifiers} list.
     * @param elements iterable of modifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllModifiers(Iterable<String> elements) {
      modifiersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.MethodSignature}.
     * @return immutable instance of MethodSignature
     */
    public org.glowroot.local.ui.MethodSignature build() {
      checkRequiredAttributes();
      return new MethodSignature(this);
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean returnTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_RETURN_TYPE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!returnTypeIsSet()) {
        attributes.add("returnType");
      }
      return "Cannot build MethodSignature, some of required attributes are not set " + attributes;
    }
  }
}
