package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstrumentationJsonService.MethodSignaturesRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MethodSignaturesRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.MethodSignaturesRequestBase"})
@Immutable
final class MethodSignaturesRequest
    extends InstrumentationJsonService.MethodSignaturesRequestBase {
  private final String className;
  private final String methodName;

  private MethodSignaturesRequest(MethodSignaturesRequest.Builder builder) {
    this.className = builder.className;
    this.methodName = builder.methodName;
  }

  private MethodSignaturesRequest(MethodSignaturesRequest original, String className, String methodName) {
    this.className = className;
    this.methodName = methodName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code className} attribute
   */
  @JsonProperty("className")
  @Override
  public String className() {
    return className;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodName} attribute
   */
  @JsonProperty("methodName")
  @Override
  public String methodName() {
    return methodName;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.MethodSignaturesRequestBase#className() className}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for className
   * @return modified copy of the {@code this} object
   */
  public final MethodSignaturesRequest withClassName(String value) {
    if (this.className == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MethodSignaturesRequest(this, newValue, this.methodName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.MethodSignaturesRequestBase#methodName() methodName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for methodName
   * @return modified copy of the {@code this} object
   */
  public final MethodSignaturesRequest withMethodName(String value) {
    if (this.methodName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MethodSignaturesRequest(this, this.className, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MethodSignaturesRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MethodSignaturesRequest && equalTo((MethodSignaturesRequest) another));
  }
  
  private boolean equalTo(MethodSignaturesRequest another) {
    return className.equals(another.className)
        && methodName.equals(another.methodName);
  }
  
  /**
   * Computes hash code from attributes: {@code className}, {@code methodName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + className.hashCode();
    h = h * 17 + methodName.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code MethodSignaturesRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MethodSignaturesRequest")
        .add("className", className)
        .add("methodName", methodName)
        .toString();
  }
  
  @JsonCreator
  public static MethodSignaturesRequest fromAllAttributes(
      @JsonProperty("className") @Nullable String className,
      @JsonProperty("methodName") @Nullable String methodName) {
    MethodSignaturesRequest.Builder builder = MethodSignaturesRequest.builder();
    if (className != null) {
      builder.className(className);
    }
    if (methodName != null) {
      builder.methodName(methodName);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.MethodSignaturesRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable MethodSignaturesRequest instance
   */
  static MethodSignaturesRequest copyOf(InstrumentationJsonService.MethodSignaturesRequestBase instance) {
    if (instance instanceof MethodSignaturesRequest) {
      return (MethodSignaturesRequest) instance;
    }
    return MethodSignaturesRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.MethodSignaturesRequest}.
   * @return new MethodSignaturesRequest builder
   */
  static MethodSignaturesRequest.Builder builder() {
    return new MethodSignaturesRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.MethodSignaturesRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_CLASS_NAME = 0x1L;
    private static final long INITIALIZED_BIT_METHOD_NAME = 0x2L;
    private long initializedBitset;
  
    private @Nullable String className;
    private @Nullable String methodName;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link InstrumentationJsonService.MethodSignaturesRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(InstrumentationJsonService.MethodSignaturesRequestBase instance) {
      Preconditions.checkNotNull(instance);
      className(instance.className());
      methodName(instance.methodName());
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.MethodSignaturesRequestBase#className() className}.
     * @param className value for className
     * @return {@code this} builder for chained invocation
     */
    public final Builder className(String className) {
      this.className = Preconditions.checkNotNull(className);
      initializedBitset |= INITIALIZED_BIT_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.MethodSignaturesRequestBase#methodName() methodName}.
     * @param methodName value for methodName
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodName(String methodName) {
      this.methodName = Preconditions.checkNotNull(methodName);
      initializedBitset |= INITIALIZED_BIT_METHOD_NAME;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.MethodSignaturesRequest}.
     * @return immutable instance of MethodSignaturesRequest
     */
    public org.glowroot.local.ui.MethodSignaturesRequest build() {
      checkRequiredAttributes();
      return new MethodSignaturesRequest(this);
    }
  
    private boolean classNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CLASS_NAME) != 0;
    }
  
    private boolean methodNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_METHOD_NAME) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!classNameIsSet()) {
        attributes.add("className");
      }
      if (!methodNameIsSet()) {
        attributes.add("methodName");
      }
      return "Cannot build MethodSignaturesRequest, some of required attributes are not set " + attributes;
    }
  }
}
