package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.PropertyValue;

/**
 * Immutable implementation of {@link ConfigJsonService.PluginConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PluginConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.PluginConfigDtoBase"})
@Immutable
final class PluginConfigDto extends ConfigJsonService.PluginConfigDtoBase {
  private final boolean enabled;
  private final ImmutableMap<String, PropertyValue> properties;
  private final String version;

  private PluginConfigDto(PluginConfigDto.Builder builder) {
    this.enabled = builder.enabled;
    this.properties = builder.propertiesBuilder.build();
    this.version = builder.version;
  }

  private PluginConfigDto(
      PluginConfigDto original,
      boolean enabled,
      ImmutableMap<String, PropertyValue> properties,
      String version) {
    this.enabled = enabled;
    this.properties = properties;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public boolean enabled() {
    return enabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public ImmutableMap<String, PropertyValue> properties() {
    return properties;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.PluginConfigDtoBase#enabled() enabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enabled
   * @return modified copy of the {@code this} object
   */
  public final PluginConfigDto withEnabled(boolean value) {
    if (this.enabled == value) {
      return this;
    }
    boolean newValue = value;
    return new PluginConfigDto(this, newValue, this.properties, this.version);
  }
  
  /**
   * Copy current immutable object by replacing {@link ConfigJsonService.PluginConfigDtoBase#properties() properties} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to properties map
   * @return modified copy of {@code this} object
   */
  public final PluginConfigDto withProperties(Map<String, ? extends PropertyValue> entries) {
    if (this.properties == entries) {
      return this;
    }
    ImmutableMap<String, PropertyValue> newValue = ImmutableMap.copyOf(entries);
    return new PluginConfigDto(this, this.enabled, newValue, this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.PluginConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final PluginConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PluginConfigDto(this, this.enabled, this.properties, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PluginConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PluginConfigDto && equalTo((PluginConfigDto) another));
  }
  
  private boolean equalTo(PluginConfigDto another) {
    return enabled == another.enabled
        && properties.equals(another.properties)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code enabled}, {@code properties}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(enabled);
    h = h * 17 + properties.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PluginConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PluginConfigDto")
        .add("enabled", enabled)
        .add("properties", properties)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static PluginConfigDto fromAllAttributes(
      @JsonProperty("enabled") @Nullable Boolean enabled,
      @JsonProperty("properties") @Nullable Map<String, PropertyValue> properties,
      @JsonProperty("version") @Nullable String version) {
    PluginConfigDto.Builder builder = PluginConfigDto.builder();
    if (enabled != null) {
      builder.enabled(enabled);
    }
    if (properties != null) {
      builder.putAllProperties(properties);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.PluginConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable PluginConfigDto instance
   */
  static PluginConfigDto copyOf(ConfigJsonService.PluginConfigDtoBase instance) {
    if (instance instanceof PluginConfigDto) {
      return (PluginConfigDto) instance;
    }
    return PluginConfigDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.PluginConfigDto}.
   * @return new PluginConfigDto builder
   */
  static PluginConfigDto.Builder builder() {
    return new PluginConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.PluginConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_ENABLED = 0x1L;
    private static final long INITIALIZED_BIT_VERSION = 0x2L;
    private long initializedBitset;
  
    private boolean enabled;
    private ImmutableMap.Builder<String, PropertyValue> propertiesBuilder = ImmutableMap.builder();
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ConfigJsonService.PluginConfigDtoBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ConfigJsonService.PluginConfigDtoBase instance) {
      Preconditions.checkNotNull(instance);
      enabled(instance.enabled());
      putAllProperties(instance.properties());
      version(instance.version());
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.PluginConfigDtoBase#enabled() enabled}.
     * @param enabled value for enabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabled(boolean enabled) {
      this.enabled = enabled;
      initializedBitset |= INITIALIZED_BIT_ENABLED;
      return this;
    }
  
    /**
     * Put one entry to {@link ConfigJsonService.PluginConfigDtoBase#properties() properties} map.
     * @param key the key in properties map
     * @param value the associated value in properties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putProperties(String key, PropertyValue value) {
      propertiesBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link ConfigJsonService.PluginConfigDtoBase#properties() properties} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putProperties(Map.Entry<String, ? extends PropertyValue> entry) {
      propertiesBuilder.put(entry);
      return this;
    }
  
    /**
     * Sets or replaces all mappings from specified map as entries for {@link ConfigJsonService.PluginConfigDtoBase#properties() properties} map. Nulls are not permitted
     * @param entries to be added to properties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder properties(Map<String, ? extends PropertyValue> entries) {
      propertiesBuilder = ImmutableMap.builder();
      return putAllProperties(entries);
    }
  
    /**
     * Put all mappings from specified map as entries to {@link ConfigJsonService.PluginConfigDtoBase#properties() properties} map. Nulls are not permitted
     * @param entries to be added to properties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllProperties(Map<String, ? extends PropertyValue> entries) {
      propertiesBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.PluginConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.PluginConfigDto}.
     * @return immutable instance of PluginConfigDto
     */
    public org.glowroot.local.ui.PluginConfigDto build() {
      checkRequiredAttributes();
      return new PluginConfigDto(this);
    }
  
    private boolean enabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ENABLED) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!enabledIsSet()) {
        attributes.add("enabled");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build PluginConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
