package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.PluginResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PluginResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.PluginResponseBase"})
@Immutable
final class PluginResponse extends ConfigJsonService.PluginResponseBase {
  private final String id;
  private final String name;
  private final boolean enabled;

  private PluginResponse(PluginResponse.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.enabled = builder.enabled;
  }

  private PluginResponse(PluginResponse original, String id, String name, boolean enabled) {
    this.id = id;
    this.name = name;
    this.enabled = enabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public boolean enabled() {
    return enabled;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.PluginResponseBase#id() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final PluginResponse withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PluginResponse(this, newValue, this.name, this.enabled);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.PluginResponseBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final PluginResponse withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PluginResponse(this, this.id, newValue, this.enabled);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.PluginResponseBase#enabled() enabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enabled
   * @return modified copy of the {@code this} object
   */
  public final PluginResponse withEnabled(boolean value) {
    if (this.enabled == value) {
      return this;
    }
    boolean newValue = value;
    return new PluginResponse(this, this.id, this.name, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PluginResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PluginResponse && equalTo((PluginResponse) another));
  }
  
  private boolean equalTo(PluginResponse another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && enabled == another.enabled;
  }
  
  /**
   * Computes hash code from attributes: {@code id}, {@code name}, {@code enabled}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + Booleans.hashCode(enabled);
    return h;
  }
  
  /**
   * Prints immutable value {@code PluginResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PluginResponse")
        .add("id", id)
        .add("name", name)
        .add("enabled", enabled)
        .toString();
  }
  
  @JsonCreator
  public static PluginResponse fromAllAttributes(
      @JsonProperty("id") @Nullable String id,
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("enabled") @Nullable Boolean enabled) {
    PluginResponse.Builder builder = PluginResponse.builder();
    if (id != null) {
      builder.id(id);
    }
    if (name != null) {
      builder.name(name);
    }
    if (enabled != null) {
      builder.enabled(enabled);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.PluginResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable PluginResponse instance
   */
  static PluginResponse copyOf(ConfigJsonService.PluginResponseBase instance) {
    if (instance instanceof PluginResponse) {
      return (PluginResponse) instance;
    }
    return PluginResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.PluginResponse}.
   * @return new PluginResponse builder
   */
  static PluginResponse.Builder builder() {
    return new PluginResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.PluginResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_ID = 0x1L;
    private static final long INITIALIZED_BIT_NAME = 0x2L;
    private static final long INITIALIZED_BIT_ENABLED = 0x4L;
    private long initializedBitset;
  
    private @Nullable String id;
    private @Nullable String name;
    private boolean enabled;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ConfigJsonService.PluginResponseBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ConfigJsonService.PluginResponseBase instance) {
      Preconditions.checkNotNull(instance);
      id(instance.id());
      name(instance.name());
      enabled(instance.enabled());
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.PluginResponseBase#id() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.PluginResponseBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.PluginResponseBase#enabled() enabled}.
     * @param enabled value for enabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabled(boolean enabled) {
      this.enabled = enabled;
      initializedBitset |= INITIALIZED_BIT_ENABLED;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.PluginResponse}.
     * @return immutable instance of PluginResponse
     */
    public org.glowroot.local.ui.PluginResponse build() {
      checkRequiredAttributes();
      return new PluginResponse(this);
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean enabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ENABLED) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!idIsSet()) {
        attributes.add("id");
      }
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!enabledIsSet()) {
        attributes.add("enabled");
      }
      return "Cannot build PluginResponse, some of required attributes are not set " + attributes;
    }
  }
}
