package org.glowroot.transaction.model;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ThreadInfoComponent.ThreadInfoDataBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ThreadInfoData.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ThreadInfoComponent.ThreadInfoDataBase"})
@Immutable
public final class ThreadInfoData extends ThreadInfoComponent.ThreadInfoDataBase {
  private final @Nullable Long threadCpuTime;
  private final @Nullable Long threadBlockedTime;
  private final @Nullable Long threadWaitedTime;
  private final @Nullable Long threadAllocatedBytes;

  private ThreadInfoData(ThreadInfoData.Builder builder) {
    this.threadCpuTime = builder.threadCpuTime;
    this.threadBlockedTime = builder.threadBlockedTime;
    this.threadWaitedTime = builder.threadWaitedTime;
    this.threadAllocatedBytes = builder.threadAllocatedBytes;
  }

  private ThreadInfoData(
      ThreadInfoData original,
      @Nullable Long threadCpuTime,
      @Nullable Long threadBlockedTime,
      @Nullable Long threadWaitedTime,
      @Nullable Long threadAllocatedBytes) {
    this.threadCpuTime = threadCpuTime;
    this.threadBlockedTime = threadBlockedTime;
    this.threadWaitedTime = threadWaitedTime;
    this.threadAllocatedBytes = threadAllocatedBytes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadCpuTime} attribute
   */
  @Nullable
  @Override
  public Long threadCpuTime() {
    return threadCpuTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadBlockedTime} attribute
   */
  @Nullable
  @Override
  public Long threadBlockedTime() {
    return threadBlockedTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadWaitedTime} attribute
   */
  @Nullable
  @Override
  public Long threadWaitedTime() {
    return threadWaitedTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadAllocatedBytes} attribute
   */
  @Nullable
  @Override
  public Long threadAllocatedBytes() {
    return threadAllocatedBytes;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadCpuTime() threadCpuTime}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadCpuTime, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoData withThreadCpuTime(@Nullable Long value) {
    if (this.threadCpuTime == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoData(this, newValue, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadBlockedTime() threadBlockedTime}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadBlockedTime, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoData withThreadBlockedTime(@Nullable Long value) {
    if (this.threadBlockedTime == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoData(this, this.threadCpuTime, newValue, this.threadWaitedTime, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadWaitedTime() threadWaitedTime}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadWaitedTime, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoData withThreadWaitedTime(@Nullable Long value) {
    if (this.threadWaitedTime == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoData(this, this.threadCpuTime, this.threadBlockedTime, newValue, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadAllocatedBytes() threadAllocatedBytes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadAllocatedBytes, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoData withThreadAllocatedBytes(@Nullable Long value) {
    if (this.threadAllocatedBytes == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoData(this, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ThreadInfoData} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ThreadInfoData && equalTo((ThreadInfoData) another));
  }
  
  private boolean equalTo(ThreadInfoData another) {
    return Objects.equal(threadCpuTime, another.threadCpuTime)
        && Objects.equal(threadBlockedTime, another.threadBlockedTime)
        && Objects.equal(threadWaitedTime, another.threadWaitedTime)
        && Objects.equal(threadAllocatedBytes, another.threadAllocatedBytes);
  }
  
  /**
   * Computes hash code from attributes: {@code threadCpuTime}, {@code threadBlockedTime}, {@code threadWaitedTime}, {@code threadAllocatedBytes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(threadCpuTime);
    h = h * 17 + Objects.hashCode(threadBlockedTime);
    h = h * 17 + Objects.hashCode(threadWaitedTime);
    h = h * 17 + Objects.hashCode(threadAllocatedBytes);
    return h;
  }
  
  /**
   * Prints immutable value {@code ThreadInfoData{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThreadInfoData")
        .add("threadCpuTime", threadCpuTime)
        .add("threadBlockedTime", threadBlockedTime)
        .add("threadWaitedTime", threadWaitedTime)
        .add("threadAllocatedBytes", threadAllocatedBytes)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link ThreadInfoComponent.ThreadInfoDataBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable ThreadInfoData instance
   */
  public static ThreadInfoData copyOf(ThreadInfoComponent.ThreadInfoDataBase instance) {
    if (instance instanceof ThreadInfoData) {
      return (ThreadInfoData) instance;
    }
    return ThreadInfoData.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.model.ThreadInfoData}.
   * @return new ThreadInfoData builder
   */
  public static ThreadInfoData.Builder builder() {
    return new ThreadInfoData.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.model.ThreadInfoData}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
  
    private @Nullable Long threadCpuTime;
    private @Nullable Long threadBlockedTime;
    private @Nullable Long threadWaitedTime;
    private @Nullable Long threadAllocatedBytes;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ThreadInfoComponent.ThreadInfoDataBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ThreadInfoComponent.ThreadInfoDataBase instance) {
      Preconditions.checkNotNull(instance);
      @Nullable Long threadCpuTimeValue = instance.threadCpuTime();
      if (threadCpuTimeValue != null) {
        threadCpuTime(threadCpuTimeValue);
      }
      @Nullable Long threadBlockedTimeValue = instance.threadBlockedTime();
      if (threadBlockedTimeValue != null) {
        threadBlockedTime(threadBlockedTimeValue);
      }
      @Nullable Long threadWaitedTimeValue = instance.threadWaitedTime();
      if (threadWaitedTimeValue != null) {
        threadWaitedTime(threadWaitedTimeValue);
      }
      @Nullable Long threadAllocatedBytesValue = instance.threadAllocatedBytes();
      if (threadAllocatedBytesValue != null) {
        threadAllocatedBytes(threadAllocatedBytesValue);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadCpuTime() threadCpuTime}.
     * @param threadCpuTime value for threadCpuTime, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadCpuTime(@Nullable Long threadCpuTime) {
      this.threadCpuTime = threadCpuTime;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadBlockedTime() threadBlockedTime}.
     * @param threadBlockedTime value for threadBlockedTime, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadBlockedTime(@Nullable Long threadBlockedTime) {
      this.threadBlockedTime = threadBlockedTime;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadWaitedTime() threadWaitedTime}.
     * @param threadWaitedTime value for threadWaitedTime, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadWaitedTime(@Nullable Long threadWaitedTime) {
      this.threadWaitedTime = threadWaitedTime;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadAllocatedBytes() threadAllocatedBytes}.
     * @param threadAllocatedBytes value for threadAllocatedBytes, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadAllocatedBytes(@Nullable Long threadAllocatedBytes) {
      this.threadAllocatedBytes = threadAllocatedBytes;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.model.ThreadInfoData}.
     * @return immutable instance of ThreadInfoData
     */
    public ThreadInfoData build() {
      return new ThreadInfoData(this);
    }
  }
}
