package org.glowroot.weaving;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.objectweb.asm.Type;

/**
 * Immutable implementation of {@link AdviceBase.AdviceParameterBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AdviceParameter.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AdviceBase.AdviceParameterBase"})
@Immutable
final class AdviceParameter extends AdviceBase.AdviceParameterBase {
  private final ParameterKind kind;
  private final Type type;

  private AdviceParameter(AdviceParameter.Builder builder) {
    this.kind = builder.kind;
    this.type = builder.type;
  }

  private AdviceParameter(AdviceParameter original, ParameterKind kind, Type type) {
    this.kind = kind;
    this.type = type;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code kind} attribute
   */
  @Override
  public ParameterKind kind() {
    return kind;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code type} attribute
   */
  @Override
  public Type type() {
    return type;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase.AdviceParameterBase#kind() kind}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for kind
   * @return modified copy of the {@code this} object
   */
  public final AdviceParameter withKind(ParameterKind value) {
    if (this.kind == value) {
      return this;
    }
    ParameterKind newValue = Preconditions.checkNotNull(value);
    return new AdviceParameter(this, newValue, this.type);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase.AdviceParameterBase#type() type}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for type
   * @return modified copy of the {@code this} object
   */
  public final AdviceParameter withType(Type value) {
    if (this.type == value) {
      return this;
    }
    Type newValue = Preconditions.checkNotNull(value);
    return new AdviceParameter(this, this.kind, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AdviceParameter} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AdviceParameter && equalTo((AdviceParameter) another));
  }
  
  private boolean equalTo(AdviceParameter another) {
    return kind.equals(another.kind)
        && type.equals(another.type);
  }
  
  /**
   * Computes hash code from attributes: {@code kind}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + kind.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code AdviceParameter{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AdviceParameter")
        .add("kind", kind)
        .add("type", type)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link AdviceBase.AdviceParameterBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable AdviceParameter instance
   */
  static AdviceParameter copyOf(AdviceBase.AdviceParameterBase instance) {
    if (instance instanceof AdviceParameter) {
      return (AdviceParameter) instance;
    }
    return AdviceParameter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.AdviceParameter}.
   * @return new AdviceParameter builder
   */
  static AdviceParameter.Builder builder() {
    return new AdviceParameter.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.AdviceParameter}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_KIND = 0x1L;
    private static final long INITIALIZED_BIT_TYPE = 0x2L;
    private long initializedBitset;
  
    private @Nullable ParameterKind kind;
    private @Nullable Type type;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link AdviceBase.AdviceParameterBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(AdviceBase.AdviceParameterBase instance) {
      Preconditions.checkNotNull(instance);
      kind(instance.kind());
      type(instance.type());
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase.AdviceParameterBase#kind() kind}.
     * @param kind value for kind
     * @return {@code this} builder for chained invocation
     */
    public final Builder kind(ParameterKind kind) {
      this.kind = Preconditions.checkNotNull(kind);
      initializedBitset |= INITIALIZED_BIT_KIND;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase.AdviceParameterBase#type() type}.
     * @param type value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(Type type) {
      this.type = Preconditions.checkNotNull(type);
      initializedBitset |= INITIALIZED_BIT_TYPE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.AdviceParameter}.
     * @return immutable instance of AdviceParameter
     */
    public org.glowroot.weaving.AdviceParameter build() {
      checkRequiredAttributes();
      return new AdviceParameter(this);
    }
  
    private boolean kindIsSet() {
      return (initializedBitset & INITIALIZED_BIT_KIND) != 0;
    }
  
    private boolean typeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TYPE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!kindIsSet()) {
        attributes.add("kind");
      }
      if (!typeIsSet()) {
        attributes.add("type");
      }
      return "Cannot build AdviceParameter, some of required attributes are not set " + attributes;
    }
  }
}
