/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot;

import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class DataDir {
    private static final Logger logger = LoggerFactory.getLogger(DataDir.class);

    private DataDir() {
    }

    public static File getDataDir(Map<String, String> properties, @Nullable File glowrootJarFile) {
        String dataDirPath = properties.get("data.dir");
        if (glowrootJarFile == null) {
            Preconditions.checkNotNull(dataDirPath, "Property data.dir is required when no glowroot jar file");
            return new File(dataDirPath);
        }
        if (Strings.isNullOrEmpty(dataDirPath)) {
            return DataDir.getDefaultDataDir(glowrootJarFile);
        }
        File dataDir = new File(dataDirPath);
        if (!dataDir.isAbsolute()) {
            return DataDir.getRelativeDataDir(dataDirPath, glowrootJarFile);
        }
        return DataDir.getAbsoluteDataDir(dataDir);
    }

    private static File getDefaultDataDir(File glowrootJarFile) {
        File glowrootDir = glowrootJarFile.getParentFile();
        if (glowrootDir == null) {
            return new File(".");
        }
        return glowrootDir;
    }

    private static File getRelativeDataDir(String dataDirPath, File glowrootJarFile) {
        File dataDir = new File(glowrootJarFile.getParentFile(), dataDirPath);
        return DataDir.getAbsoluteDataDir(dataDir);
    }

    private static File getAbsoluteDataDir(File dataDir) {
        dataDir.mkdirs();
        if (!dataDir.isDirectory()) {
            File processCurrDir = new File(".");
            logger.warn("error creating data directory: {} (using directory {} instead)", (Object)dataDir.getAbsolutePath(), (Object)processCurrDir.getAbsolutePath());
            return processCurrDir;
        }
        return dataDir;
    }
}

