/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.instrument.Instrumentation;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.collector.CollectorModule;
import org.glowroot.common.Clock;
import org.glowroot.common.SpyingLogbackFilter;
import org.glowroot.common.Tickers;
import org.glowroot.config.ConfigModule;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.jvm.JvmModule;
import org.glowroot.local.store.StorageModule;
import org.glowroot.local.ui.LocalUiModule;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.io.Files;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glowroot.shaded.qos.logback.classic.LoggerContext;
import org.glowroot.shaded.qos.logback.classic.joran.JoranConfigurator;
import org.glowroot.shaded.qos.logback.core.joran.spi.JoranException;
import org.glowroot.shaded.qos.logback.core.util.StatusPrinter;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionModule;
import org.glowroot.transaction.model.Transaction;
import org.glowroot.weaving.ExtraBootResourceFinder;

@VisibleForTesting
public class GlowrootModule {
    private static final Logger logger = LoggerFactory.getLogger(GlowrootModule.class);
    private final Ticker ticker;
    private final Clock clock;
    private final ScheduledExecutorService scheduledExecutor;
    private final ConfigModule configModule;
    private final StorageModule storageModule;
    private final CollectorModule collectorModule;
    private final TransactionModule transactionModule;
    private final LocalUiModule uiModule;
    private final File dataDir;
    private final RandomAccessFile dataDirLockFile;
    private final FileLock dataDirFileLock;
    private final boolean loggingSpy;

    GlowrootModule(File dataDir, Map<String, String> properties, @Nullable Instrumentation instrumentation, @Nullable File glowrootJarFile, String version, boolean viewerModeEnabled, boolean jbossModules) throws Exception {
        this.loggingSpy = Boolean.valueOf(properties.get("internal.logging.spy"));
        GlowrootModule.initStaticLoggerState(dataDir, this.loggingSpy);
        File tmpDir = new File(dataDir, "tmp");
        File lockFile = new File(tmpDir, ".lock");
        try {
            Files.createParentDirs(lockFile);
            Files.touch(lockFile);
        }
        catch (IOException e) {
            throw new DataDirLockedException(e);
        }
        this.dataDirLockFile = new RandomAccessFile(lockFile, "rw");
        FileLock dataDirFileLock = this.dataDirLockFile.getChannel().tryLock();
        if (dataDirFileLock == null) {
            throw new DataDirLockedException();
        }
        this.dataDirFileLock = dataDirFileLock;
        lockFile.deleteOnExit();
        this.configModule = new ConfigModule(dataDir, glowrootJarFile, viewerModeEnabled);
        this.ticker = Tickers.getTicker();
        this.clock = Clock.systemClock();
        ExtraBootResourceFinder extraBootResourceFinder = GlowrootModule.createExtraBootResourceFinder(instrumentation, this.configModule.getPluginJars());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Glowroot-Background-%d").build();
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, threadFactory);
        JvmModule jvmModule = new JvmModule(jbossModules);
        TransactionCollectorProxy transactionCollectorProxy = new TransactionCollectorProxy();
        this.transactionModule = new TransactionModule(this.clock, this.ticker, this.configModule, transactionCollectorProxy, jvmModule.getThreadAllocatedBytes().getService(), instrumentation, dataDir, extraBootResourceFinder, this.scheduledExecutor);
        this.storageModule = new StorageModule(dataDir, properties, this.clock, this.ticker, this.configModule, this.scheduledExecutor, jvmModule.getLazyPlatformMBeanServer(), viewerModeEnabled);
        this.collectorModule = new CollectorModule(this.clock, this.ticker, jvmModule, this.configModule, this.storageModule.getTraceRepository(), this.storageModule.getAggregateRepository(), this.storageModule.getGaugePointDao(), this.transactionModule.getTransactionRegistry(), this.scheduledExecutor, viewerModeEnabled);
        transactionCollectorProxy.setInstance(this.collectorModule.getTransactionCollector());
        GlowrootModule.initPlugins(this.configModule.getPluginDescriptors());
        this.uiModule = new LocalUiModule(this.ticker, this.clock, dataDir, jvmModule, this.configModule, this.storageModule, this.collectorModule, this.transactionModule, instrumentation, properties, version);
        this.dataDir = dataDir;
    }

    private static void initStaticLoggerState(File dataDir, boolean loggingSpy) {
        if (GlowrootModule.shouldOverrideLogging()) {
            GlowrootModule.overrideLogging(dataDir);
        }
        if (loggingSpy) {
            SpyingLogbackFilter.init();
        }
    }

    @Nullable
    private static ExtraBootResourceFinder createExtraBootResourceFinder(@Nullable Instrumentation instrumentation, List<File> pluginJars) throws IOException {
        if (instrumentation == null) {
            return null;
        }
        for (File pluginJar : pluginJars) {
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(pluginJar));
        }
        return new ExtraBootResourceFinder(pluginJars);
    }

    private static void initPlugins(List<PluginDescriptor> pluginDescriptors) {
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            for (String aspect : pluginDescriptor.aspects()) {
                try {
                    Class.forName(aspect, true, GlowrootModule.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
        }
    }

    private static boolean shouldOverrideLogging() {
        return GlowrootModule.isShaded() && ClassLoader.getSystemResource("glowroot.logback-test.xml") == null;
    }

    private static void overrideLogging(File dataDir) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(context);
            context.reset();
            context.putProperty("glowroot.data.dir", dataDir.getPath());
            File logbackXmlFile = new File(dataDir, "glowroot.logback.xml");
            if (logbackXmlFile.exists()) {
                configurator.doConfigure(logbackXmlFile);
            } else {
                configurator.doConfigure(Resources.getResource("glowroot.logback-override.xml"));
            }
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings(context);
    }

    private static boolean isShaded() {
        try {
            Class.forName("org.glowroot.shaded.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.trace(e.getMessage(), e);
            return false;
        }
    }

    @OnlyUsedByTests
    public ConfigModule getConfigModule() {
        return this.configModule;
    }

    @OnlyUsedByTests
    public TransactionModule getTransactionModule() {
        return this.transactionModule;
    }

    @OnlyUsedByTests
    public LocalUiModule getUiModule() {
        return this.uiModule;
    }

    @OnlyUsedByTests
    public void reopen() {
        GlowrootModule.initStaticLoggerState(this.dataDir, this.loggingSpy);
        this.transactionModule.reopen();
    }

    @OnlyUsedByTests
    public void close() throws Exception {
        this.uiModule.close();
        this.collectorModule.close();
        this.transactionModule.close();
        this.storageModule.close();
        this.scheduledExecutor.shutdownNow();
        if (GlowrootModule.shouldOverrideLogging()) {
            ((LoggerContext)LoggerFactory.getILoggerFactory()).reset();
        }
        this.dataDirFileLock.release();
        this.dataDirLockFile.close();
    }

    @VisibleForTesting
    static class TransactionCollectorProxy
    implements TransactionCollector {
        @MonotonicNonNull
        private volatile TransactionCollector instance;

        TransactionCollectorProxy() {
        }

        @Override
        public void onCompletedTransaction(Transaction transaction) {
            if (this.instance != null) {
                this.instance.onCompletedTransaction(transaction);
            }
        }

        @Override
        public void storePartialTrace(Transaction transaction) {
            if (this.instance != null) {
                this.instance.storePartialTrace(transaction);
            }
        }

        @VisibleForTesting
        void setInstance(TransactionCollector instance) {
            this.instance = instance;
        }

        @Override
        public Collection<Transaction> getPendingTransactions() {
            return ImmutableList.of();
        }

        @Override
        public boolean shouldStore(Transaction transaction) {
            return false;
        }
    }

    static class DataDirLockedException
    extends StartupFailedException {
        private DataDirLockedException() {
        }

        private DataDirLockedException(Throwable cause) {
            super(cause);
        }
    }

    @VisibleForTesting
    public static class StartupFailedException
    extends Exception {
        private StartupFailedException() {
        }

        private StartupFailedException(Throwable cause) {
            super(cause);
        }
    }
}

