/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.DataDir;
import org.glowroot.GlowrootModule;
import org.glowroot.Version;
import org.glowroot.common.JavaVersion;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class MainEntryPoint {
    private static final Logger startupLogger = LoggerFactory.getLogger("org.glowroot");
    @MonotonicNonNull
    private static volatile GlowrootModule glowrootModule;

    private MainEntryPoint() {
    }

    public static void premain(Instrumentation instrumentation, @Nullable File glowrootJarFile) {
        boolean jbossModules = MainEntryPoint.isJBossModules();
        if (jbossModules) {
            String jbossModulesSystemPkgs = System.getProperty("jboss.modules.system.pkgs");
            jbossModulesSystemPkgs = Strings.isNullOrEmpty(jbossModulesSystemPkgs) ? "org.glowroot" : jbossModulesSystemPkgs + ",org.glowroot";
            System.setProperty("jboss.modules.system.pkgs", jbossModulesSystemPkgs);
        }
        ImmutableMap<String, String> properties = MainEntryPoint.getGlowrootProperties();
        File dataDir = DataDir.getDataDir(properties, glowrootJarFile);
        try {
            MainEntryPoint.start(dataDir, properties, instrumentation, glowrootJarFile, jbossModules);
        }
        catch (GlowrootModule.DataDirLockedException e) {
            MainEntryPoint.logDataDirLockedException(dataDir);
        }
        catch (Throwable t) {
            startupLogger.error("Glowroot not started: {}", (Object)t.getMessage(), (Object)t);
        }
    }

    static void runViewer(@Nullable File glowrootJarFile) throws InterruptedException {
        ImmutableMap<String, String> properties = MainEntryPoint.getGlowrootProperties();
        File dataDir = DataDir.getDataDir(properties, glowrootJarFile);
        String version = Version.getVersion();
        try {
            glowrootModule = new GlowrootModule(dataDir, properties, null, glowrootJarFile, version, true, false);
        }
        catch (GlowrootModule.DataDirLockedException e) {
            MainEntryPoint.logDataDirLockedException(dataDir);
            return;
        }
        catch (Throwable t) {
            startupLogger.error("Viewer cannot start: {}", (Object)t.getMessage(), (Object)t);
            return;
        }
        startupLogger.info("Viewer started (version {})", (Object)version);
        startupLogger.info("Viewer listening at http://localhost:{}", (Object)glowrootModule.getUiModule().getPort());
        Thread.sleep(Long.MAX_VALUE);
    }

    private static void start(File dataDir, Map<String, String> properties, @Nullable Instrumentation instrumentation, @Nullable File glowrootJarFile, boolean jbossModules) throws Exception {
        ManagementFactory.getThreadMXBean().setThreadCpuTimeEnabled(true);
        ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(true);
        String version = Version.getVersion();
        glowrootModule = new GlowrootModule(dataDir, properties, instrumentation, glowrootJarFile, version, false, jbossModules);
        startupLogger.info("Glowroot started (version {})", (Object)version);
        List<PluginDescriptor> pluginDescriptors = glowrootModule.getConfigModule().getPluginDescriptors();
        ArrayList<String> pluginNames = Lists.newArrayList();
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            pluginNames.add(pluginDescriptor.name());
        }
        if (!pluginNames.isEmpty()) {
            startupLogger.info("Glowroot plugins loaded: {}", (Object)Joiner.on(", ").join(pluginNames));
        }
        if (instrumentation == null || JavaVersion.isJava6()) {
            startupLogger.info("Glowroot listening at http://localhost:{}", (Object)glowrootModule.getUiModule().getNonLazyPort());
        }
    }

    private static ImmutableMap<String, String> getGlowrootProperties() {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !((String)entry.getKey()).startsWith("glowroot.")) continue;
            String key = (String)entry.getKey();
            builder.put(key.substring("glowroot.".length()), (String)entry.getValue());
        }
        return builder.build();
    }

    private static void logDataDirLockedException(File dataDir) {
        if (!MainEntryPoint.isTomcatStop()) {
            startupLogger.error("Glowroot not started: data dir in used by another jvm process", (Object)dataDir.getAbsolutePath());
        }
    }

    private static boolean isTomcatStop() {
        return Objects.equal(System.getProperty("sun.java.command"), "org.apache.catalina.startup.Bootstrap stop");
    }

    private static boolean isJBossModules() {
        return MainEntryPoint.isJBossModules(System.getProperty("sun.java.command"));
    }

    @VisibleForTesting
    static boolean isJBossModules(@Nullable String command) {
        if (command == null) {
            return false;
        }
        int index = command.indexOf(32);
        String className = index == -1 ? command : command.substring(0, index);
        return className.equals("org.jboss.modules.Main") || className.endsWith("jboss-modules.jar");
    }

    @OnlyUsedByTests
    public static void start(Map<String, String> properties) throws Exception {
        File dataDir = DataDir.getDataDir(properties, null);
        MainEntryPoint.start(dataDir, properties, null, null, false);
    }

    @Nullable
    @OnlyUsedByTests
    public static GlowrootModule getGlowrootModule() {
        return glowrootModule;
    }

    @OnlyUsedByTests
    public static void reopen(GlowrootModule glowrootModule) {
        glowrootModule.reopen();
        MainEntryPoint.glowrootModule = glowrootModule;
    }
}

