/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import org.glowroot.common.Manifests;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class Version {
    private static final Logger logger = LoggerFactory.getLogger(Version.class);

    private Version() {
    }

    static String getVersion() {
        Manifest manifest;
        try {
            manifest = Manifests.getManifest(Version.class);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            return "unknown";
        }
        return Version.getVersion(manifest);
    }

    @VisibleForTesting
    static String getVersion(@Nullable Manifest manifest) {
        if (manifest == null) {
            logger.debug("could not locate META-INF/MANIFEST.MF file");
            return "unknown";
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String version = mainAttributes.getValue("Implementation-Version");
        if (version == null) {
            logger.warn("could not find Implementation-Version attribute in META-INF/MANIFEST.MF file");
            return "unknown";
        }
        if (version.endsWith("-SNAPSHOT")) {
            return Version.getSnapshotVersion(version, mainAttributes);
        }
        String timestamp = mainAttributes.getValue("Build-Time");
        if (timestamp == null) {
            logger.warn("could not find Build-Time attribute in META-INF/MANIFEST.MF file");
            return version;
        }
        return version + ", built " + timestamp;
    }

    private static String getSnapshotVersion(String version, Attributes mainAttributes) {
        String timestamp;
        StringBuilder snapshotVersion = new StringBuilder(version);
        String commit = mainAttributes.getValue("Build-Commit");
        if (commit != null && !commit.isEmpty()) {
            if (commit.length() == 40) {
                snapshotVersion.append(", commit ");
                snapshotVersion.append(commit.substring(0, 10));
            } else {
                logger.warn("invalid Build-Commit attribute in META-INF/MANIFEST.MF file, should be a 40 character git commit hash");
            }
        }
        if ((timestamp = mainAttributes.getValue("Build-Time")) == null) {
            logger.warn("could not find Build-Time attribute in META-INF/MANIFEST.MF file");
            return snapshotVersion.toString();
        }
        snapshotVersion.append(", built ");
        snapshotVersion.append(timestamp);
        return snapshotVersion.toString();
    }
}

