/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.advicegen;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.glowroot.advicegen.Accessor;
import org.glowroot.common.Reflections;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.cache.CacheLoader;
import org.glowroot.shaded.google.common.cache.LoadingCache;
import org.glowroot.shaded.google.common.collect.MapMaker;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class Beans {
    private static final Logger logger = LoggerFactory.getLogger(Beans.class);
    private static final Accessor SENTINEL_ACCESSOR;
    private static final LoadingCache<Class<?>, ConcurrentMap<String, Accessor>> getters;

    private Beans() {
    }

    @Nullable
    static Object value(@Nullable Object obj, String[] path) throws Exception {
        return Beans.value(obj, path, 0);
    }

    @Nullable
    private static Object value(@Nullable Object obj, String[] path, int currIndex) throws Exception {
        if (obj == null) {
            return null;
        }
        if (currIndex == path.length) {
            return obj;
        }
        String curr = path[currIndex];
        if (obj instanceof Map) {
            return Beans.value(((Map)obj).get(curr), path, currIndex + 1);
        }
        Accessor accessor = Beans.getAccessor(obj.getClass(), curr);
        if (accessor.equals(SENTINEL_ACCESSOR)) {
            return null;
        }
        Object currItem = accessor.evaluate(obj);
        return Beans.value(currItem, path, currIndex + 1);
    }

    private static Accessor getAccessor(Class<?> clazz, String name) {
        ConcurrentMap<String, Accessor> accessorsForType = getters.getUnchecked(clazz);
        Accessor accessor = (Accessor)accessorsForType.get(name);
        if (accessor == null) {
            accessor = Beans.loadPossiblyArrayBasedAccessor(clazz, name);
            if (accessor == null) {
                accessor = SENTINEL_ACCESSOR;
            }
            accessorsForType.put(name, accessor);
        }
        return accessor;
    }

    @Nullable
    static Accessor loadPossiblyArrayBasedAccessor(Class<?> clazz, String name) {
        if (clazz.getComponentType() != null && name.equals("length")) {
            return Accessor.arrayLength();
        }
        Class<?> componentType = clazz;
        while (componentType.getComponentType() != null) {
            componentType = componentType.getComponentType();
        }
        return Beans.loadAccessor(componentType, name);
    }

    @Nullable
    private static Accessor loadAccessor(Class<?> clazz, String name) {
        String capitalizedName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method method = Reflections.getAnyMethod(clazz, "get" + capitalizedName, new Class[0]);
            return Accessor.fromMethod(method);
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), e);
            try {
                Method method = Reflections.getAnyMethod(clazz, "is" + capitalizedName, new Class[0]);
                return Accessor.fromMethod(method);
            }
            catch (Exception f) {
                logger.trace(f.getMessage(), f);
                try {
                    Method method = Reflections.getAnyMethod(clazz, name, new Class[0]);
                    return Accessor.fromMethod(method);
                }
                catch (Exception g) {
                    logger.trace(g.getMessage(), g);
                    try {
                        Field field = Reflections.getAnyField(clazz, name);
                        return Accessor.fromField(field);
                    }
                    catch (Exception h) {
                        logger.trace(h.getMessage(), h);
                        logger.debug("no accessor found for {} in class {}", (Object)name, (Object)clazz.getName());
                        return null;
                    }
                }
            }
        }
    }

    private static void sentinelMethod() {
    }

    static {
        try {
            SENTINEL_ACCESSOR = Accessor.fromMethod(Beans.class.getDeclaredMethod("sentinelMethod", new Class[0]));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        getters = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ConcurrentMap<String, Accessor>>(){

            @Override
            public ConcurrentMap<String, Accessor> load(Class<?> clazz) {
                return new MapMaker().weakValues().makeMap();
            }
        });
    }
}

