/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.advicegen;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.glowroot.advicegen.Accessor;
import org.glowroot.advicegen.Beans;
import org.glowroot.shaded.google.common.base.Splitter;
import org.glowroot.shaded.google.common.collect.Lists;

class PathEvaluator {
    private static final Splitter splitter = Splitter.on('.').omitEmptyStrings();
    private final Accessor[] accessors;
    private final String[] remainingPath;

    PathEvaluator(Class<?> baseClass, String path) {
        ArrayList<String> parts = Lists.newArrayList(splitter.split(path));
        ArrayList<Accessor> accessors = Lists.newArrayList();
        Class<?> currClass = baseClass;
        while (!parts.isEmpty()) {
            String currPart = (String)parts.remove(0);
            Accessor accessor = Beans.loadPossiblyArrayBasedAccessor(currClass, currPart);
            if (accessor == null) {
                parts.add(0, currPart);
                break;
            }
            accessors.add(accessor);
            currClass = accessor.getValueType();
        }
        this.accessors = accessors.toArray(new Accessor[accessors.size()]);
        this.remainingPath = parts.isEmpty() ? null : parts.toArray(new String[parts.size()]);
    }

    @Nullable
    Object evaluateOnBase(Object base) throws Exception {
        Object curr = base;
        for (Accessor accessor : this.accessors) {
            if ((curr = accessor.evaluate(curr)) != null) continue;
            return null;
        }
        if (this.remainingPath != null) {
            return Beans.value(curr, this.remainingPath);
        }
        return curr;
    }
}

