/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.api;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.api.ErrorMessage;
import org.glowroot.api.MessageSupplier;
import org.glowroot.api.QueryEntry;
import org.glowroot.api.Timer;
import org.glowroot.api.TimerName;
import org.glowroot.api.TraceEntry;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public abstract class PluginServices {
    private static final Logger logger = LoggerFactory.getLogger(PluginServices.class);
    private static final String HANDLE_CLASS_NAME = "org.glowroot.transaction.PluginServicesRegistry";
    private static final String HANDLE_METHOD_NAME = "get";

    public static PluginServices get(String pluginId) {
        if (pluginId == null) {
            logger.error("get(): argument 'pluginId' must be non-null");
            throw new AssertionError((Object)"Argument 'pluginId' must be non-null");
        }
        return PluginServices.getPluginServices(pluginId);
    }

    protected PluginServices() {
    }

    public abstract void registerConfigListener(ConfigListener var1);

    public abstract boolean isEnabled();

    public abstract StringProperty getStringProperty(String var1);

    public abstract BooleanProperty getBooleanProperty(String var1);

    public abstract DoubleProperty getDoubleProperty(String var1);

    public abstract BooleanProperty getEnabledProperty(String var1);

    public abstract TimerName getTimerName(Class<?> var1);

    public abstract TraceEntry startTransaction(String var1, String var2, MessageSupplier var3, TimerName var4);

    public abstract TraceEntry startTraceEntry(MessageSupplier var1, TimerName var2);

    public abstract QueryEntry startQueryEntry(String var1, String var2, MessageSupplier var3, TimerName var4);

    public abstract QueryEntry startQueryEntry(String var1, String var2, long var3, MessageSupplier var5, TimerName var6);

    public abstract Timer startTimer(TimerName var1);

    public abstract void addTraceEntry(ErrorMessage var1);

    public abstract void setTransactionType(@Nullable String var1);

    public abstract void setTransactionName(@Nullable String var1);

    public abstract void setTransactionError(ErrorMessage var1);

    public abstract void setTransactionUser(@Nullable String var1);

    public abstract void addTransactionCustomAttribute(String var1, @Nullable String var2);

    public abstract void setTraceStoreThreshold(long var1, TimeUnit var3);

    public abstract boolean isInTransaction();

    private static PluginServices getPluginServices(String pluginId) {
        try {
            Class<?> handleClass = Class.forName(HANDLE_CLASS_NAME);
            Method handleMethod = handleClass.getMethod(HANDLE_METHOD_NAME, String.class);
            PluginServices pluginServices = (PluginServices)handleMethod.invoke(null, pluginId);
            if (pluginServices == null) {
                logger.error("plugin services requested while glowroot is still starting", new IllegalStateException());
                throw new AssertionError((Object)"Plugin services requested while glowroot is still starting");
            }
            return pluginServices;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new AssertionError((Object)e);
        }
    }

    public static interface ConfigListener {
        public void onChange();
    }

    public static interface DoubleProperty {
        @Nullable
        public Double value();
    }

    public static interface BooleanProperty {
        public boolean value();
    }

    public static interface StringProperty {
        public String value();
    }
}

