/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.glowroot.collector.AggregateIntervalCollector;
import org.glowroot.collector.AggregateRepository;
import org.glowroot.collector.PendingTransaction;
import org.glowroot.common.Clock;
import org.glowroot.config.ConfigService;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Queues;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.model.Transaction;
import org.immutables.value.Value;

public class AggregateCollector {
    private static final Logger logger = LoggerFactory.getLogger(TransactionProcessor.class);
    private volatile AggregateIntervalCollector activeIntervalCollector;
    private final List<AggregateIntervalCollector> pendingIntervalCollectors = Lists.newCopyOnWriteArrayList();
    private final ScheduledExecutorService scheduledExecutor;
    private final AggregateRepository aggregateRepository;
    private final ConfigService configService;
    private final Clock clock;
    private final long fixedAggregateIntervalMillis;
    private final BlockingQueue<PendingTransaction> pendingTransactionQueue = Queues.newLinkedBlockingQueue();
    private final Thread processingThread;
    private final Object lock = new Object();

    AggregateCollector(ScheduledExecutorService scheduledExecutor, AggregateRepository aggregateRepository, ConfigService configService, long fixedAggregateIntervalSeconds, Clock clock) {
        this.scheduledExecutor = scheduledExecutor;
        this.aggregateRepository = aggregateRepository;
        this.configService = configService;
        this.clock = clock;
        this.fixedAggregateIntervalMillis = fixedAggregateIntervalSeconds * 1000L;
        this.activeIntervalCollector = new AggregateIntervalCollector(clock.currentTimeMillis(), this.fixedAggregateIntervalMillis, configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
        this.processingThread = new Thread(new TransactionProcessor());
        this.processingThread.setDaemon(true);
        this.processingThread.setName("Glowroot-Aggregate-Collector");
        this.processingThread.start();
    }

    public List<AggregateIntervalCollector> getOrderedIntervalCollectorsInRange(long from, long to) {
        ArrayList<AggregateIntervalCollector> intervalCollectors = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : this.getOrderedAllIntervalCollectors()) {
            long endTime = intervalCollector.getEndTime();
            if (endTime < from || endTime > to) continue;
            intervalCollectors.add(intervalCollector);
        }
        return intervalCollectors;
    }

    public void clearAll() {
        this.activeIntervalCollector.clear();
        this.pendingIntervalCollectors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long add(Transaction transaction) {
        Object object = this.lock;
        synchronized (object) {
            long captureTime = this.clock.currentTimeMillis();
            this.pendingTransactionQueue.add(PendingTransaction.of(captureTime, transaction));
            return captureTime;
        }
    }

    private List<AggregateIntervalCollector> getOrderedAllIntervalCollectors() {
        AggregateIntervalCollector activeIntervalCollector = this.activeIntervalCollector;
        ArrayList<AggregateIntervalCollector> intervalCollectors = Lists.newArrayList(this.pendingIntervalCollectors);
        if (intervalCollectors.isEmpty()) {
            return ImmutableList.of(activeIntervalCollector);
        }
        if (!intervalCollectors.contains(activeIntervalCollector)) {
            intervalCollectors.add(activeIntervalCollector);
            return intervalCollectors;
        }
        return intervalCollectors;
    }

    @OnlyUsedByTests
    void close() {
        this.processingThread.interrupt();
    }

    @Value.Immutable
    static abstract class PendingTransactionBase {
        PendingTransactionBase() {
        }

        abstract long captureTime();

        abstract Transaction transaction();
    }

    private class IntervalFlusher
    implements Runnable {
        private final AggregateIntervalCollector intervalCollector;

        private IntervalFlusher(AggregateIntervalCollector intervalCollector) {
            this.intervalCollector = intervalCollector;
            AggregateCollector.this.pendingIntervalCollectors.add(intervalCollector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AggregateIntervalCollector aggregateIntervalCollector = this.intervalCollector;
            synchronized (aggregateIntervalCollector) {
                try {
                    this.intervalCollector.flush(AggregateCollector.this.aggregateRepository);
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    AggregateCollector.this.pendingIntervalCollectors.remove(this.intervalCollector);
                }
            }
        }
    }

    private class TransactionProcessor
    implements Runnable {
        private TransactionProcessor() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.processOne();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processOne() throws InterruptedException {
            long timeToActiveIntervalEndTime = Math.max(0L, AggregateCollector.this.activeIntervalCollector.getEndTime() - AggregateCollector.this.clock.currentTimeMillis());
            PendingTransaction pendingTransaction = (PendingTransaction)AggregateCollector.this.pendingTransactionQueue.poll(timeToActiveIntervalEndTime + 1000L, TimeUnit.MILLISECONDS);
            if (pendingTransaction == null) {
                this.maybeEndOfInterval();
                return;
            }
            if (pendingTransaction.captureTime() > AggregateCollector.this.activeIntervalCollector.getEndTime()) {
                AggregateCollector.this.scheduledExecutor.execute(new IntervalFlusher(AggregateCollector.this.activeIntervalCollector));
                AggregateCollector.this.activeIntervalCollector = new AggregateIntervalCollector(pendingTransaction.captureTime(), AggregateCollector.this.fixedAggregateIntervalMillis, AggregateCollector.this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
            }
            AggregateIntervalCollector aggregateIntervalCollector = AggregateCollector.this.activeIntervalCollector;
            synchronized (aggregateIntervalCollector) {
                AggregateCollector.this.activeIntervalCollector.add(pendingTransaction.transaction());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeEndOfInterval() {
            Object object = AggregateCollector.this.lock;
            synchronized (object) {
                if (AggregateCollector.this.pendingTransactionQueue.peek() != null) {
                    return;
                }
                long currentTime = AggregateCollector.this.clock.currentTimeMillis();
                if (currentTime > AggregateCollector.this.activeIntervalCollector.getEndTime()) {
                    AggregateCollector.this.scheduledExecutor.execute(new IntervalFlusher(AggregateCollector.this.activeIntervalCollector));
                    AggregateCollector.this.activeIntervalCollector = new AggregateIntervalCollector(currentTime, AggregateCollector.this.fixedAggregateIntervalMillis, AggregateCollector.this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
                }
            }
        }
    }
}

