/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.List;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.transaction.model.Profile;
import org.glowroot.transaction.model.ProfileNode;

class AggregateProfileBuilder {
    private final ProfileNode syntheticRootNode = ProfileNode.createSyntheticRoot();

    AggregateProfileBuilder() {
    }

    ProfileNode getSyntheticRootNode() {
        return this.syntheticRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProfile(Profile profile) {
        Object object = profile.getLock();
        synchronized (object) {
            this.mergeNode(this.syntheticRootNode, profile.getSyntheticRootNode(), profile.mayHaveSyntheticTimerMethods());
        }
    }

    private void mergeNode(ProfileNode node, ProfileNode toBeMergedNode, boolean mayHaveSyntheticTimerMethods) {
        List<String> timerNames;
        node.incrementSampleCount(toBeMergedNode.getSampleCount());
        if (mayHaveSyntheticTimerMethods && (timerNames = toBeMergedNode.getTimerNames()).size() > node.getTimerNames().size()) {
            node.setTimerNames(timerNames);
        }
        for (ProfileNode toBeMergedChildNode : toBeMergedNode.getChildNodes()) {
            ProfileNode foundMatchingChildNode = null;
            for (ProfileNode childNode : node.getChildNodes()) {
                if (!this.matches(toBeMergedChildNode, childNode)) continue;
                foundMatchingChildNode = childNode;
                break;
            }
            if (foundMatchingChildNode == null) {
                String stackTraceElement = toBeMergedChildNode.getStackTraceElement();
                Preconditions.checkNotNull(stackTraceElement);
                foundMatchingChildNode = ProfileNode.create(stackTraceElement, toBeMergedChildNode.getLeafThreadState());
                node.addChildNode(foundMatchingChildNode);
            }
            this.mergeNode(foundMatchingChildNode, toBeMergedChildNode, mayHaveSyntheticTimerMethods);
        }
    }

    private boolean matches(ProfileNode node1, ProfileNode node2) {
        return Objects.equal(node1.getStackTraceElement(), node2.getStackTraceElement()) && Objects.equal(node1.getLeafThreadState(), node2.getLeafThreadState());
    }
}

