/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class DetailMapWriter {
    private static final Logger logger = LoggerFactory.getLogger(DetailMapWriter.class);
    private static final String UNSHADED_GUAVA_OPTIONAL_CLASS_NAME;
    private final JsonGenerator jg;

    DetailMapWriter(JsonGenerator jg) {
        this.jg = jg;
    }

    void write(Map<String, ? extends Object> detail) throws IOException {
        this.writeMap(detail);
    }

    private void writeMap(Map<?, ?> detail) throws IOException {
        this.jg.writeStartObject();
        for (Map.Entry<?, ?> entry : detail.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                this.jg.writeFieldName((String)key);
            } else if (key == null) {
                logger.warn("detail map has null key");
                this.jg.writeFieldName("");
            } else {
                logger.warn("detail map has unexpected key type: {}", (Object)key.getClass().getName());
                this.jg.writeFieldName(key.toString());
            }
            this.writeValue(entry.getValue());
        }
        this.jg.writeEndObject();
    }

    private void writeValue(@Nullable Object value) throws IOException {
        if (value == null) {
            this.jg.writeNull();
        } else if (value instanceof String) {
            this.jg.writeString((String)value);
        } else if (value instanceof Boolean) {
            this.jg.writeBoolean((Boolean)value);
        } else if (value instanceof Number) {
            this.jg.writeNumber(((Number)value).doubleValue());
        } else if (value instanceof Optional) {
            Optional val = (Optional)value;
            this.writeValue(val.orNull());
        } else if (value instanceof Map) {
            this.writeMap((Map)value);
        } else if (value instanceof List) {
            this.jg.writeStartArray();
            for (Object v : (List)value) {
                this.writeValue(v);
            }
            this.jg.writeEndArray();
        } else if (DetailMapWriter.isUnshadedGuavaOptionalClass(value)) {
            Class<?> optionalClass = value.getClass().getSuperclass();
            Preconditions.checkNotNull(optionalClass);
            try {
                Method orNullMethod = optionalClass.getMethod("orNull", new Class[0]);
                this.writeValue(orNullMethod.invoke(value, new Object[0]));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        } else {
            logger.warn("detail map has unexpected value type: {}", (Object)value.getClass().getName());
            this.jg.writeString(value.toString());
        }
    }

    private static boolean isUnshadedGuavaOptionalClass(Object value) {
        Class<?> superClass = value.getClass().getSuperclass();
        return superClass != null && superClass.getName().equals(UNSHADED_GUAVA_OPTIONAL_CLASS_NAME);
    }

    static {
        String className = Optional.class.getName();
        if (className.startsWith("org.glowroot.shaded")) {
            className = className.replace("org.glowroot.shaded", "com");
        }
        UNSHADED_GUAVA_OPTIONAL_CLASS_NAME = className;
    }
}

