/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.api.MessageSupplier;
import org.glowroot.api.internal.ReadableErrorMessage;
import org.glowroot.api.internal.ReadableMessage;
import org.glowroot.api.internal.ThrowableInfo;
import org.glowroot.collector.DetailMapWriter;
import org.glowroot.common.ChunkSource;
import org.glowroot.common.Tickers;
import org.glowroot.shaded.fasterxml.jackson.core.JsonFactory;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.transaction.model.Profile;
import org.glowroot.transaction.model.StackTraceElementPlus;
import org.glowroot.transaction.model.TraceEntryImpl;

public class EntriesChunkSourceCreator {
    private static final JsonFactory jsonFactory = new JsonFactory();

    private EntriesChunkSourceCreator() {
    }

    @Nullable
    public static ChunkSource createEntriesChunkSource(Iterable<TraceEntryImpl> entries, long transactionStartTick, long captureTick) {
        Iterator<TraceEntryImpl> entriesIterator = entries.iterator();
        if (!entriesIterator.hasNext()) {
            return null;
        }
        return new EntriesChunkSource(entriesIterator, transactionStartTick, captureTick);
    }

    static void writeThrowable(ThrowableInfo exception, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("display", exception.display());
        jg.writeFieldName("stackTrace");
        EntriesChunkSourceCreator.writeStackTrace(exception.stackTrace(), jg);
        jg.writeNumberField("framesInCommonWithCaused", exception.framesInCommonWithCaused());
        ThrowableInfo cause = exception.cause();
        if (cause != null) {
            jg.writeFieldName("cause");
            EntriesChunkSourceCreator.writeThrowable(cause, jg);
        }
        jg.writeEndObject();
    }

    private static void writeStackTrace(List<StackTraceElement> stackTrace, JsonGenerator jw) throws IOException {
        jw.writeStartArray();
        List<StackTraceElementPlus> elements = Profile.stripSyntheticTimerMethods(stackTrace);
        for (StackTraceElementPlus element : elements) {
            jw.writeString(element.stackTraceElement().toString());
        }
        jw.writeEndArray();
    }

    private static class EntriesChunkCopier
    implements ChunkSource.ChunkCopier {
        private final Iterator<TraceEntryImpl> entries;
        private final long transactionStartTick;
        private final long captureTick;
        private final JsonGenerator jg;
        private boolean closed;

        private EntriesChunkCopier(Iterator<TraceEntryImpl> entries, Writer writer, long transactionStartTick, long captureTick) throws IOException {
            this.entries = entries;
            this.transactionStartTick = transactionStartTick;
            this.captureTick = captureTick;
            this.jg = jsonFactory.createGenerator(writer);
            this.jg.writeStartArray();
        }

        @Override
        public boolean copyNext() throws IOException {
            if (this.closed) {
                this.jg.flush();
                return false;
            }
            TraceEntryImpl traceEntry = this.entries.next();
            if (!Tickers.lessThanOrEqual(traceEntry.getStartTick(), this.captureTick)) {
                this.jg.writeEndArray();
                this.closed = true;
                return true;
            }
            if (traceEntry.isLimitExceededMarker()) {
                this.writeLimitExceededEntry();
            } else if (traceEntry.isLimitExtendedMarker()) {
                this.writeLimitExtendedEntry();
            } else {
                this.writeNormalEntry(traceEntry);
            }
            if (!this.entries.hasNext()) {
                this.jg.writeEndArray();
                this.closed = true;
            }
            return true;
        }

        private void writeLimitExceededEntry() throws IOException {
            this.jg.writeStartObject();
            this.jg.writeBooleanField("limitExceededMarker", true);
            this.jg.writeEndObject();
        }

        private void writeLimitExtendedEntry() throws IOException {
            this.jg.writeStartObject();
            this.jg.writeBooleanField("limitExtendedMarker", true);
            this.jg.writeEndObject();
        }

        private void writeNormalEntry(TraceEntryImpl traceEntry) throws IOException {
            ImmutableList<StackTraceElement> stackTrace;
            ReadableErrorMessage errorMessage;
            this.jg.writeStartObject();
            this.jg.writeNumberField("offset", traceEntry.getStartTick() - this.transactionStartTick);
            this.jg.writeFieldName("duration");
            long endTick = traceEntry.getEndTick();
            if (traceEntry.isCompleted() && Tickers.lessThanOrEqual(endTick, this.captureTick)) {
                this.jg.writeNumber(endTick - traceEntry.getRevisedStartTick());
            } else {
                this.jg.writeNumber(this.captureTick - traceEntry.getRevisedStartTick());
                this.jg.writeBooleanField("active", true);
            }
            this.jg.writeNumberField("nestingLevel", traceEntry.getNestingLevel());
            MessageSupplier messageSupplier = traceEntry.getMessageSupplier();
            if (messageSupplier != null) {
                this.jg.writeFieldName("message");
                this.writeMessage((ReadableMessage)((Object)messageSupplier.get()), this.getRowCountSuffix(traceEntry));
            }
            if ((errorMessage = traceEntry.getErrorMessage()) != null) {
                this.jg.writeFieldName("error");
                this.writeErrorMessage(errorMessage);
            }
            if ((stackTrace = traceEntry.getStackTrace()) != null) {
                this.jg.writeFieldName("stackTrace");
                EntriesChunkSourceCreator.writeStackTrace(stackTrace, this.jg);
            }
            this.jg.writeEndObject();
        }

        private String getRowCountSuffix(TraceEntryImpl traceEntry) {
            if (!traceEntry.isQueryNavigationAttempted()) {
                return "";
            }
            long rowCount = traceEntry.getRowCount();
            if (rowCount == 1L) {
                return " => 1 row";
            }
            return " => " + rowCount + " rows";
        }

        private void writeMessage(ReadableMessage message, String messageSuffix) throws IOException {
            this.jg.writeStartObject();
            this.jg.writeStringField("text", message.getText() + messageSuffix);
            Map<String, ? extends Object> detail = message.getDetail();
            if (!detail.isEmpty()) {
                this.jg.writeFieldName("detail");
                new DetailMapWriter(this.jg).write(detail);
            }
            this.jg.writeEndObject();
        }

        private void writeErrorMessage(ReadableErrorMessage errorMessage) throws IOException {
            this.jg.writeStartObject();
            this.jg.writeStringField("message", errorMessage.getMessage());
            ThrowableInfo throwable = errorMessage.getThrowable();
            if (throwable != null) {
                this.jg.writeFieldName("throwable");
                EntriesChunkSourceCreator.writeThrowable(throwable, this.jg);
            }
            this.jg.writeEndObject();
        }
    }

    private static class EntriesChunkSource
    extends ChunkSource {
        private final Iterator<TraceEntryImpl> entries;
        private final long transactionStartTick;
        private final long captureTick;

        private EntriesChunkSource(Iterator<TraceEntryImpl> entries, long transactionStartTick, long captureTick) {
            this.entries = entries;
            this.transactionStartTick = transactionStartTick;
            this.captureTick = captureTick;
        }

        @Override
        public ChunkSource.ChunkCopier getCopier(Writer writer) throws IOException {
            return new EntriesChunkCopier(this.entries, writer, this.transactionStartTick, this.captureTick);
        }
    }
}

