/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.common.ObjectMappers;
import org.glowroot.markers.UsedByJsonBinding;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.fasterxml.jackson.core.type.TypeReference;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.glowroot.transaction.model.QueryData;

public class QueryComponent {
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final Map<String, Map<String, AggregateQuery>> queries = Maps.newHashMap();
    private final int hardLimitMultiplierWhileBuilding;
    private final int maxMultiplierWhileBuilding;

    public QueryComponent(int hardLimitMultiplierWhileBuilding, int maxMultiplierWhileBuilding) {
        this.hardLimitMultiplierWhileBuilding = hardLimitMultiplierWhileBuilding;
        this.maxMultiplierWhileBuilding = maxMultiplierWhileBuilding;
    }

    public Map<String, List<AggregateQuery>> getOrderedAndTruncatedQueries() {
        HashMap<String, List<AggregateQuery>> mergedQueries = Maps.newHashMap();
        for (Map.Entry<String, Map<String, AggregateQuery>> entry : this.queries.entrySet()) {
            List<AggregateQuery> aggregateQueries = Lists.newArrayList(entry.getValue().values());
            this.order(aggregateQueries);
            if (aggregateQueries.size() > this.hardLimitMultiplierWhileBuilding) {
                aggregateQueries = aggregateQueries.subList(0, this.hardLimitMultiplierWhileBuilding);
            }
            mergedQueries.put(entry.getKey(), aggregateQueries);
        }
        return mergedQueries;
    }

    public void mergeQueries(String queriesContent) throws IOException {
        Map<String, List<AggregateQuery>> toBeMergedQueries = ObjectMappers.readRequiredValue(mapper, queriesContent, new TypeReference<Map<String, List<AggregateQuery>>>(){});
        for (Map.Entry<String, List<AggregateQuery>> entry : toBeMergedQueries.entrySet()) {
            String queryType = entry.getKey();
            Map<String, AggregateQuery> queriesForQueryType = this.queries.get(queryType);
            if (queriesForQueryType == null) {
                queriesForQueryType = Maps.newHashMap();
                this.queries.put(queryType, queriesForQueryType);
            }
            for (AggregateQuery query : entry.getValue()) {
                this.mergeQuery(query.getQueryText(), query.getTotalMicros(), query.getExecutionCount(), query.getTotalRows(), queriesForQueryType);
            }
        }
    }

    void mergeQueries(String queryType, Map<String, QueryData> toBeMergedQueries) {
        Map<String, AggregateQuery> queriesForQueryType = this.queries.get(queryType);
        if (queriesForQueryType == null) {
            queriesForQueryType = Maps.newHashMap();
            this.queries.put(queryType, queriesForQueryType);
        }
        for (Map.Entry<String, QueryData> toBeMergedQuery : toBeMergedQueries.entrySet()) {
            String queryText = toBeMergedQuery.getKey();
            QueryData queryData = toBeMergedQuery.getValue();
            this.mergeQuery(queryText, TimeUnit.NANOSECONDS.toMicros(queryData.getTotalTime()), queryData.getExecutionCount(), queryData.getTotalRows(), queriesForQueryType);
        }
    }

    private void mergeQuery(String queryText, long totalMicros, long executionCount, long totalRows, Map<String, AggregateQuery> queriesForQueryType) {
        AggregateQuery aggregateQuery = queriesForQueryType.get(queryText);
        if (aggregateQuery == null) {
            if (this.maxMultiplierWhileBuilding != 0 && queriesForQueryType.size() >= this.hardLimitMultiplierWhileBuilding * this.maxMultiplierWhileBuilding) {
                return;
            }
            aggregateQuery = new AggregateQuery(queryText);
            queriesForQueryType.put(queryText, aggregateQuery);
        }
        AggregateQuery aggregateQuery2 = aggregateQuery;
        aggregateQuery2.totalMicros = aggregateQuery2.totalMicros + totalMicros;
        aggregateQuery2 = aggregateQuery;
        aggregateQuery2.executionCount = aggregateQuery2.executionCount + executionCount;
        aggregateQuery2 = aggregateQuery;
        aggregateQuery2.totalRows = aggregateQuery2.totalRows + totalRows;
    }

    private void order(List<AggregateQuery> aggregateQueries) {
        Collections.sort(aggregateQueries, new Comparator<AggregateQuery>(){

            @Override
            public int compare(AggregateQuery aggregateQuery1, AggregateQuery aggregateQuery2) {
                return Longs.compare(aggregateQuery2.getTotalMicros(), aggregateQuery1.getTotalMicros());
            }
        });
    }

    @UsedByJsonBinding
    public static class AggregateQuery {
        private final String queryText;
        private long totalMicros;
        private long executionCount;
        private long totalRows;

        private AggregateQuery(String queryText) {
            this.queryText = queryText;
        }

        public String getQueryText() {
            return this.queryText;
        }

        public long getTotalMicros() {
            return this.totalMicros;
        }

        public long getExecutionCount() {
            return this.executionCount;
        }

        public long getTotalRows() {
            return this.totalRows;
        }

        @JsonCreator
        static AggregateQuery readValue(@JsonProperty(value="queryText") @Nullable String queryText, @JsonProperty(value="totalMicros") @Nullable Long totalMicros, @JsonProperty(value="executionCount") @Nullable Long executionCount, @JsonProperty(value="totalRows") @Nullable Long totalRows) throws JsonMappingException {
            ObjectMappers.checkRequiredProperty(queryText, "queryText");
            ObjectMappers.checkRequiredProperty(totalMicros, "totalMicros");
            ObjectMappers.checkRequiredProperty(executionCount, "executionCount");
            ObjectMappers.checkRequiredProperty(totalRows, "totalRows");
            AggregateQuery aggregateQuery = new AggregateQuery(queryText);
            aggregateQuery.totalMicros = totalMicros;
            aggregateQuery.executionCount = executionCount;
            aggregateQuery.totalRows = totalRows;
            return aggregateQuery;
        }
    }
}

