/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.api.PluginServices;
import org.glowroot.config.ConfigService;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.model.Transaction;

class StackTraceCollector
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StackTraceCollector.class);
    private final TransactionRegistry transactionRegistry;
    private final ConfigService configService;
    private final ScheduledExecutorService scheduledExecutor;
    private volatile boolean currentEnabled;
    private volatile int currentIntervalMillis;
    @Nullable
    private volatile Future<?> currentFuture;

    public static StackTraceCollector create(TransactionRegistry transactionRegistry, ConfigService configService, ScheduledExecutorService scheduledExecutor) {
        final StackTraceCollector stackTraceCollector = new StackTraceCollector(transactionRegistry, configService, scheduledExecutor);
        configService.addConfigListener(new PluginServices.ConfigListener(){

            @Override
            public void onChange() {
                stackTraceCollector.updateScheduleIfNeeded();
            }
        });
        return stackTraceCollector;
    }

    private StackTraceCollector(TransactionRegistry transactionRegistry, ConfigService configService, ScheduledExecutorService scheduledExecutor) {
        this.transactionRegistry = transactionRegistry;
        this.configService = configService;
        this.scheduledExecutor = scheduledExecutor;
    }

    @Override
    public void run() {
        try {
            this.runInternal();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    private void updateScheduleIfNeeded() {
        boolean newEnabled = this.configService.getGeneralConfig().enabled();
        int newIntervalMillis = this.configService.getGeneralConfig().profilingIntervalMillis();
        if (newEnabled != this.currentEnabled || newIntervalMillis != this.currentIntervalMillis) {
            if (this.currentFuture != null) {
                this.currentFuture.cancel(false);
            }
            if (newEnabled && newIntervalMillis > 0) {
                this.currentFuture = this.scheduledExecutor.scheduleAtFixedRate(this, newIntervalMillis, newIntervalMillis, TimeUnit.MILLISECONDS);
            }
            this.currentEnabled = newEnabled;
            this.currentIntervalMillis = newIntervalMillis;
        }
    }

    private void runInternal() {
        ImmutableList<Transaction> transactions = ImmutableList.copyOf(this.transactionRegistry.getTransactions());
        if (transactions.isEmpty()) {
            return;
        }
        long[] threadIds = new long[transactions.size()];
        for (int i = 0; i < transactions.size(); ++i) {
            threadIds[i] = ((Transaction)transactions.get(i)).getThreadId();
        }
        ThreadInfo[] threadInfos = ManagementFactory.getThreadMXBean().getThreadInfo(threadIds, Integer.MAX_VALUE);
        for (int i = 0; i < transactions.size(); ++i) {
            ((Transaction)transactions.get(i)).captureStackTrace(threadInfos[i], this.configService.getAdvancedConfig().maxStackTraceSamplesPerTransaction(), this.configService.getAdvancedConfig().timerWrapperMethods());
        }
    }

    @OnlyUsedByTests
    void close() {
        if (this.currentFuture != null) {
            this.currentFuture.cancel(false);
        }
    }
}

