/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.api.internal.ReadableErrorMessage;
import org.glowroot.api.internal.ThrowableInfo;
import org.glowroot.collector.DetailMapWriter;
import org.glowroot.collector.EntriesChunkSourceCreator;
import org.glowroot.collector.Existence;
import org.glowroot.collector.Trace;
import org.glowroot.common.ObjectMappers;
import org.glowroot.shaded.fasterxml.jackson.core.JsonFactory;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.ImmutableSetMultimap;
import org.glowroot.shaded.google.common.io.CharStreams;
import org.glowroot.transaction.model.GcInfo;
import org.glowroot.transaction.model.ThreadInfoData;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.Transaction;

public class TraceCreator {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ObjectMapper mapper = ObjectMappers.create();

    private TraceCreator() {
    }

    public static Trace createActiveTrace(Transaction transaction, long captureTime, long captureTick) throws IOException {
        return TraceCreator.createTrace(transaction, true, false, captureTime, captureTick);
    }

    static Trace createPartialTrace(Transaction transaction, long captureTime, long captureTick) throws IOException {
        return TraceCreator.createTrace(transaction, true, true, captureTime, captureTick);
    }

    public static Trace createCompletedTrace(Transaction transaction) throws IOException {
        return TraceCreator.createTrace(transaction, false, false, transaction.getCaptureTime(), transaction.getEndTick());
    }

    private static Trace createTrace(Transaction transaction, boolean active, boolean partial, long captureTime, long captureTick) throws IOException {
        List<GcInfo> gcInfos;
        Trace.Builder builder = Trace.builder();
        builder.id(transaction.getId());
        builder.active(active);
        builder.partial(partial);
        ReadableErrorMessage errorMessage = transaction.getErrorMessage();
        builder.error(errorMessage != null);
        builder.startTime(transaction.getStartTime());
        builder.captureTime(captureTime);
        builder.duration(captureTick - transaction.getStartTick());
        builder.transactionType(transaction.getTransactionType());
        builder.transactionName(transaction.getTransactionName());
        builder.headline(transaction.getHeadline());
        builder.user(transaction.getUser());
        ImmutableSetMultimap<String, String> customAttributes = transaction.getCustomAttributes();
        builder.customAttributes(TraceCreator.writeCustomAttributesAsString(customAttributes));
        builder.customAttributesForIndexing(customAttributes);
        builder.customDetail(TraceCreator.writeCustomDetailAsString(transaction.getCustomDetail()));
        if (errorMessage != null) {
            builder.errorMessage(errorMessage.getMessage());
            builder.errorThrowable(TraceCreator.writeExceptionAsString(errorMessage.getThrowable()));
        }
        builder.timers(TraceCreator.writeTimersAsString(transaction.getRootTimer()));
        ThreadInfoData threadInfo = transaction.getThreadInfo();
        if (threadInfo != null) {
            builder.threadCpuTime(threadInfo.threadCpuTime());
            builder.threadBlockedTime(threadInfo.threadBlockedTime());
            builder.threadWaitedTime(threadInfo.threadWaitedTime());
            builder.threadAllocatedBytes(threadInfo.threadAllocatedBytes());
        }
        if ((gcInfos = transaction.getGcInfos()) != null) {
            builder.gcInfos(mapper.writeValueAsString(gcInfos));
        }
        int entryCount = transaction.getEntryCount();
        int profileSampleCount = transaction.getProfileSampleCount();
        builder.entryCount(entryCount);
        builder.profileSampleCount(profileSampleCount);
        if (entryCount == 0) {
            builder.entriesExistence(Existence.NO);
        } else {
            builder.entriesExistence(Existence.YES);
        }
        if (transaction.getProfile() == null) {
            builder.profileExistence(Existence.NO);
        } else {
            builder.profileExistence(Existence.YES);
        }
        return builder.build();
    }

    @Nullable
    private static String writeCustomAttributesAsString(ImmutableSetMultimap<String, String> attributes) throws IOException {
        if (attributes.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        for (Map.Entry entry : ((ImmutableMap)attributes.asMap()).entrySet()) {
            jg.writeArrayFieldStart((String)entry.getKey());
            for (String value : (Collection)entry.getValue()) {
                jg.writeString(value);
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @Nullable
    private static String writeCustomDetailAsString(Map<String, ? extends Object> detail) throws IOException {
        if (detail == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
        new DetailMapWriter(jg).write(detail);
        jg.close();
        return sb.toString();
    }

    @Nullable
    private static String writeExceptionAsString(@Nullable ThrowableInfo exception) throws IOException {
        if (exception == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
        EntriesChunkSourceCreator.writeThrowable(exception, jg);
        jg.close();
        return sb.toString();
    }

    @Nullable
    private static String writeTimersAsString(TimerImpl rootTimer) throws IOException {
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
        rootTimer.writeValue(jg);
        jg.close();
        return sb.toString();
    }
}

