/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.glowroot.collector.AggregateCollector;
import org.glowroot.collector.EntriesChunkSourceCreator;
import org.glowroot.collector.ProfileChunkSourceCreator;
import org.glowroot.collector.Trace;
import org.glowroot.collector.TraceCreator;
import org.glowroot.collector.TraceRepository;
import org.glowroot.common.ChunkSource;
import org.glowroot.common.Clock;
import org.glowroot.config.ConfigService;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.markers.UsedByReflection;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.google.common.util.concurrent.RateLimiter;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.model.Transaction;

public class TransactionCollectorImpl
implements TransactionCollector {
    private static final Logger logger = LoggerFactory.getLogger(TransactionCollectorImpl.class);
    private static final int PENDING_LIMIT = 100;
    @OnlyUsedByTests
    @UsedByReflection
    private static boolean useSynchronousStore;
    private final ExecutorService executorService;
    private final ConfigService configService;
    private final TraceRepository traceRepository;
    private final AggregateCollector aggregateCollector;
    private final Clock clock;
    private final Ticker ticker;
    private final Set<Transaction> pendingTransactions = Sets.newCopyOnWriteArraySet();
    private final RateLimiter warningRateLimiter = RateLimiter.create(0.016666666666666666);
    @GuardedBy(value="warningLock")
    private int countSinceLastWarning;

    TransactionCollectorImpl(ExecutorService executorService, ConfigService configService, TraceRepository traceRepository, AggregateCollector aggregateCollector, Clock clock, Ticker ticker) {
        this.executorService = executorService;
        this.configService = configService;
        this.traceRepository = traceRepository;
        this.aggregateCollector = aggregateCollector;
        this.clock = clock;
        this.ticker = ticker;
    }

    @Override
    public boolean shouldStore(Transaction transaction) {
        String user;
        if (transaction.isPartiallyStored() || transaction.getErrorMessage() != null) {
            return true;
        }
        if (this.configService.getUserRecordingConfig().enabled() && !Strings.isNullOrEmpty(user = transaction.getUser()) && user.equalsIgnoreCase(this.configService.getUserRecordingConfig().user())) {
            return true;
        }
        long traceStoreThresholdMillis = transaction.getTraceStoreThresholdMillisOverride();
        if (traceStoreThresholdMillis != -1L) {
            return transaction.getDuration() >= TimeUnit.MILLISECONDS.toNanos(traceStoreThresholdMillis);
        }
        traceStoreThresholdMillis = this.configService.getGeneralConfig().traceStoreThresholdMillis();
        return transaction.getDuration() >= TimeUnit.MILLISECONDS.toNanos(traceStoreThresholdMillis);
    }

    @Override
    public Collection<Transaction> getPendingTransactions() {
        return this.pendingTransactions;
    }

    @Override
    public void onCompletedTransaction(final Transaction transaction) {
        transaction.onCompleteCaptureThreadInfo();
        long captureTime = this.aggregateCollector.add(transaction);
        if (!this.shouldStore(transaction)) {
            return;
        }
        if (this.pendingTransactions.size() >= 100) {
            this.logPendingLimitWarning();
            return;
        }
        this.pendingTransactions.add(transaction);
        transaction.onCompleteCaptureGcInfo();
        transaction.onComplete(captureTime);
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    Trace trace = TraceCreator.createCompletedTrace(transaction);
                    TransactionCollectorImpl.this.store(trace, transaction);
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    TransactionCollectorImpl.this.pendingTransactions.remove(transaction);
                }
            }
        };
        if (useSynchronousStore) {
            command.run();
        } else {
            this.executorService.execute(command);
        }
    }

    @Override
    public void storePartialTrace(Transaction transaction) {
        try {
            Trace trace = TraceCreator.createPartialTrace(transaction, this.clock.currentTimeMillis(), this.ticker.read());
            transaction.setPartiallyStored();
            if (!transaction.isCompleted()) {
                this.store(trace, transaction);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logPendingLimitWarning() {
        RateLimiter rateLimiter = this.warningRateLimiter;
        synchronized (rateLimiter) {
            if (this.warningRateLimiter.tryAcquire(0L, TimeUnit.MILLISECONDS)) {
                logger.warn("not storing a trace because of an excessive backlog of {} traces already waiting to be stored (this warning will appear at most once a minute, there were {} additional traces not stored since the last warning)", (Object)100, (Object)this.countSinceLastWarning);
                this.countSinceLastWarning = 0;
            } else {
                ++this.countSinceLastWarning;
            }
        }
    }

    private void store(Trace trace, Transaction transaction) throws Exception {
        long captureTick = transaction.isCompleted() ? transaction.getEndTick() : this.ticker.read();
        ChunkSource entries = EntriesChunkSourceCreator.createEntriesChunkSource(transaction.getEntries(), transaction.getStartTick(), captureTick);
        ChunkSource profile = ProfileChunkSourceCreator.createProfileChunkSource(transaction.getProfile());
        this.traceRepository.store(trace, entries, profile);
    }
}

