/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.core.JsonParser;
import org.glowroot.shaded.fasterxml.jackson.core.type.TypeReference;
import org.glowroot.shaded.fasterxml.jackson.databind.BeanDescription;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationConfig;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.shaded.fasterxml.jackson.databind.JavaType;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.shaded.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.glowroot.shaded.fasterxml.jackson.databind.module.SimpleModule;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.GuavaModule;
import org.glowroot.shaded.google.common.collect.ImmutableList;

public class ObjectMappers {
    private ObjectMappers() {
    }

    public static ObjectMapper create() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new EnumDeserializerModifier());
        module.addSerializer(Enum.class, new EnumSerializer(Enum.class));
        mapper.registerModule(module);
        mapper.registerModule(new GuavaModule());
        return mapper;
    }

    public static <T> T readRequiredValue(ObjectMapper mapper, String content, Class<T> valueType) throws IOException {
        T value = mapper.readValue(content, valueType);
        if (value == null) {
            throw new JsonMappingException("Content is json null");
        }
        return value;
    }

    public static <T> T readRequiredValue(ObjectMapper mapper, String content, TypeReference<T> valueTypeRef) throws IOException {
        Object value = mapper.readValue(content, valueTypeRef);
        if (value == null) {
            throw new JsonMappingException("Content is json null");
        }
        return value;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> void checkRequiredProperty(T reference, String fieldName) throws JsonMappingException {
        if (reference == null) {
            throw new JsonMappingException("Null value not allowed for field: " + fieldName);
        }
    }

    public static <T> List<T> orEmpty(@Nullable List<T> list, String fieldName) throws JsonMappingException {
        if (list == null) {
            return ImmutableList.of();
        }
        for (T item : list) {
            if (item != null) continue;
            throw new JsonMappingException("Null items are not allowed in array field: " + fieldName);
        }
        return list;
    }

    private static class EnumDeserializerModifier
    extends BeanDeserializerModifier {
        private EnumDeserializerModifier() {
        }

        public JsonDeserializer<Enum> modifyEnumDeserializer(DeserializationConfig config, final JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            return new JsonDeserializer<Enum>(){

                @Override
                public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                    Class<?> rawClass = type.getRawClass();
                    return Enum.valueOf(rawClass, jp.getValueAsString().replace('-', '_').toUpperCase(Locale.ENGLISH));
                }
            };
        }
    }

    private static class EnumSerializer
    extends StdSerializer<Enum> {
        private EnumSerializer(Class<Enum> t) {
            super(t);
        }

        @Override
        public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.name().replace('_', '-').toLowerCase(Locale.ENGLISH));
        }
    }
}

