/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.GaugeConfigBase;
import org.glowroot.config.MBeanAttribute;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
public final class GaugeConfig
extends GaugeConfigBase {
    private final String mbeanObjectName;
    private final ImmutableList<MBeanAttribute> mbeanAttributes;
    private final String display;
    private final String version;

    private GaugeConfig(Builder builder) {
        this.mbeanObjectName = builder.mbeanObjectName;
        this.mbeanAttributes = builder.mbeanAttributesBuilder.build();
        this.display = Preconditions.checkNotNull(super.display());
        this.version = Preconditions.checkNotNull(super.version());
    }

    private GaugeConfig(GaugeConfig original, String mbeanObjectName, ImmutableList<MBeanAttribute> mbeanAttributes) {
        this.mbeanObjectName = mbeanObjectName;
        this.mbeanAttributes = mbeanAttributes;
        this.display = Preconditions.checkNotNull(super.display());
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="mbeanObjectName")
    public String mbeanObjectName() {
        return this.mbeanObjectName;
    }

    @Override
    @JsonProperty(value="mbeanAttributes")
    public ImmutableList<MBeanAttribute> mbeanAttributes() {
        return this.mbeanAttributes;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="display")
    public String display() {
        return this.display;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final GaugeConfig withMbeanObjectName(String value) {
        if (this.mbeanObjectName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GaugeConfig(this, newValue, this.mbeanAttributes);
    }

    public final GaugeConfig withMbeanAttributes(MBeanAttribute ... elements) {
        ImmutableList<MBeanAttribute> newValue = ImmutableList.copyOf(elements);
        return new GaugeConfig(this, this.mbeanObjectName, newValue);
    }

    public final GaugeConfig withMbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
        if (this.mbeanAttributes == elements) {
            return this;
        }
        ImmutableList<MBeanAttribute> newValue = ImmutableList.copyOf(elements);
        return new GaugeConfig(this, this.mbeanObjectName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GaugeConfig && this.equalTo((GaugeConfig)another);
    }

    private boolean equalTo(GaugeConfig another) {
        return this.mbeanObjectName.equals(another.mbeanObjectName) && this.mbeanAttributes.equals(another.mbeanAttributes) && this.display.equals(another.display) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.mbeanObjectName.hashCode();
        h = h * 17 + this.mbeanAttributes.hashCode();
        h = h * 17 + this.display.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugeConfig").add("mbeanObjectName", this.mbeanObjectName).add("mbeanAttributes", this.mbeanAttributes).add("display", this.display).add("version", this.version).toString();
    }

    @JsonCreator
    public static GaugeConfig fromAllAttributes(@JsonProperty(value="mbeanObjectName") @Nullable String mbeanObjectName, @JsonProperty(value="mbeanAttributes") @Nullable ImmutableList<MBeanAttribute> mbeanAttributes) {
        Builder builder = GaugeConfig.builder();
        if (mbeanObjectName != null) {
            builder.mbeanObjectName(mbeanObjectName);
        }
        if (mbeanAttributes != null) {
            builder.addAllMbeanAttributes(mbeanAttributes);
        }
        return builder.build();
    }

    public static GaugeConfig copyOf(GaugeConfigBase instance) {
        if (instance instanceof GaugeConfig) {
            return (GaugeConfig)instance;
        }
        return GaugeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_MBEAN_OBJECT_NAME = 1L;
        private long initializedBitset;
        @Nullable
        private String mbeanObjectName;
        private ImmutableList.Builder<MBeanAttribute> mbeanAttributesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(GaugeConfigBase instance) {
            Preconditions.checkNotNull(instance);
            this.mbeanObjectName(instance.mbeanObjectName());
            this.addAllMbeanAttributes(instance.mbeanAttributes());
            return this;
        }

        public final Builder mbeanObjectName(String mbeanObjectName) {
            this.mbeanObjectName = Preconditions.checkNotNull(mbeanObjectName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addMbeanAttributes(MBeanAttribute element) {
            this.mbeanAttributesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMbeanAttributes(MBeanAttribute ... elements) {
            this.mbeanAttributesBuilder.add(elements);
            return this;
        }

        public final Builder mbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
            this.mbeanAttributesBuilder = ImmutableList.builder();
            return this.addAllMbeanAttributes(elements);
        }

        public final Builder addAllMbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
            this.mbeanAttributesBuilder.addAll(elements);
            return this;
        }

        public GaugeConfig build() {
            this.checkRequiredAttributes();
            return new GaugeConfig(this);
        }

        private boolean mbeanObjectNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.mbeanObjectNameIsSet()) {
                attributes.add("mbeanObjectName");
            }
            return "Cannot build GaugeConfig, some of required attributes are not set " + attributes;
        }
    }
}

