/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.config.GaugeConfig;
import org.glowroot.config.MBeanAttribute;
import org.glowroot.config.Versions;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.base.CharMatcher;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Splitter;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.immutables.value.Value;

@JsonSerialize
@Value.Immutable
public abstract class GaugeConfigBase {
    public static final Ordering<GaugeConfig> orderingByName = new Ordering<GaugeConfig>(){

        @Override
        public int compare(@Nullable GaugeConfig left, @Nullable GaugeConfig right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return left.display().compareToIgnoreCase(right.display());
        }
    };

    public abstract String mbeanObjectName();

    public abstract ImmutableList<MBeanAttribute> mbeanAttributes();

    @JsonIgnore
    public String display() {
        List<String> parts = Splitter.on(CharMatcher.anyOf(":,")).splitToList(this.mbeanObjectName());
        StringBuilder name = new StringBuilder();
        name.append(parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            name.append('/');
            name.append(parts.get(i).split("=")[1]);
        }
        return name.toString();
    }

    @JsonIgnore
    public String version() {
        return Versions.getVersion(this);
    }

    @JsonSerialize
    @Value.Immutable
    public static abstract class MBeanAttributeBase {
        public abstract String name();

        public abstract boolean everIncreasing();
    }
}

