/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.StorageConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;

@ParametersAreNonnullByDefault
@Immutable
public final class StorageConfig
extends StorageConfigBase {
    private final int aggregateExpirationHours;
    private final int traceExpirationHours;
    private final int gaugeExpirationHours;
    private final int cappedDatabaseSizeMb;
    private final String version;

    private StorageConfig(Builder builder) {
        this.aggregateExpirationHours = builder.aggregateExpirationHoursIsSet() ? builder.aggregateExpirationHours : super.aggregateExpirationHours();
        this.traceExpirationHours = builder.traceExpirationHoursIsSet() ? builder.traceExpirationHours : super.traceExpirationHours();
        this.gaugeExpirationHours = builder.gaugeExpirationHoursIsSet() ? builder.gaugeExpirationHours : super.gaugeExpirationHours();
        this.cappedDatabaseSizeMb = builder.cappedDatabaseSizeMbIsSet() ? builder.cappedDatabaseSizeMb : super.cappedDatabaseSizeMb();
        this.version = Preconditions.checkNotNull(super.version());
    }

    private StorageConfig(StorageConfig original, int aggregateExpirationHours, int traceExpirationHours, int gaugeExpirationHours, int cappedDatabaseSizeMb) {
        this.aggregateExpirationHours = aggregateExpirationHours;
        this.traceExpirationHours = traceExpirationHours;
        this.gaugeExpirationHours = gaugeExpirationHours;
        this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="aggregateExpirationHours")
    public int aggregateExpirationHours() {
        return this.aggregateExpirationHours;
    }

    @Override
    @JsonProperty(value="traceExpirationHours")
    public int traceExpirationHours() {
        return this.traceExpirationHours;
    }

    @Override
    @JsonProperty(value="gaugeExpirationHours")
    public int gaugeExpirationHours() {
        return this.gaugeExpirationHours;
    }

    @Override
    @JsonProperty(value="cappedDatabaseSizeMb")
    public int cappedDatabaseSizeMb() {
        return this.cappedDatabaseSizeMb;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final StorageConfig withAggregateExpirationHours(int value) {
        if (this.aggregateExpirationHours == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfig(this, newValue, this.traceExpirationHours, this.gaugeExpirationHours, this.cappedDatabaseSizeMb);
    }

    public final StorageConfig withTraceExpirationHours(int value) {
        if (this.traceExpirationHours == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfig(this, this.aggregateExpirationHours, newValue, this.gaugeExpirationHours, this.cappedDatabaseSizeMb);
    }

    public final StorageConfig withGaugeExpirationHours(int value) {
        if (this.gaugeExpirationHours == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfig(this, this.aggregateExpirationHours, this.traceExpirationHours, newValue, this.cappedDatabaseSizeMb);
    }

    public final StorageConfig withCappedDatabaseSizeMb(int value) {
        if (this.cappedDatabaseSizeMb == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfig(this, this.aggregateExpirationHours, this.traceExpirationHours, this.gaugeExpirationHours, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof StorageConfig && this.equalTo((StorageConfig)another);
    }

    private boolean equalTo(StorageConfig another) {
        return this.aggregateExpirationHours == another.aggregateExpirationHours && this.traceExpirationHours == another.traceExpirationHours && this.gaugeExpirationHours == another.gaugeExpirationHours && this.cappedDatabaseSizeMb == another.cappedDatabaseSizeMb && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.aggregateExpirationHours;
        h = h * 17 + this.traceExpirationHours;
        h = h * 17 + this.gaugeExpirationHours;
        h = h * 17 + this.cappedDatabaseSizeMb;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StorageConfig").add("aggregateExpirationHours", this.aggregateExpirationHours).add("traceExpirationHours", this.traceExpirationHours).add("gaugeExpirationHours", this.gaugeExpirationHours).add("cappedDatabaseSizeMb", this.cappedDatabaseSizeMb).add("version", this.version).toString();
    }

    @JsonCreator
    public static StorageConfig fromAllAttributes(@JsonProperty(value="aggregateExpirationHours") @Nullable Integer aggregateExpirationHours, @JsonProperty(value="traceExpirationHours") @Nullable Integer traceExpirationHours, @JsonProperty(value="gaugeExpirationHours") @Nullable Integer gaugeExpirationHours, @JsonProperty(value="cappedDatabaseSizeMb") @Nullable Integer cappedDatabaseSizeMb) {
        Builder builder = StorageConfig.builder();
        if (aggregateExpirationHours != null) {
            builder.aggregateExpirationHours(aggregateExpirationHours);
        }
        if (traceExpirationHours != null) {
            builder.traceExpirationHours(traceExpirationHours);
        }
        if (gaugeExpirationHours != null) {
            builder.gaugeExpirationHours(gaugeExpirationHours);
        }
        if (cappedDatabaseSizeMb != null) {
            builder.cappedDatabaseSizeMb(cappedDatabaseSizeMb);
        }
        return builder.build();
    }

    public static StorageConfig copyOf(StorageConfigBase instance) {
        if (instance instanceof StorageConfig) {
            return (StorageConfig)instance;
        }
        return StorageConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_AGGREGATE_EXPIRATION_HOURS = 1L;
        private static final long NONDEFAULT_BIT_TRACE_EXPIRATION_HOURS = 2L;
        private static final long NONDEFAULT_BIT_GAUGE_EXPIRATION_HOURS = 4L;
        private static final long NONDEFAULT_BIT_CAPPED_DATABASE_SIZE_MB = 8L;
        private long nondefaultBitset;
        private int aggregateExpirationHours;
        private int traceExpirationHours;
        private int gaugeExpirationHours;
        private int cappedDatabaseSizeMb;

        private Builder() {
        }

        public final Builder from(StorageConfigBase instance) {
            Preconditions.checkNotNull(instance);
            this.aggregateExpirationHours(instance.aggregateExpirationHours());
            this.traceExpirationHours(instance.traceExpirationHours());
            this.gaugeExpirationHours(instance.gaugeExpirationHours());
            this.cappedDatabaseSizeMb(instance.cappedDatabaseSizeMb());
            return this;
        }

        public final Builder aggregateExpirationHours(int aggregateExpirationHours) {
            this.aggregateExpirationHours = aggregateExpirationHours;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder traceExpirationHours(int traceExpirationHours) {
            this.traceExpirationHours = traceExpirationHours;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder gaugeExpirationHours(int gaugeExpirationHours) {
            this.gaugeExpirationHours = gaugeExpirationHours;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder cappedDatabaseSizeMb(int cappedDatabaseSizeMb) {
            this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public StorageConfig build() {
            return new StorageConfig(this);
        }

        private boolean aggregateExpirationHoursIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean traceExpirationHoursIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean gaugeExpirationHoursIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean cappedDatabaseSizeMbIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }
    }
}

