/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container;

import com.google.common.base.Preconditions;
import org.glowroot.GlowrootModule;
import org.glowroot.MainEntryPoint;
import org.glowroot.config.ConfigModule;
import org.glowroot.config.ConfigService;
import org.glowroot.config.PluginConfig;

public class AppUnderTestServices {
    public static AppUnderTestServices get() {
        return new AppUnderTestServices();
    }

    private AppUnderTestServices() {
    }

    public void setPluginEnabled(String pluginId, boolean enabled) throws Exception {
        ConfigService configService = AppUnderTestServices.getConfigService();
        PluginConfig config = configService.getPluginConfig(pluginId);
        if (config == null) {
            throw new IllegalStateException("Plugin not found for pluginId: " + pluginId);
        }
        PluginConfig updatedConfig = config.withEnabled(enabled);
        configService.updatePluginConfig(updatedConfig, config.version());
    }

    private static ConfigService getConfigService() {
        GlowrootModule glowrootModule = MainEntryPoint.getGlowrootModule();
        Preconditions.checkNotNull((Object)glowrootModule);
        ConfigModule configModule = glowrootModule.getConfigModule();
        return configModule.getConfigService();
    }
}

