/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.common;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public class HttpClient {
    private final AsyncHttpClient asyncHttpClient;
    private volatile int port;
    @Nullable
    private volatile Cookie sessionIdCookie;

    public HttpClient(int uiPort) {
        this.port = uiPort;
        this.asyncHttpClient = HttpClient.createAsyncHttpClient();
    }

    public void updateUiPort(int uiPort) {
        this.port = uiPort;
    }

    public String get(String path) throws Exception {
        String url = "http://localhost:" + this.port + path;
        AsyncHttpClient.BoundRequestBuilder request = this.asyncHttpClient.prepareGet(url);
        Response response = this.execute(request);
        return HttpClient.validateAndReturnBody(response, url);
    }

    public InputStream getAsStream(String path) throws Exception {
        String url = "http://localhost:" + this.port + path;
        AsyncHttpClient.BoundRequestBuilder request = this.asyncHttpClient.prepareGet(url);
        Response response = this.execute(request);
        return HttpClient.validateAndReturnBodyAsStream(response, url);
    }

    public String post(String path, String data) throws Exception {
        String url = "http://localhost:" + this.port + path;
        AsyncHttpClient.BoundRequestBuilder request = this.asyncHttpClient.preparePost(url);
        request.setBody(data);
        Response response = this.execute(request);
        return HttpClient.validateAndReturnBody(response, url);
    }

    public void close() {
        this.asyncHttpClient.close();
    }

    private Response execute(AsyncHttpClient.BoundRequestBuilder request) throws Exception {
        this.populateSessionIdCookie(request);
        Response response = (Response)request.execute().get();
        this.extractSessionIdCookie(response);
        return response;
    }

    private void populateSessionIdCookie(AsyncHttpClient.BoundRequestBuilder request) {
        if (this.sessionIdCookie != null) {
            request.addCookie(this.sessionIdCookie);
        }
    }

    private void extractSessionIdCookie(Response response) {
        for (Cookie cookie : response.getCookies()) {
            if (!cookie.getName().equals("GLOWROOT_SESSION_ID")) continue;
            this.sessionIdCookie = cookie.getValue().isEmpty() ? null : cookie;
            return;
        }
    }

    private static String validateAndReturnBody(Response response, String url) throws Exception {
        if (response.getStatusCode() == HttpResponseStatus.OK.code()) {
            return response.getResponseBody();
        }
        throw new IllegalStateException("HTTP status code " + response.getStatusCode() + " was returned for url: " + url);
    }

    private static InputStream validateAndReturnBodyAsStream(Response response, String url) throws Exception {
        if (response.getStatusCode() == HttpResponseStatus.OK.code()) {
            return response.getResponseBodyAsStream();
        }
        throw new IllegalStateException("HTTP status code " + response.getStatusCode() + " was returned for url: " + url);
    }

    private static AsyncHttpClient createAsyncHttpClient() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder().setCompressionEnabled(true).setMaxRequestRetry(0).setExecutorService(executorService);
        NettyAsyncHttpProviderConfig providerConfig = new NettyAsyncHttpProviderConfig();
        providerConfig.addProperty("bossExecutorService", (Object)executorService);
        builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
        return new AsyncHttpClient(builder.build());
    }
}

