/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class GaugeConfig {
    @Nullable
    private String display;
    @Nullable
    private String mbeanObjectName;
    private List<MBeanAttribute> mbeanAttributes = Lists.newArrayList();
    @Nullable
    private final String version;

    public GaugeConfig() {
        this.version = null;
    }

    private GaugeConfig(String display, String version) {
        this.display = display;
        this.version = version;
    }

    @Nullable
    public String getDisplay() {
        return this.display;
    }

    @Nullable
    public String getMBeanObjectName() {
        return this.mbeanObjectName;
    }

    public void setMBeanObjectName(String mbeanObjectName) {
        this.mbeanObjectName = mbeanObjectName;
    }

    public List<MBeanAttribute> getMBeanAttributes() {
        return this.mbeanAttributes;
    }

    public void setMBeanAttributes(List<MBeanAttribute> mbeanAttributes) {
        this.mbeanAttributes = mbeanAttributes;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof GaugeConfig) {
            GaugeConfig that = (GaugeConfig)obj;
            return Objects.equal((Object)this.mbeanObjectName, (Object)that.mbeanObjectName) && Objects.equal(this.mbeanAttributes, that.mbeanAttributes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mbeanObjectName, this.mbeanAttributes});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mbeanObjectName", (Object)this.mbeanObjectName).add("mbeanAttributes", this.mbeanAttributes).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static GaugeConfig readValue(@JsonProperty(value="display") @Nullable String display, @JsonProperty(value="mbeanObjectName") @Nullable String mbeanObjectName, @JsonProperty(value="mbeanAttributes") @Nullable List<MBeanAttribute> mbeanAttributes, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(display, "display");
        ObjectMappers.checkRequiredProperty(mbeanObjectName, "mbeanObjectName");
        ObjectMappers.checkRequiredProperty(mbeanAttributes, "mbeanAttributes");
        ObjectMappers.checkRequiredProperty(version, "version");
        GaugeConfig config = new GaugeConfig(display, version);
        config.setMBeanObjectName(mbeanObjectName);
        config.setMBeanAttributes(mbeanAttributes);
        return config;
    }

    public static class MBeanAttribute {
        @Nullable
        private String name;
        private boolean everIncreasing;

        @Nullable
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEverIncreasing() {
            return this.everIncreasing;
        }

        public void setEverIncreasing(boolean everIncreasing) {
            this.everIncreasing = everIncreasing;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof MBeanAttribute) {
                MBeanAttribute that = (MBeanAttribute)obj;
                return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.everIncreasing, (Object)that.everIncreasing);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.everIncreasing});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("everIncreasing", this.everIncreasing).toString();
        }

        @JsonCreator
        static MBeanAttribute readValue(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="everIncreasing") @Nullable Boolean everIncreasing) throws JsonMappingException {
            ObjectMappers.checkRequiredProperty(name, "name");
            ObjectMappers.checkRequiredProperty(everIncreasing, "everIncreasing");
            MBeanAttribute mbeanAttribute = new MBeanAttribute();
            mbeanAttribute.setName(name);
            mbeanAttribute.setEverIncreasing(everIncreasing);
            return mbeanAttribute;
        }
    }
}

