/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class GeneralConfig {
    private boolean enabled;
    private int traceStoreThresholdMillis;
    private int profilingIntervalMillis;
    private String defaultTransactionType = "";
    private final String version;

    private GeneralConfig(String version) {
        this.version = version;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getTraceStoreThresholdMillis() {
        return this.traceStoreThresholdMillis;
    }

    public void setTraceStoreThresholdMillis(int traceStoreThresholdMillis) {
        this.traceStoreThresholdMillis = traceStoreThresholdMillis;
    }

    public int getProfilingIntervalMillis() {
        return this.profilingIntervalMillis;
    }

    public void setProfilingIntervalMillis(int profilingIntervalMillis) {
        this.profilingIntervalMillis = profilingIntervalMillis;
    }

    public String getDefaultTransactionType() {
        return this.defaultTransactionType;
    }

    public void setDefaultTransactionType(String defaultTransactionType) {
        this.defaultTransactionType = defaultTransactionType;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof GeneralConfig) {
            GeneralConfig that = (GeneralConfig)obj;
            return Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal((Object)this.traceStoreThresholdMillis, (Object)that.traceStoreThresholdMillis) && Objects.equal((Object)this.profilingIntervalMillis, (Object)that.profilingIntervalMillis) && Objects.equal((Object)this.defaultTransactionType, (Object)that.defaultTransactionType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultTransactionType});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("traceStoreThresholdMillis", this.traceStoreThresholdMillis).add("profilingIntervalMillis", this.profilingIntervalMillis).add("defaultTransactionType", (Object)this.defaultTransactionType).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static GeneralConfig readValue(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="traceStoreThresholdMillis") @Nullable Integer traceStoreThresholdMillis, @JsonProperty(value="profilingIntervalMillis") @Nullable Integer profilingIntervalMillis, @JsonProperty(value="defaultTransactionType") @Nullable String defaultTransactionType, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(enabled, "enabled");
        ObjectMappers.checkRequiredProperty(traceStoreThresholdMillis, "traceStoreThresholdMillis");
        ObjectMappers.checkRequiredProperty(profilingIntervalMillis, "profilingIntervalMillis");
        ObjectMappers.checkRequiredProperty(defaultTransactionType, "defaultTransactionType");
        ObjectMappers.checkRequiredProperty(version, "version");
        GeneralConfig config = new GeneralConfig(version);
        config.setEnabled(enabled);
        config.setTraceStoreThresholdMillis(traceStoreThresholdMillis);
        config.setProfilingIntervalMillis(profilingIntervalMillis);
        config.setDefaultTransactionType(defaultTransactionType);
        return config;
    }
}

