/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class StorageConfig {
    private int aggregateExpirationHours;
    private int traceExpirationHours;
    private int gaugeExpirationHours;
    private int cappedDatabaseSizeMb;
    private final String version;

    private StorageConfig(String version) {
        this.version = version;
    }

    public int getAggregateExpirationHours() {
        return this.aggregateExpirationHours;
    }

    public void setAggregateExpirationHours(int aggregateExpirationHours) {
        this.aggregateExpirationHours = aggregateExpirationHours;
    }

    public int getTraceExpirationHours() {
        return this.traceExpirationHours;
    }

    public void setTraceExpirationHours(int traceExpirationHours) {
        this.traceExpirationHours = traceExpirationHours;
    }

    public int getGaugeExpirationHours() {
        return this.gaugeExpirationHours;
    }

    public void setGaugeExpirationHours(int gaugeExpirationHours) {
        this.gaugeExpirationHours = gaugeExpirationHours;
    }

    public int getCappedDatabaseSizeMb() {
        return this.cappedDatabaseSizeMb;
    }

    public void setCappedDatabaseSizeMb(int cappedDatabaseSizeMb) {
        this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof StorageConfig) {
            StorageConfig that = (StorageConfig)obj;
            return Objects.equal((Object)this.aggregateExpirationHours, (Object)that.aggregateExpirationHours) && Objects.equal((Object)this.traceExpirationHours, (Object)that.traceExpirationHours) && Objects.equal((Object)this.gaugeExpirationHours, (Object)that.gaugeExpirationHours) && Objects.equal((Object)this.cappedDatabaseSizeMb, (Object)that.cappedDatabaseSizeMb);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.aggregateExpirationHours, this.traceExpirationHours, this.gaugeExpirationHours, this.cappedDatabaseSizeMb});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("aggregateExpirationHours", this.aggregateExpirationHours).add("traceExpirationHours", this.traceExpirationHours).add("gaugeExpirationHours", this.gaugeExpirationHours).add("cappedDatabaseSizeMb", this.cappedDatabaseSizeMb).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static StorageConfig readValue(@JsonProperty(value="aggregateExpirationHours") @Nullable Integer aggregateExpirationHours, @JsonProperty(value="traceExpirationHours") @Nullable Integer traceExpirationHours, @JsonProperty(value="gaugeExpirationHours") @Nullable Integer gaugeExpirationHours, @JsonProperty(value="cappedDatabaseSizeMb") @Nullable Integer cappedDatabaseSizeMb, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(aggregateExpirationHours, "aggregateExpirationHours");
        ObjectMappers.checkRequiredProperty(traceExpirationHours, "traceExpirationHours");
        ObjectMappers.checkRequiredProperty(gaugeExpirationHours, "gaugeExpirationHours");
        ObjectMappers.checkRequiredProperty(cappedDatabaseSizeMb, "cappedDatabaseSizeMb");
        ObjectMappers.checkRequiredProperty(version, "version");
        StorageConfig config = new StorageConfig(version);
        config.setAggregateExpirationHours(aggregateExpirationHours);
        config.setTraceExpirationHours(traceExpirationHours);
        config.setGaugeExpirationHours(gaugeExpirationHours);
        config.setCappedDatabaseSizeMb(cappedDatabaseSizeMb);
        return config;
    }
}

