/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class UserRecordingConfig {
    private boolean enabled;
    @Nullable
    private String user;
    private int profileIntervalMillis;
    private final String version;

    private UserRecordingConfig(String version) {
        this.version = version;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public int getProfileIntervalMillis() {
        return this.profileIntervalMillis;
    }

    public void setProfileIntervalMillis(int profileIntervalMillis) {
        this.profileIntervalMillis = profileIntervalMillis;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UserRecordingConfig) {
            UserRecordingConfig that = (UserRecordingConfig)obj;
            return Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.profileIntervalMillis, (Object)that.profileIntervalMillis);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.user, this.profileIntervalMillis});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("user", (Object)this.user).add("profileIntervalMillis", this.profileIntervalMillis).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static UserRecordingConfig readValue(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="user") @Nullable String user, @JsonProperty(value="profileIntervalMillis") @Nullable Integer profileIntervalMillis, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(enabled, "enabled");
        ObjectMappers.checkRequiredProperty(profileIntervalMillis, "profileIntervalMillis");
        ObjectMappers.checkRequiredProperty(version, "version");
        UserRecordingConfig config = new UserRecordingConfig(version);
        config.setEnabled(enabled);
        config.setUser(user);
        config.setProfileIntervalMillis(profileIntervalMillis);
        return config;
    }
}

