/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.glowroot.Agent;
import org.glowroot.common.MessageCount;
import org.glowroot.container.AppUnderTest;
import org.glowroot.container.Container;
import org.glowroot.container.TempDirs;
import org.glowroot.container.admin.AdminService;
import org.glowroot.container.aggregate.AggregateService;
import org.glowroot.container.common.HttpClient;
import org.glowroot.container.config.ConfigService;
import org.glowroot.container.impl.DelegatingJavaagent;
import org.glowroot.container.impl.JavaagentMain;
import org.glowroot.container.impl.SocketCommander;
import org.glowroot.container.trace.TraceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaagentContainer
implements Container,
ConfigService.GetUiPortCommand {
    private static final Logger logger = LoggerFactory.getLogger(JavaagentContainer.class);
    private final File dataDir;
    private final boolean deleteDataDirOnClose;
    private final boolean shared;
    private final ServerSocket serverSocket;
    private final SocketCommander socketCommander;
    private final ExecutorService consolePipeExecutorService;
    private final Process process;
    private final ConsoleOutputPipe consoleOutputPipe;
    private final HttpClient httpClient;
    private final ConfigService configService;
    private final TraceService traceService;
    private final AggregateService aggregateService;
    private final AdminService adminService;
    private final Thread shutdownHook;

    public static JavaagentContainer create() throws Exception {
        return new JavaagentContainer(null, false, 0, false, false, false, (List<String>)ImmutableList.of());
    }

    public static JavaagentContainer createWithFileDb(File dataDir) throws Exception {
        return new JavaagentContainer(dataDir, true, 0, false, false, false, (List<String>)ImmutableList.of());
    }

    public static JavaagentContainer createWithExtraJvmArgs(List<String> extraJvmArgs) throws Exception {
        return new JavaagentContainer(null, false, 0, false, false, false, extraJvmArgs);
    }

    public JavaagentContainer(@Nullable File dataDir, boolean useFileDb, int port, boolean shared, boolean captureConsoleOutput, boolean viewerMode, List<String> extraJvmArgs) throws Exception {
        int uiPort;
        if (dataDir == null) {
            this.dataDir = TempDirs.createTempDir("glowroot-test-datadir");
            this.deleteDataDirOnClose = true;
        } else {
            this.dataDir = dataDir;
            this.deleteDataDirOnClose = false;
        }
        this.shared = shared;
        this.serverSocket = new ServerSocket(0);
        File configFile = new File(this.dataDir, "config.json");
        if (!configFile.exists()) {
            Files.write((CharSequence)("{\"ui\":{\"port\":" + port + "}}"), (File)configFile, (Charset)Charsets.UTF_8);
        }
        List<String> command = JavaagentContainer.buildCommand(this.serverSocket.getLocalPort(), this.dataDir, useFileDb, viewerMode, extraJvmArgs);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        this.consolePipeExecutorService = Executors.newSingleThreadExecutor();
        InputStream in = process.getInputStream();
        Preconditions.checkNotNull((Object)in);
        this.consoleOutputPipe = new ConsoleOutputPipe(in, System.out, captureConsoleOutput);
        this.consolePipeExecutorService.submit(this.consoleOutputPipe);
        this.process = process;
        Socket socket = this.serverSocket.accept();
        ObjectOutputStream objectOut = new ObjectOutputStream(socket.getOutputStream());
        ObjectInputStream objectIn = new ObjectInputStream(socket.getInputStream());
        final SocketCommander socketCommander = new SocketCommander(objectOut, objectIn);
        try {
            uiPort = JavaagentContainer.getUiPort(socketCommander);
        }
        catch (Container.StartupFailedException e) {
            socketCommander.sendCommand("SHUTDOWN", new Object[0]);
            socketCommander.close();
            process.waitFor();
            this.serverSocket.close();
            this.consolePipeExecutorService.shutdownNow();
            throw e;
        }
        this.httpClient = new HttpClient(uiPort);
        this.configService = new ConfigService(this.httpClient, new ConfigService.GetUiPortCommand(){

            @Override
            public int getUiPort() throws Exception {
                return JavaagentContainer.getUiPort(socketCommander);
            }
        });
        this.traceService = new TraceService(this.httpClient);
        this.aggregateService = new AggregateService(this.httpClient);
        this.adminService = new AdminService(this.httpClient);
        this.shutdownHook = new ShutdownHookThread(socketCommander);
        this.socketCommander = socketCommander;
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Override
    public ConfigService getConfigService() {
        return this.configService;
    }

    @Override
    public void addExpectedLogMessage(String loggerName, String partialMessage) throws Exception {
        this.socketCommander.sendCommand("ADD_EXPECTED_LOG_MESSAGE", loggerName, partialMessage);
    }

    @Override
    public void executeAppUnderTest(Class<? extends AppUnderTest> appUnderTestClass) throws Exception {
        this.socketCommander.sendCommand("EXECUTE_APP", appUnderTestClass.getName());
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (this.adminService.getNumPendingCompleteTransactions() > 0 && stopwatch.elapsed(TimeUnit.SECONDS) < 5L) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void interruptAppUnderTest() throws Exception {
        this.socketCommander.sendCommand("INTERRUPT", new Object[0]);
    }

    @Override
    public TraceService getTraceService() {
        return this.traceService;
    }

    @Override
    public AggregateService getAggregateService() {
        return this.aggregateService;
    }

    @Override
    public AdminService getAdminService() {
        return this.adminService;
    }

    @Override
    public int getUiPort() throws Exception {
        return JavaagentContainer.getUiPort(this.socketCommander);
    }

    @Override
    public void checkAndReset() throws Exception {
        this.traceService.assertNoActiveTransactions();
        this.adminService.deleteAllData();
        this.checkAndResetConfigOnly();
    }

    @Override
    public void checkAndResetConfigOnly() throws Exception {
        this.configService.resetAllConfig();
        this.configService.setTraceStoreThresholdMillis(0);
        MessageCount logMessageCount = (MessageCount)this.socketCommander.sendCommand("CLEAR_LOG_MESSAGES", new Object[0]);
        if (logMessageCount == null) {
            throw new AssertionError((Object)"Command returned null: CLEAR_LOG_MESSAGES");
        }
        if (logMessageCount.expectedCount() > 0) {
            throw new AssertionError((Object)"One or more expected messages were not logged");
        }
        if (logMessageCount.unexpectedCount() > 0) {
            throw new AssertionError((Object)"One or more unexpected messages were logged");
        }
    }

    @Override
    public void close() throws Exception {
        this.close(false);
    }

    @Override
    public void close(boolean evenIfShared) throws Exception {
        if (this.shared && !evenIfShared) {
            return;
        }
        this.socketCommander.sendCommand("SHUTDOWN", new Object[0]);
        this.cleanup();
    }

    public void kill() throws Exception {
        this.socketCommander.sendKillCommand();
        this.cleanup();
    }

    public List<String> getUnexpectedConsoleLines() {
        ArrayList unexpectedLines = Lists.newArrayList();
        Splitter splitter = Splitter.on((Pattern)Pattern.compile("\r?\n")).omitEmptyStrings();
        String capturedOutput = this.consoleOutputPipe.getCapturedOutput();
        if (capturedOutput == null) {
            throw new IllegalStateException("Cannot check console lines unless JavaagentContainer was created with captureConsoleOutput=true");
        }
        for (String line : splitter.split((CharSequence)capturedOutput)) {
            if (line.contains("Glowroot started") || line.contains("Glowroot listening") || line.contains("Glowroot plugins loaded")) continue;
            unexpectedLines.add(line);
        }
        return unexpectedLines;
    }

    public void cleanup() throws Exception {
        this.socketCommander.close();
        this.process.waitFor();
        this.serverSocket.close();
        this.consolePipeExecutorService.shutdownNow();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.httpClient.close();
        if (this.deleteDataDirOnClose) {
            TempDirs.deleteRecursively(this.dataDir);
        }
    }

    static List<String> buildCommand(int containerPort, File dataDir, boolean useFileDb, boolean viewerMode, List<String> extraJvmArgs) throws Exception {
        String sourceOfRandomness;
        ArrayList command = Lists.newArrayList();
        String javaExecutable = StandardSystemProperty.JAVA_HOME.value() + File.separator + "bin" + File.separator + "java";
        command.add(javaExecutable);
        command.addAll(extraJvmArgs);
        command.addAll(JavaagentContainer.getJacocoArgsFromCurrentJvm());
        String classpath = Strings.nullToEmpty((String)StandardSystemProperty.JAVA_CLASS_PATH.value());
        if (viewerMode) {
            command.add("-classpath");
            command.add(classpath);
            command.add("-Dglowroot.testHarness.viewerMode=true");
        } else {
            ArrayList paths = Lists.newArrayList();
            File javaagentJarFile = null;
            for (String path : Splitter.on((char)File.pathSeparatorChar).split((CharSequence)classpath)) {
                File file = new File(path);
                if (file.getName().matches("glowroot-test-harness-[0-9.]+(-SNAPSHOT)?.jar")) {
                    javaagentJarFile = file;
                    continue;
                }
                if (file.getName().matches("glowroot-core-[0-9.]+(-SNAPSHOT)?.jar")) continue;
                paths.add(path);
            }
            command.add("-Xbootclasspath/a:" + Joiner.on((char)File.pathSeparatorChar).join((Iterable)paths));
            if (javaagentJarFile == null) {
                javaagentJarFile = DelegatingJavaagent.createDelegatingJavaagentJarFile(dataDir);
                command.add("-javaagent:" + javaagentJarFile);
                command.add("-DdelegateJavaagent=" + Agent.class.getName());
            } else {
                command.add("-javaagent:" + javaagentJarFile);
            }
        }
        command.add("-Dglowroot.data.dir=" + dataDir.getAbsolutePath());
        command.add("-Dglowroot.internal.logging.spy=true");
        if (!useFileDb) {
            command.add("-Dglowroot.internal.h2.memdb=true");
        }
        if ((sourceOfRandomness = System.getProperty("java.security.egd")) != null) {
            command.add("-Djava.security.egd=" + sourceOfRandomness);
        }
        command.add("-Xmx" + Runtime.getRuntime().maxMemory());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key;
            Object keyObject = entry.getKey();
            if (!(keyObject instanceof String) || !(key = (String)keyObject).startsWith("glowroot.internal.")) continue;
            command.add("-D" + key + "=" + entry.getValue());
        }
        command.add(JavaagentMain.class.getName());
        command.add(Integer.toString(containerPort));
        return command;
    }

    private static List<String> getJacocoArgsFromCurrentJvm() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMXBean.getInputArguments();
        ArrayList jacocoArgs = Lists.newArrayList();
        for (String argument : arguments) {
            if (!argument.startsWith("-javaagent:") || !argument.contains("jacoco")) continue;
            jacocoArgs.add(argument + ",inclbootstrapclasses=true,includes=org.glowroot.*");
            break;
        }
        return jacocoArgs;
    }

    private static int getUiPort(SocketCommander socketCommander) throws Exception {
        Object response = socketCommander.sendCommand("GET_PORT", new Object[0]);
        if (response == null) {
            throw new AssertionError((Object)"Command returned null: GET_PORT");
        }
        if (response.equals("STARTUP_FAILED")) {
            throw new Container.StartupFailedException();
        }
        return (Integer)response;
    }

    private static class ConsoleOutputPipe
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        @Nullable
        private final StringBuffer capturedOutput;

        private ConsoleOutputPipe(InputStream in, OutputStream out, boolean captureOutput) {
            this.in = in;
            this.out = out;
            this.capturedOutput = captureOutput ? new StringBuffer() : null;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[100];
            try {
                int n;
                while ((n = this.in.read(buffer)) != -1) {
                    if (this.capturedOutput != null) {
                        this.capturedOutput.append(new String(buffer, 0, n));
                    }
                    this.out.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        @Nullable
        private String getCapturedOutput() {
            return this.capturedOutput == null ? null : this.capturedOutput.toString();
        }
    }

    private static class ShutdownHookThread
    extends Thread {
        private final SocketCommander socketCommander;

        private ShutdownHookThread(SocketCommander socketCommander) {
            this.socketCommander = socketCommander;
        }

        @Override
        public void run() {
            try {
                this.socketCommander.sendKillCommand();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

