/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketCommander {
    private static final Logger logger = LoggerFactory.getLogger(SocketCommander.class);
    private final ExecutorService executorService;
    private final ConcurrentMap<Integer, ResponseHolder> responseHolders = Maps.newConcurrentMap();
    private final AtomicInteger commandCounter = new AtomicInteger();
    private final Object lock = new Object();
    private volatile ObjectOutputStream objectOut;
    private volatile boolean closing;

    SocketCommander(ObjectOutputStream objectOut, ObjectInputStream objectIn) throws Exception {
        this.objectOut = objectOut;
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.execute(new SocketIn(objectIn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object sendCommand(String commandName, Object ... args) throws Exception {
        Object response;
        int commandNum = this.commandCounter.getAndIncrement();
        ResponseHolder responseHolder = new ResponseHolder();
        this.responseHolders.put(commandNum, responseHolder);
        CommandWrapper commandWrapper = new CommandWrapper(commandName, Arrays.asList(args), commandNum);
        ResponseHolder responseHolder2 = responseHolder;
        synchronized (responseHolder2) {
            logger.debug("sendCommand(): sending command to external jvm: {}", (Object)commandWrapper);
            Object object = this.lock;
            synchronized (object) {
                this.objectOut.writeObject(commandWrapper);
            }
            logger.debug("sendCommand(): command sent");
            logger.debug("sendCommand(): waiting for response from external jvm");
            while (!responseHolder.hasResponse) {
                responseHolder.wait();
            }
            response = responseHolder.response;
        }
        logger.debug("sendCommand(): response received: {}", response);
        if ("EXCEPTION".equals(response)) {
            throw new IllegalStateException("Exception occurred inside external JVM");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendKillCommand() throws Exception {
        CommandWrapper commandWrapper = new CommandWrapper("KILL", (List)ImmutableList.of(), this.commandCounter.getAndIncrement());
        Object object = this.lock;
        synchronized (object) {
            this.objectOut.writeObject(commandWrapper);
        }
    }

    void close() throws Exception {
        this.closing = true;
        this.executorService.shutdownNow();
    }

    private class SocketIn
    implements Runnable {
        private final ObjectInputStream objectIn;

        public SocketIn(ObjectInputStream objectIn) {
            this.objectIn = objectIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    ResponseHolder responseHolder;
                    ResponseWrapper responseWrapper;
                    while (true) {
                        Object value;
                        if ((value = this.objectIn.readObject()).equals("PING")) {
                            continue;
                        }
                        responseWrapper = (ResponseWrapper)value;
                        logger.debug("response received from external jvm: {}", (Object)responseWrapper);
                        responseHolder = (ResponseHolder)SocketCommander.this.responseHolders.get(responseWrapper.getCommandNum());
                        if (responseHolder != null) break;
                        logger.error("respond received for unknown command number: " + responseWrapper.getCommandNum());
                    }
                    ResponseHolder responseHolder2 = responseHolder;
                    synchronized (responseHolder2) {
                        responseHolder.hasResponse = true;
                        responseHolder.response = responseWrapper.getResponse();
                        responseHolder.notifyAll();
                    }
                }
                catch (IOException e) {
                    if (SocketCommander.this.closing) break;
                    logger.error(e.getMessage(), (Throwable)e);
                    break;
                }
                catch (ClassNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    break;
                }
            }
        }
    }

    private static class ResponseHolder {
        private boolean hasResponse;
        @Nullable
        private Object response;

        private ResponseHolder() {
        }
    }

    static class ResponseWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int commandNum;
        @Nullable
        private final Object response;

        ResponseWrapper(int commandNum, @Nullable Object response) {
            this.commandNum = commandNum;
            this.response = response;
        }

        private int getCommandNum() {
            return this.commandNum;
        }

        @Nullable
        private Object getResponse() {
            return this.response;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("commandNum", this.commandNum).add("response", this.response).toString();
        }
    }

    static class CommandWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String commandName;
        private final ImmutableList<Object> args;
        private final int commandNum;

        private CommandWrapper(String commandName, List<Object> args, int commandNum) {
            this.commandNum = commandNum;
            this.commandName = commandName;
            this.args = ImmutableList.copyOf(args);
        }

        int getCommandNum() {
            return this.commandNum;
        }

        String getCommandName() {
            return this.commandName;
        }

        ImmutableList<Object> getArgs() {
            return this.args;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("commandNum", this.commandNum).add("commandName", (Object)this.commandName).add("args", this.args).toString();
        }
    }
}

