/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.trace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class Timer {
    private static final Ordering<Timer> orderingByTotal = new Ordering<Timer>(){

        public int compare(@Nullable Timer left, @Nullable Timer right) {
            Preconditions.checkNotNull((Object)left);
            Preconditions.checkNotNull((Object)right);
            return Longs.compare((long)left.total, (long)right.total);
        }
    };
    private final String name;
    private final boolean extended;
    private final long total;
    private final long count;
    private final boolean active;
    private final ImmutableList<Timer> nestedTimers;

    private Timer(String name, boolean extended, long total, long count, boolean active, List<Timer> nestedTimers) {
        this.name = name;
        this.extended = extended;
        this.total = total;
        this.count = count;
        this.active = active;
        this.nestedTimers = ImmutableList.copyOf(nestedTimers);
    }

    public String getName() {
        return this.name;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public long getTotal() {
        return this.total;
    }

    public long getCount() {
        return this.count;
    }

    public boolean isActive() {
        return this.active;
    }

    public ImmutableList<Timer> getNestedTimers() {
        return ImmutableList.copyOf((Collection)orderingByTotal.reverse().sortedCopy(this.nestedTimers));
    }

    @JsonIgnore
    public List<String> getNestedTimerNames() {
        ArrayList stableNestedTimers = Lists.newArrayList();
        for (Timer stableNestedTimer : this.getNestedTimers()) {
            stableNestedTimers.add(stableNestedTimer.getName());
        }
        return stableNestedTimers;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("extended", this.extended).add("total", this.total).add("count", this.count).add("active", this.active).add("nestedTimers", this.nestedTimers).toString();
    }

    @JsonCreator
    static Timer readValue(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="extended") @Nullable Boolean extended, @JsonProperty(value="total") @Nullable Long total, @JsonProperty(value="count") @Nullable Long count, @JsonProperty(value="active") @Nullable Boolean active, @JsonProperty(value="nestedTimers") @Nullable List<Timer> uncheckedNestedTimers) throws JsonMappingException {
        List<Timer> nestedTimers = ObjectMappers.orEmpty(uncheckedNestedTimers, "nestedTimers");
        ObjectMappers.checkRequiredProperty(name, "name");
        ObjectMappers.checkRequiredProperty(total, "total");
        ObjectMappers.checkRequiredProperty(count, "count");
        return new Timer(name, Timer.orFalse(extended), total, count, Timer.orFalse(active), nestedTimers);
    }

    private static boolean orFalse(@Nullable Boolean value) {
        return value != null && value != false;
    }
}

