/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.trace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;
import org.glowroot.container.trace.ErrorMessage;
import org.glowroot.container.trace.Message;

public class TraceEntry {
    private final long offset;
    private final long duration;
    private final boolean active;
    private final int nestingLevel;
    @Nullable
    private final Message message;
    @Nullable
    private final ErrorMessage error;
    @Nullable
    private final ImmutableList<String> stackTrace;
    private final boolean limitExceededMarker;
    private final boolean limitExtendedMarker;

    private TraceEntry(long offset, long duration, boolean active, int nestingLevel, @Nullable Message message, @Nullable ErrorMessage error, @Nullable List<String> stackTrace, boolean limitExceededMarker, boolean limitExtendedMarker) {
        this.offset = offset;
        this.duration = duration;
        this.active = active;
        this.nestingLevel = nestingLevel;
        this.message = message;
        this.error = error;
        this.stackTrace = stackTrace == null ? null : ImmutableList.copyOf(stackTrace);
        this.limitExceededMarker = limitExceededMarker;
        this.limitExtendedMarker = limitExtendedMarker;
    }

    public long getOffset() {
        if (this.limitExceededMarker) {
            throw new IllegalStateException("Limit exceeded marker has no offset, check isLimitExceededMarker() first");
        }
        if (this.limitExtendedMarker) {
            throw new IllegalStateException("Limit extended marker has no offset, check isLimitExtendedMarker() first");
        }
        return this.offset;
    }

    public long getDuration() {
        if (this.limitExceededMarker) {
            throw new IllegalStateException("Limit exceeded marker has no duration, check isLimitExceededMarker() first");
        }
        if (this.limitExtendedMarker) {
            throw new IllegalStateException("Limit extended marker has no duration, check isLimitExtendedMarker() first");
        }
        return this.duration;
    }

    public boolean isActive() {
        if (this.limitExceededMarker) {
            throw new IllegalStateException("Limit exceeded marker is neither active nor inactive, check isLimitExceededMarker() first");
        }
        if (this.limitExtendedMarker) {
            throw new IllegalStateException("Limit extended marker is neither active nor inactive, check isLimitExtendedMarker() first");
        }
        return this.active;
    }

    public int getNestingLevel() {
        if (this.limitExceededMarker) {
            throw new IllegalStateException("Limit exceeded marker has no nesting level, check isLimitExceededMarker() first");
        }
        if (this.limitExtendedMarker) {
            throw new IllegalStateException("Limit extended marker has no nesting level, check isLimitExtendedMarker() first");
        }
        return this.nestingLevel;
    }

    @Nullable
    public Message getMessage() {
        return this.message;
    }

    @Nullable
    public ErrorMessage getError() {
        return this.error;
    }

    @Nullable
    public ImmutableList<String> getStackTrace() {
        return this.stackTrace;
    }

    public boolean isLimitExceededMarker() {
        return this.limitExceededMarker;
    }

    public boolean isLimitExtendedMarker() {
        return this.limitExtendedMarker;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this.offset).add("duration", this.duration).add("active", this.active).add("nestingLevel", this.nestingLevel).add("message", (Object)this.message).add("error", (Object)this.error).add("stackTrace", this.stackTrace).add("limitExceededMarker", this.limitExceededMarker).add("limitExtendedMarker", this.limitExtendedMarker).toString();
    }

    @JsonCreator
    static TraceEntry readValue(@JsonProperty(value="offset") @Nullable Long offset, @JsonProperty(value="duration") @Nullable Long duration, @JsonProperty(value="active") @Nullable Boolean active, @JsonProperty(value="nestingLevel") @Nullable Integer nestingLevel, @JsonProperty(value="message") @Nullable Message message, @JsonProperty(value="error") @Nullable ErrorMessage error, @JsonProperty(value="stackTrace") @Nullable List<String> uncheckedStackTrace, @JsonProperty(value="limitExceededMarker") @Nullable Boolean limitExceededMarker, @JsonProperty(value="limitExtendedMarker") @Nullable Boolean limitExtendedMarker) throws JsonMappingException {
        List<String> stackTrace = ObjectMappers.checkNotNullItems(uncheckedStackTrace, "stackTrace");
        return new TraceEntry(TraceEntry.nullToZero(offset), TraceEntry.nullToZero(duration), ObjectMappers.nullToFalse(active), TraceEntry.nullToZero(nestingLevel), message, error, stackTrace, ObjectMappers.nullToFalse(limitExceededMarker), ObjectMappers.nullToFalse(limitExtendedMarker));
    }

    private static long nullToZero(@Nullable Long value) {
        return value == null ? 0L : value;
    }

    private static int nullToZero(@Nullable Integer value) {
        return value == null ? 0 : value;
    }
}

