/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.api.PluginServices;
import org.glowroot.config.ConfigService;
import org.glowroot.config.GaugeConfig;
import org.glowroot.config.MBeanAttribute;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.Index;
import org.glowroot.shaded.google.common.cache.Cache;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class GaugeDao {
    private static final Logger logger = LoggerFactory.getLogger(GaugeDao.class);
    private static final ImmutableList<Column> gaugeColumns = ImmutableList.of(Column.of("id", -5).withIdentity(true), Column.of("name", 12), Column.of("ever_increasing", 16));
    private static final ImmutableList<Index> gaugeIndexes = ImmutableList.of(Index.of("gauge_idx", ImmutableList.of("name")));
    private final Cache<String, Long> gaugeIds = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private final DataSource dataSource;

    static GaugeDao create(final ConfigService configService, DataSource dataSource) throws SQLException {
        final GaugeDao gaugeDao = new GaugeDao(dataSource);
        configService.addConfigListener(new PluginServices.ConfigListener(){

            @Override
            public void onChange() {
                try {
                    gaugeDao.updateGauges(configService.getGaugeConfigs());
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        });
        return gaugeDao;
    }

    private GaugeDao(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        dataSource.syncTable("gauge", gaugeColumns);
        dataSource.syncIndexes("gauge", gaugeIndexes);
    }

    @Nullable
    Long getGaugeId(String gaugeName) throws SQLException {
        Long gaugeId = this.gaugeIds.getIfPresent(gaugeName);
        if (gaugeId != null) {
            return gaugeId;
        }
        gaugeId = this.dataSource.query("select id from gauge where name = ?", new LongExtractor(), gaugeName);
        if (gaugeId != null) {
            this.gaugeIds.put(gaugeName, gaugeId);
        }
        return gaugeId;
    }

    private synchronized void updateGauges(List<GaugeConfig> gaugeConfigs) throws SQLException {
        for (GaugeConfig gaugeConfig : gaugeConfigs) {
            for (MBeanAttribute mbeanAttribute : gaugeConfig.mbeanAttributes()) {
                String gaugeName = gaugeConfig.mbeanObjectName() + ',' + mbeanAttribute.name();
                Boolean everIncreasing = this.dataSource.query("select ever_increasing from gauge where name = ?", new BooleanExtractor(), gaugeName);
                if (everIncreasing == null) {
                    this.dataSource.update("insert into gauge (name, ever_increasing) values (?, ?)", gaugeName, mbeanAttribute.everIncreasing());
                    continue;
                }
                if (everIncreasing.booleanValue() == mbeanAttribute.everIncreasing()) continue;
                this.dataSource.update("update gauge set ever_increasing = ? where name = ?", mbeanAttribute.everIncreasing(), gaugeName);
            }
        }
    }

    private static class BooleanExtractor
    implements DataSource.ResultSetExtractor<Boolean> {
        private BooleanExtractor() {
        }

        @Override
        @Nullable
        public Boolean extractData(ResultSet resultSet) throws Exception {
            if (resultSet.next()) {
                return resultSet.getBoolean(1);
            }
            return null;
        }
    }

    private static class LongExtractor
    implements DataSource.ResultSetExtractor<Long> {
        private LongExtractor() {
        }

        @Override
        @Nullable
        public Long extractData(ResultSet resultSet) throws Exception {
            if (resultSet.next()) {
                return resultSet.getLong(1);
            }
            return null;
        }
    }
}

