/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.glowroot.common.Clock;
import org.glowroot.common.ScheduledRunnable;
import org.glowroot.config.ConfigService;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.GaugePointDao;
import org.glowroot.local.store.TraceDao;

class ReaperRunnable
extends ScheduledRunnable {
    private final ConfigService configService;
    private final AggregateDao aggregateDao;
    private final TraceDao traceDao;
    private final GaugePointDao gaugePointDao;
    private final Clock clock;

    ReaperRunnable(ConfigService configService, AggregateDao aggregateDao, TraceDao traceDao, GaugePointDao gaugePointDao, Clock clock) {
        this.configService = configService;
        this.aggregateDao = aggregateDao;
        this.traceDao = traceDao;
        this.gaugePointDao = gaugePointDao;
        this.clock = clock;
    }

    @Override
    protected void runInternal() throws SQLException {
        long aggregateCaptureTime = this.clock.currentTimeMillis() - TimeUnit.HOURS.toMillis(this.configService.getStorageConfig().aggregateExpirationHours());
        this.aggregateDao.deleteBefore(aggregateCaptureTime);
        long traceCaptureTime = this.clock.currentTimeMillis() - TimeUnit.HOURS.toMillis(this.configService.getStorageConfig().traceExpirationHours());
        this.traceDao.deleteBefore(traceCaptureTime);
        long gaugeCaptureTime = this.clock.currentTimeMillis() - TimeUnit.HOURS.toMillis(this.configService.getStorageConfig().gaugeExpirationHours());
        this.gaugePointDao.deleteBefore(gaugeCaptureTime);
    }
}

