/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.TracePointBase;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class TracePoint
extends TracePointBase {
    private final String id;
    private final long captureTime;
    private final double duration;
    private final boolean error;

    private TracePoint(Builder builder) {
        this.id = builder.id;
        this.captureTime = builder.captureTime;
        this.duration = builder.duration;
        this.error = builder.error;
    }

    private TracePoint(TracePoint original, String id, long captureTime, double duration, boolean error) {
        this.id = id;
        this.captureTime = captureTime;
        this.duration = duration;
        this.error = error;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    public double duration() {
        return this.duration;
    }

    @Override
    public boolean error() {
        return this.error;
    }

    public final TracePoint withId(String value) {
        if (this.id == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TracePoint(this, newValue, this.captureTime, this.duration, this.error);
    }

    public final TracePoint withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new TracePoint(this, this.id, newValue, this.duration, this.error);
    }

    public final TracePoint withDuration(double value) {
        double newValue = value;
        return new TracePoint(this, this.id, this.captureTime, newValue, this.error);
    }

    public final TracePoint withError(boolean value) {
        if (this.error == value) {
            return this;
        }
        boolean newValue = value;
        return new TracePoint(this, this.id, this.captureTime, this.duration, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TracePoint && this.equalTo((TracePoint)another);
    }

    private boolean equalTo(TracePoint another) {
        return this.id.equals(another.id) && this.captureTime == another.captureTime && Double.doubleToLongBits(this.duration) == Double.doubleToLongBits(another.duration) && this.error == another.error;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + Doubles.hashCode(this.duration);
        h = h * 17 + Booleans.hashCode(this.error);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TracePoint").add("id", this.id).add("captureTime", this.captureTime).add("duration", this.duration).add("error", this.error).toString();
    }

    public static TracePoint copyOf(TracePointBase instance) {
        if (instance instanceof TracePoint) {
            return (TracePoint)instance;
        }
        return TracePoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_ID = 1L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 2L;
        private static final long INITIALIZED_BIT_DURATION = 4L;
        private static final long INITIALIZED_BIT_ERROR = 8L;
        private long initializedBitset;
        @Nullable
        private String id;
        private long captureTime;
        private double duration;
        private boolean error;

        private Builder() {
        }

        public final Builder from(TracePointBase instance) {
            Preconditions.checkNotNull(instance);
            this.id(instance.id());
            this.captureTime(instance.captureTime());
            this.duration(instance.duration());
            this.error(instance.error());
            return this;
        }

        public final Builder id(String id) {
            this.id = Preconditions.checkNotNull(id);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder duration(double duration) {
            this.duration = duration;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder error(boolean error) {
            this.error = error;
            this.initializedBitset |= 8L;
            return this;
        }

        public TracePoint build() {
            this.checkRequiredAttributes();
            return new TracePoint(this);
        }

        private boolean idIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean durationIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean errorIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.durationIsSet()) {
                attributes.add("duration");
            }
            if (!this.errorIsSet()) {
                attributes.add("error");
            }
            return "Cannot build TracePoint, some of required attributes are not set " + attributes;
        }
    }
}

