/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class TransactionSummaryQuery
extends AggregateDao.TransactionSummaryQueryBase {
    private final String transactionType;
    private final long from;
    private final long to;
    private final AggregateDao.TransactionSummarySortOrder sortOrder;
    private final int limit;

    private TransactionSummaryQuery(Builder builder) {
        this.transactionType = builder.transactionType;
        this.from = builder.from;
        this.to = builder.to;
        this.sortOrder = builder.sortOrder;
        this.limit = builder.limit;
    }

    private TransactionSummaryQuery(TransactionSummaryQuery original, String transactionType, long from, long to, AggregateDao.TransactionSummarySortOrder sortOrder, int limit) {
        this.transactionType = transactionType;
        this.from = from;
        this.to = to;
        this.sortOrder = sortOrder;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="sortOrder")
    public AggregateDao.TransactionSummarySortOrder sortOrder() {
        return this.sortOrder;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final TransactionSummaryQuery withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TransactionSummaryQuery(this, newValue, this.from, this.to, this.sortOrder, this.limit);
    }

    public final TransactionSummaryQuery withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new TransactionSummaryQuery(this, this.transactionType, newValue, this.to, this.sortOrder, this.limit);
    }

    public final TransactionSummaryQuery withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new TransactionSummaryQuery(this, this.transactionType, this.from, newValue, this.sortOrder, this.limit);
    }

    public final TransactionSummaryQuery withSortOrder(AggregateDao.TransactionSummarySortOrder value) {
        if (this.sortOrder == value) {
            return this;
        }
        AggregateDao.TransactionSummarySortOrder newValue = Preconditions.checkNotNull(value);
        return new TransactionSummaryQuery(this, this.transactionType, this.from, this.to, newValue, this.limit);
    }

    public final TransactionSummaryQuery withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new TransactionSummaryQuery(this, this.transactionType, this.from, this.to, this.sortOrder, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TransactionSummaryQuery && this.equalTo((TransactionSummaryQuery)another);
    }

    private boolean equalTo(TransactionSummaryQuery another) {
        return this.transactionType.equals(another.transactionType) && this.from == another.from && this.to == another.to && this.sortOrder.equals((Object)another.sortOrder) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.sortOrder.hashCode();
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionSummaryQuery").add("transactionType", this.transactionType).add("from", this.from).add("to", this.to).add("sortOrder", (Object)this.sortOrder).add("limit", this.limit).toString();
    }

    @JsonCreator
    public static TransactionSummaryQuery fromAllAttributes(@JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="sortOrder") @Nullable AggregateDao.TransactionSummarySortOrder sortOrder, @JsonProperty(value="limit") @Nullable Integer limit) {
        Builder builder = TransactionSummaryQuery.builder();
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (sortOrder != null) {
            builder.sortOrder(sortOrder);
        }
        if (limit != null) {
            builder.limit(limit);
        }
        return builder.build();
    }

    public static TransactionSummaryQuery copyOf(AggregateDao.TransactionSummaryQueryBase instance) {
        if (instance instanceof TransactionSummaryQuery) {
            return (TransactionSummaryQuery)instance;
        }
        return TransactionSummaryQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 31L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 1L;
        private static final long INITIALIZED_BIT_FROM = 2L;
        private static final long INITIALIZED_BIT_TO = 4L;
        private static final long INITIALIZED_BIT_SORT_ORDER = 8L;
        private static final long INITIALIZED_BIT_LIMIT = 16L;
        private long initializedBitset;
        @Nullable
        private String transactionType;
        private long from;
        private long to;
        @Nullable
        private AggregateDao.TransactionSummarySortOrder sortOrder;
        private int limit;

        private Builder() {
        }

        public final Builder from(AggregateDao.TransactionSummaryQueryBase instance) {
            Preconditions.checkNotNull(instance);
            this.transactionType(instance.transactionType());
            this.from(instance.from());
            this.to(instance.to());
            this.sortOrder(instance.sortOrder());
            this.limit(instance.limit());
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder sortOrder(AggregateDao.TransactionSummarySortOrder sortOrder) {
            this.sortOrder = Preconditions.checkNotNull(sortOrder);
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public TransactionSummaryQuery build() {
            this.checkRequiredAttributes();
            return new TransactionSummaryQuery(this);
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean sortOrderIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 31L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.sortOrderIsSet()) {
                attributes.add("sortOrder");
            }
            if (!this.limitIsSet()) {
                attributes.add("limit");
            }
            return "Cannot build TransactionSummaryQuery, some of required attributes are not set " + attributes;
        }
    }
}

