/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.SQLException;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.Index;
import org.glowroot.shaded.google.common.collect.ImmutableList;

class TriggeredAlertDao {
    private static final ImmutableList<Column> triggeredAlertColumns = ImmutableList.of(Column.of("alert_config_version", 12), Column.of("end_time", -5));
    private static final ImmutableList<Index> triggeredAlertIndexes = ImmutableList.of(Index.of("triggered_alert_idx", ImmutableList.of("alert_config_version")));
    private final DataSource dataSource;

    TriggeredAlertDao(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        dataSource.syncTable("triggered_alert", triggeredAlertColumns);
        dataSource.syncIndexes("triggered_alert", triggeredAlertIndexes);
    }

    void insert(String version, long endTime) throws SQLException {
        this.dataSource.update("insert into triggered_alert (alert_config_version, end_time) values (?, ?)", version, endTime);
    }

    boolean exists(String version) throws SQLException {
        return this.dataSource.queryForExists("select 1 from triggered_alert where alert_config_version = ?", version);
    }

    void delete(String version) throws SQLException {
        this.dataSource.update("delete from triggered_alert where alert_config_version = ?", version);
    }
}

