/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.AdvancedConfigDto;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class AdvancedConfigResponse
extends ConfigJsonService.AdvancedConfigResponseBase {
    private final AdvancedConfigDto config;
    private final boolean timerWrapperMethodsActive;

    private AdvancedConfigResponse(Builder builder) {
        this.config = builder.config;
        this.timerWrapperMethodsActive = builder.timerWrapperMethodsActive;
    }

    private AdvancedConfigResponse(AdvancedConfigResponse original, AdvancedConfigDto config, boolean timerWrapperMethodsActive) {
        this.config = config;
        this.timerWrapperMethodsActive = timerWrapperMethodsActive;
    }

    @Override
    @JsonProperty(value="config")
    public AdvancedConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="timerWrapperMethodsActive")
    public boolean timerWrapperMethodsActive() {
        return this.timerWrapperMethodsActive;
    }

    public final AdvancedConfigResponse withConfig(AdvancedConfigDto value) {
        if (this.config == value) {
            return this;
        }
        AdvancedConfigDto newValue = Preconditions.checkNotNull(value);
        return new AdvancedConfigResponse(this, newValue, this.timerWrapperMethodsActive);
    }

    public final AdvancedConfigResponse withTimerWrapperMethodsActive(boolean value) {
        if (this.timerWrapperMethodsActive == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfigResponse(this, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AdvancedConfigResponse && this.equalTo((AdvancedConfigResponse)another);
    }

    private boolean equalTo(AdvancedConfigResponse another) {
        return this.config.equals(another.config) && this.timerWrapperMethodsActive == another.timerWrapperMethodsActive;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.config.hashCode();
        h = h * 17 + Booleans.hashCode(this.timerWrapperMethodsActive);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AdvancedConfigResponse").add("config", this.config).add("timerWrapperMethodsActive", this.timerWrapperMethodsActive).toString();
    }

    @JsonCreator
    public static AdvancedConfigResponse fromAllAttributes(@JsonProperty(value="config") @Nullable AdvancedConfigDto config, @JsonProperty(value="timerWrapperMethodsActive") @Nullable Boolean timerWrapperMethodsActive) {
        Builder builder = AdvancedConfigResponse.builder();
        if (config != null) {
            builder.config(config);
        }
        if (timerWrapperMethodsActive != null) {
            builder.timerWrapperMethodsActive(timerWrapperMethodsActive);
        }
        return builder.build();
    }

    static AdvancedConfigResponse copyOf(ConfigJsonService.AdvancedConfigResponseBase instance) {
        if (instance instanceof AdvancedConfigResponse) {
            return (AdvancedConfigResponse)instance;
        }
        return AdvancedConfigResponse.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_CONFIG = 1L;
        private static final long INITIALIZED_BIT_TIMER_WRAPPER_METHODS_ACTIVE = 2L;
        private long initializedBitset;
        @Nullable
        private AdvancedConfigDto config;
        private boolean timerWrapperMethodsActive;

        private Builder() {
        }

        public final Builder from(ConfigJsonService.AdvancedConfigResponseBase instance) {
            Preconditions.checkNotNull(instance);
            this.config(instance.config());
            this.timerWrapperMethodsActive(instance.timerWrapperMethodsActive());
            return this;
        }

        public final Builder config(AdvancedConfigDto config) {
            this.config = Preconditions.checkNotNull(config);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder timerWrapperMethodsActive(boolean timerWrapperMethodsActive) {
            this.timerWrapperMethodsActive = timerWrapperMethodsActive;
            this.initializedBitset |= 2L;
            return this;
        }

        public AdvancedConfigResponse build() {
            this.checkRequiredAttributes();
            return new AdvancedConfigResponse(this);
        }

        private boolean configIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean timerWrapperMethodsActiveIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.configIsSet()) {
                attributes.add("config");
            }
            if (!this.timerWrapperMethodsActiveIsSet()) {
                attributes.add("timerWrapperMethodsActive");
            }
            return "Cannot build AdvancedConfigResponse, some of required attributes are not set " + attributes;
        }
    }
}

