/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.MBeanAttribute;
import org.glowroot.local.ui.GaugeJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class GaugeConfigDto
extends GaugeJsonService.GaugeConfigDtoBase {
    @Nullable
    private final String display;
    private final String mbeanObjectName;
    private final ImmutableList<MBeanAttribute> mbeanAttributes;
    @Nullable
    private final String version;

    private GaugeConfigDto(Builder builder) {
        this.display = builder.display;
        this.mbeanObjectName = builder.mbeanObjectName;
        this.mbeanAttributes = builder.mbeanAttributesBuilder.build();
        this.version = builder.version;
    }

    private GaugeConfigDto(GaugeConfigDto original, @Nullable String display, String mbeanObjectName, ImmutableList<MBeanAttribute> mbeanAttributes, @Nullable String version) {
        this.display = display;
        this.mbeanObjectName = mbeanObjectName;
        this.mbeanAttributes = mbeanAttributes;
        this.version = version;
    }

    @Override
    @Nullable
    @JsonProperty(value="display")
    public String display() {
        return this.display;
    }

    @Override
    @JsonProperty(value="mbeanObjectName")
    public String mbeanObjectName() {
        return this.mbeanObjectName;
    }

    @Override
    @JsonProperty(value="mbeanAttributes")
    public ImmutableList<MBeanAttribute> mbeanAttributes() {
        return this.mbeanAttributes;
    }

    @Override
    @Nullable
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final GaugeConfigDto withDisplay(@Nullable String value) {
        if (this.display == value) {
            return this;
        }
        String newValue = value;
        return new GaugeConfigDto(this, newValue, this.mbeanObjectName, this.mbeanAttributes, this.version);
    }

    public final GaugeConfigDto withMbeanObjectName(String value) {
        if (this.mbeanObjectName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GaugeConfigDto(this, this.display, newValue, this.mbeanAttributes, this.version);
    }

    public final GaugeConfigDto withMbeanAttributes(MBeanAttribute ... elements) {
        ImmutableList<MBeanAttribute> newValue = ImmutableList.copyOf(elements);
        return new GaugeConfigDto(this, this.display, this.mbeanObjectName, newValue, this.version);
    }

    public final GaugeConfigDto withMbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
        if (this.mbeanAttributes == elements) {
            return this;
        }
        ImmutableList<MBeanAttribute> newValue = ImmutableList.copyOf(elements);
        return new GaugeConfigDto(this, this.display, this.mbeanObjectName, newValue, this.version);
    }

    public final GaugeConfigDto withVersion(@Nullable String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = value;
        return new GaugeConfigDto(this, this.display, this.mbeanObjectName, this.mbeanAttributes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GaugeConfigDto && this.equalTo((GaugeConfigDto)another);
    }

    private boolean equalTo(GaugeConfigDto another) {
        return Objects.equal(this.display, another.display) && this.mbeanObjectName.equals(another.mbeanObjectName) && this.mbeanAttributes.equals(another.mbeanAttributes) && Objects.equal(this.version, another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.display);
        h = h * 17 + this.mbeanObjectName.hashCode();
        h = h * 17 + this.mbeanAttributes.hashCode();
        h = h * 17 + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugeConfigDto").add("display", this.display).add("mbeanObjectName", this.mbeanObjectName).add("mbeanAttributes", this.mbeanAttributes).add("version", this.version).toString();
    }

    @JsonCreator
    public static GaugeConfigDto fromAllAttributes(@JsonProperty(value="display") @Nullable String display, @JsonProperty(value="mbeanObjectName") @Nullable String mbeanObjectName, @JsonProperty(value="mbeanAttributes") @Nullable ImmutableList<MBeanAttribute> mbeanAttributes, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = GaugeConfigDto.builder();
        if (display != null) {
            builder.display(display);
        }
        if (mbeanObjectName != null) {
            builder.mbeanObjectName(mbeanObjectName);
        }
        if (mbeanAttributes != null) {
            builder.addAllMbeanAttributes(mbeanAttributes);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static GaugeConfigDto copyOf(GaugeJsonService.GaugeConfigDtoBase instance) {
        if (instance instanceof GaugeConfigDto) {
            return (GaugeConfigDto)instance;
        }
        return GaugeConfigDto.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_MBEAN_OBJECT_NAME = 1L;
        private long initializedBitset;
        @Nullable
        private String display;
        @Nullable
        private String mbeanObjectName;
        private ImmutableList.Builder<MBeanAttribute> mbeanAttributesBuilder = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder from(GaugeJsonService.GaugeConfigDtoBase instance) {
            Preconditions.checkNotNull(instance);
            String displayValue = instance.display();
            if (displayValue != null) {
                this.display(displayValue);
            }
            this.mbeanObjectName(instance.mbeanObjectName());
            this.addAllMbeanAttributes(instance.mbeanAttributes());
            String versionValue = instance.version();
            if (versionValue != null) {
                this.version(versionValue);
            }
            return this;
        }

        public final Builder display(@Nullable String display) {
            this.display = display;
            return this;
        }

        public final Builder mbeanObjectName(String mbeanObjectName) {
            this.mbeanObjectName = Preconditions.checkNotNull(mbeanObjectName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addMbeanAttributes(MBeanAttribute element) {
            this.mbeanAttributesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMbeanAttributes(MBeanAttribute ... elements) {
            this.mbeanAttributesBuilder.add(elements);
            return this;
        }

        public final Builder mbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
            this.mbeanAttributesBuilder = ImmutableList.builder();
            return this.addAllMbeanAttributes(elements);
        }

        public final Builder addAllMbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
            this.mbeanAttributesBuilder.addAll(elements);
            return this;
        }

        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public GaugeConfigDto build() {
            this.checkRequiredAttributes();
            return new GaugeConfigDto(this);
        }

        private boolean mbeanObjectNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.mbeanObjectNameIsSet()) {
                attributes.add("mbeanObjectName");
            }
            return "Cannot build GaugeConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

