/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.JvmJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class GaugePointRequest
extends JvmJsonService.GaugePointRequestBase {
    private final long from;
    private final long to;
    private final ImmutableList<String> gaugeNames;
    private final int rollupLevel;

    private GaugePointRequest(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.gaugeNames = builder.gaugeNamesBuilder.build();
        this.rollupLevel = builder.rollupLevel;
    }

    private GaugePointRequest(GaugePointRequest original, long from, long to, ImmutableList<String> gaugeNames, int rollupLevel) {
        this.from = from;
        this.to = to;
        this.gaugeNames = gaugeNames;
        this.rollupLevel = rollupLevel;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="gaugeNames")
    public ImmutableList<String> gaugeNames() {
        return this.gaugeNames;
    }

    @Override
    @JsonProperty(value="rollupLevel")
    public int rollupLevel() {
        return this.rollupLevel;
    }

    public final GaugePointRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new GaugePointRequest(this, newValue, this.to, this.gaugeNames, this.rollupLevel);
    }

    public final GaugePointRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new GaugePointRequest(this, this.from, newValue, this.gaugeNames, this.rollupLevel);
    }

    public final GaugePointRequest withGaugeNames(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new GaugePointRequest(this, this.from, this.to, newValue, this.rollupLevel);
    }

    public final GaugePointRequest withGaugeNames(Iterable<String> elements) {
        if (this.gaugeNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new GaugePointRequest(this, this.from, this.to, newValue, this.rollupLevel);
    }

    public final GaugePointRequest withRollupLevel(int value) {
        if (this.rollupLevel == value) {
            return this;
        }
        int newValue = value;
        return new GaugePointRequest(this, this.from, this.to, this.gaugeNames, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GaugePointRequest && this.equalTo((GaugePointRequest)another);
    }

    private boolean equalTo(GaugePointRequest another) {
        return this.from == another.from && this.to == another.to && this.gaugeNames.equals(another.gaugeNames) && this.rollupLevel == another.rollupLevel;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.gaugeNames.hashCode();
        h = h * 17 + this.rollupLevel;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugePointRequest").add("from", this.from).add("to", this.to).add("gaugeNames", this.gaugeNames).add("rollupLevel", this.rollupLevel).toString();
    }

    @JsonCreator
    public static GaugePointRequest fromAllAttributes(@JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="gaugeNames") @Nullable ImmutableList<String> gaugeNames, @JsonProperty(value="rollupLevel") @Nullable Integer rollupLevel) {
        Builder builder = GaugePointRequest.builder();
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (gaugeNames != null) {
            builder.addAllGaugeNames(gaugeNames);
        }
        if (rollupLevel != null) {
            builder.rollupLevel(rollupLevel);
        }
        return builder.build();
    }

    static GaugePointRequest copyOf(JvmJsonService.GaugePointRequestBase instance) {
        if (instance instanceof GaugePointRequest) {
            return (GaugePointRequest)instance;
        }
        return GaugePointRequest.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private static final long INITIALIZED_BIT_ROLLUP_LEVEL = 4L;
        private long initializedBitset;
        private long from;
        private long to;
        private ImmutableList.Builder<String> gaugeNamesBuilder = ImmutableList.builder();
        private int rollupLevel;

        private Builder() {
        }

        public final Builder from(JvmJsonService.GaugePointRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.from(instance.from());
            this.to(instance.to());
            this.addAllGaugeNames(instance.gaugeNames());
            this.rollupLevel(instance.rollupLevel());
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addGaugeNames(String element) {
            this.gaugeNamesBuilder.add((Object)element);
            return this;
        }

        public final Builder addGaugeNames(String ... elements) {
            this.gaugeNamesBuilder.add(elements);
            return this;
        }

        public final Builder gaugeNames(Iterable<String> elements) {
            this.gaugeNamesBuilder = ImmutableList.builder();
            return this.addAllGaugeNames(elements);
        }

        public final Builder addAllGaugeNames(Iterable<String> elements) {
            this.gaugeNamesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder rollupLevel(int rollupLevel) {
            this.rollupLevel = rollupLevel;
            this.initializedBitset |= 4L;
            return this;
        }

        public GaugePointRequest build() {
            this.checkRequiredAttributes();
            return new GaugePointRequest(this);
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean rollupLevelIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.rollupLevelIsSet()) {
                attributes.add("rollupLevel");
            }
            return "Cannot build GaugePointRequest, some of required attributes are not set " + attributes;
        }
    }
}

