/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class GeneralConfigDto
extends ConfigJsonService.GeneralConfigDtoBase {
    private final boolean enabled;
    private final int traceStoreThresholdMillis;
    private final int profilingIntervalMillis;
    private final String defaultTransactionType;
    private final String version;

    private GeneralConfigDto(Builder builder) {
        this.enabled = builder.enabled;
        this.traceStoreThresholdMillis = builder.traceStoreThresholdMillis;
        this.profilingIntervalMillis = builder.profilingIntervalMillis;
        this.defaultTransactionType = builder.defaultTransactionType;
        this.version = builder.version;
    }

    private GeneralConfigDto(GeneralConfigDto original, boolean enabled, int traceStoreThresholdMillis, int profilingIntervalMillis, String defaultTransactionType, String version) {
        this.enabled = enabled;
        this.traceStoreThresholdMillis = traceStoreThresholdMillis;
        this.profilingIntervalMillis = profilingIntervalMillis;
        this.defaultTransactionType = defaultTransactionType;
        this.version = version;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="traceStoreThresholdMillis")
    public int traceStoreThresholdMillis() {
        return this.traceStoreThresholdMillis;
    }

    @Override
    @JsonProperty(value="profilingIntervalMillis")
    public int profilingIntervalMillis() {
        return this.profilingIntervalMillis;
    }

    @Override
    @JsonProperty(value="defaultTransactionType")
    public String defaultTransactionType() {
        return this.defaultTransactionType;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final GeneralConfigDto withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        boolean newValue = value;
        return new GeneralConfigDto(this, newValue, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultTransactionType, this.version);
    }

    public final GeneralConfigDto withTraceStoreThresholdMillis(int value) {
        if (this.traceStoreThresholdMillis == value) {
            return this;
        }
        int newValue = value;
        return new GeneralConfigDto(this, this.enabled, newValue, this.profilingIntervalMillis, this.defaultTransactionType, this.version);
    }

    public final GeneralConfigDto withProfilingIntervalMillis(int value) {
        if (this.profilingIntervalMillis == value) {
            return this;
        }
        int newValue = value;
        return new GeneralConfigDto(this, this.enabled, this.traceStoreThresholdMillis, newValue, this.defaultTransactionType, this.version);
    }

    public final GeneralConfigDto withDefaultTransactionType(String value) {
        if (this.defaultTransactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GeneralConfigDto(this, this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, newValue, this.version);
    }

    public final GeneralConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GeneralConfigDto(this, this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultTransactionType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GeneralConfigDto && this.equalTo((GeneralConfigDto)another);
    }

    private boolean equalTo(GeneralConfigDto another) {
        return this.enabled == another.enabled && this.traceStoreThresholdMillis == another.traceStoreThresholdMillis && this.profilingIntervalMillis == another.profilingIntervalMillis && this.defaultTransactionType.equals(another.defaultTransactionType) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.enabled);
        h = h * 17 + this.traceStoreThresholdMillis;
        h = h * 17 + this.profilingIntervalMillis;
        h = h * 17 + this.defaultTransactionType.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeneralConfigDto").add("enabled", this.enabled).add("traceStoreThresholdMillis", this.traceStoreThresholdMillis).add("profilingIntervalMillis", this.profilingIntervalMillis).add("defaultTransactionType", this.defaultTransactionType).add("version", this.version).toString();
    }

    @JsonCreator
    public static GeneralConfigDto fromAllAttributes(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="traceStoreThresholdMillis") @Nullable Integer traceStoreThresholdMillis, @JsonProperty(value="profilingIntervalMillis") @Nullable Integer profilingIntervalMillis, @JsonProperty(value="defaultTransactionType") @Nullable String defaultTransactionType, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = GeneralConfigDto.builder();
        if (enabled != null) {
            builder.enabled(enabled);
        }
        if (traceStoreThresholdMillis != null) {
            builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
        }
        if (profilingIntervalMillis != null) {
            builder.profilingIntervalMillis(profilingIntervalMillis);
        }
        if (defaultTransactionType != null) {
            builder.defaultTransactionType(defaultTransactionType);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static GeneralConfigDto copyOf(ConfigJsonService.GeneralConfigDtoBase instance) {
        if (instance instanceof GeneralConfigDto) {
            return (GeneralConfigDto)instance;
        }
        return GeneralConfigDto.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 31L;
        private static final long INITIALIZED_BIT_ENABLED = 1L;
        private static final long INITIALIZED_BIT_TRACE_STORE_THRESHOLD_MILLIS = 2L;
        private static final long INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS = 4L;
        private static final long INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE = 8L;
        private static final long INITIALIZED_BIT_VERSION = 16L;
        private long initializedBitset;
        private boolean enabled;
        private int traceStoreThresholdMillis;
        private int profilingIntervalMillis;
        @Nullable
        private String defaultTransactionType;
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder from(ConfigJsonService.GeneralConfigDtoBase instance) {
            Preconditions.checkNotNull(instance);
            this.enabled(instance.enabled());
            this.traceStoreThresholdMillis(instance.traceStoreThresholdMillis());
            this.profilingIntervalMillis(instance.profilingIntervalMillis());
            this.defaultTransactionType(instance.defaultTransactionType());
            this.version(instance.version());
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder traceStoreThresholdMillis(int traceStoreThresholdMillis) {
            this.traceStoreThresholdMillis = traceStoreThresholdMillis;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder defaultTransactionType(String defaultTransactionType) {
            this.defaultTransactionType = Preconditions.checkNotNull(defaultTransactionType);
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder version(String version) {
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 0x10L;
            return this;
        }

        public GeneralConfigDto build() {
            this.checkRequiredAttributes();
            return new GeneralConfigDto(this);
        }

        private boolean enabledIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean traceStoreThresholdMillisIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean profilingIntervalMillisIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean defaultTransactionTypeIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 31L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.enabledIsSet()) {
                attributes.add("enabled");
            }
            if (!this.traceStoreThresholdMillisIsSet()) {
                attributes.add("traceStoreThresholdMillis");
            }
            if (!this.profilingIntervalMillisIsSet()) {
                attributes.add("profilingIntervalMillis");
            }
            if (!this.defaultTransactionTypeIsSet()) {
                attributes.add("defaultTransactionType");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build GeneralConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

