/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.LazyHistogram;
import org.glowroot.local.ui.AggregateMerging;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class HistogramMergedAggregate
extends AggregateMerging.HistogramMergedAggregateBase {
    private final LazyHistogram histogram;
    private final long totalMicros;
    private final long transactionCount;
    private final long percentile1;
    private final long percentile2;
    private final long percentile3;

    private HistogramMergedAggregate(Builder builder) {
        this.histogram = builder.histogram;
        this.totalMicros = builder.totalMicros;
        this.transactionCount = builder.transactionCount;
        this.percentile1 = super.percentile1();
        this.percentile2 = super.percentile2();
        this.percentile3 = super.percentile3();
    }

    private HistogramMergedAggregate(HistogramMergedAggregate original, LazyHistogram histogram, long totalMicros, long transactionCount) {
        this.histogram = histogram;
        this.totalMicros = totalMicros;
        this.transactionCount = transactionCount;
        this.percentile1 = super.percentile1();
        this.percentile2 = super.percentile2();
        this.percentile3 = super.percentile3();
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="histogram")
    public LazyHistogram histogram() {
        return this.histogram;
    }

    @Override
    @JsonProperty(value="totalMicros")
    public long totalMicros() {
        return this.totalMicros;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    @Override
    @JsonProperty(value="percentile1")
    public long percentile1() {
        return this.percentile1;
    }

    @Override
    @JsonProperty(value="percentile2")
    public long percentile2() {
        return this.percentile2;
    }

    @Override
    @JsonProperty(value="percentile3")
    public long percentile3() {
        return this.percentile3;
    }

    public final HistogramMergedAggregate withHistogram(LazyHistogram value) {
        if (this.histogram == value) {
            return this;
        }
        LazyHistogram newValue = Preconditions.checkNotNull(value);
        return new HistogramMergedAggregate(this, newValue, this.totalMicros, this.transactionCount);
    }

    public final HistogramMergedAggregate withTotalMicros(long value) {
        if (this.totalMicros == value) {
            return this;
        }
        long newValue = value;
        return new HistogramMergedAggregate(this, this.histogram, newValue, this.transactionCount);
    }

    public final HistogramMergedAggregate withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        long newValue = value;
        return new HistogramMergedAggregate(this, this.histogram, this.totalMicros, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof HistogramMergedAggregate && this.equalTo((HistogramMergedAggregate)another);
    }

    private boolean equalTo(HistogramMergedAggregate another) {
        return this.histogram.equals(another.histogram) && this.totalMicros == another.totalMicros && this.transactionCount == another.transactionCount && this.percentile1 == another.percentile1 && this.percentile2 == another.percentile2 && this.percentile3 == another.percentile3;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.histogram.hashCode();
        h = h * 17 + Longs.hashCode(this.totalMicros);
        h = h * 17 + Longs.hashCode(this.transactionCount);
        h = h * 17 + Longs.hashCode(this.percentile1);
        h = h * 17 + Longs.hashCode(this.percentile2);
        h = h * 17 + Longs.hashCode(this.percentile3);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("HistogramMergedAggregate").add("histogram", this.histogram).add("totalMicros", this.totalMicros).add("transactionCount", this.transactionCount).add("percentile1", this.percentile1).add("percentile2", this.percentile2).add("percentile3", this.percentile3).toString();
    }

    @JsonCreator
    public static HistogramMergedAggregate fromAllAttributes(@JsonProperty(value="histogram") @Nullable LazyHistogram histogram, @JsonProperty(value="totalMicros") @Nullable Long totalMicros, @JsonProperty(value="transactionCount") @Nullable Long transactionCount) {
        Builder builder = HistogramMergedAggregate.builder();
        if (histogram != null) {
            builder.histogram(histogram);
        }
        if (totalMicros != null) {
            builder.totalMicros(totalMicros);
        }
        if (transactionCount != null) {
            builder.transactionCount(transactionCount);
        }
        return builder.build();
    }

    public static HistogramMergedAggregate copyOf(AggregateMerging.HistogramMergedAggregateBase instance) {
        if (instance instanceof HistogramMergedAggregate) {
            return (HistogramMergedAggregate)instance;
        }
        return HistogramMergedAggregate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_HISTOGRAM = 1L;
        private static final long INITIALIZED_BIT_TOTAL_MICROS = 2L;
        private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 4L;
        private long initializedBitset;
        @Nullable
        private LazyHistogram histogram;
        private long totalMicros;
        private long transactionCount;

        private Builder() {
        }

        public final Builder from(AggregateMerging.HistogramMergedAggregateBase instance) {
            Preconditions.checkNotNull(instance);
            this.histogram(instance.histogram());
            this.totalMicros(instance.totalMicros());
            this.transactionCount(instance.transactionCount());
            return this;
        }

        public final Builder histogram(LazyHistogram histogram) {
            this.histogram = Preconditions.checkNotNull(histogram);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder totalMicros(long totalMicros) {
            this.totalMicros = totalMicros;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initializedBitset |= 4L;
            return this;
        }

        public HistogramMergedAggregate build() {
            this.checkRequiredAttributes();
            return new HistogramMergedAggregate(this);
        }

        private boolean histogramIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean totalMicrosIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean transactionCountIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.histogramIsSet()) {
                attributes.add("histogram");
            }
            if (!this.totalMicrosIsSet()) {
                attributes.add("totalMicros");
            }
            if (!this.transactionCountIsSet()) {
                attributes.add("transactionCount");
            }
            return "Cannot build HistogramMergedAggregate, some of required attributes are not set " + attributes;
        }
    }
}

