/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.api.weaving.MethodModifier;
import org.glowroot.config.CaptureKind;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class InstrumentationConfigDto
extends InstrumentationJsonService.InstrumentationConfigDtoBase {
    private final String className;
    private final String methodName;
    private final ImmutableList<String> methodParameterTypes;
    private final Optional<String> methodReturnType;
    private final ImmutableList<MethodModifier> methodModifiers;
    private final CaptureKind captureKind;
    private final Optional<String> timerName;
    private final Optional<String> traceEntryTemplate;
    @Nullable
    private final Long traceEntryStackThresholdMillis;
    private final Optional<Boolean> traceEntryCaptureSelfNested;
    private final Optional<String> transactionType;
    private final Optional<String> transactionNameTemplate;
    private final Optional<String> transactionUserTemplate;
    private final ImmutableMap<String, String> transactionCustomAttributeTemplates;
    @Nullable
    private final Long traceStoreThresholdMillis;
    private final Optional<String> enabledProperty;
    private final Optional<String> traceEntryEnabledProperty;
    @Nullable
    private final String version;

    private InstrumentationConfigDto(Builder builder) {
        this.className = builder.className;
        this.methodName = builder.methodName;
        this.methodParameterTypes = builder.methodParameterTypesBuilder.build();
        this.methodReturnType = builder.methodReturnType;
        this.methodModifiers = builder.methodModifiersBuilder.build();
        this.captureKind = builder.captureKind;
        this.timerName = builder.timerName;
        this.traceEntryTemplate = builder.traceEntryTemplate;
        this.traceEntryStackThresholdMillis = builder.traceEntryStackThresholdMillis;
        this.traceEntryCaptureSelfNested = builder.traceEntryCaptureSelfNested;
        this.transactionType = builder.transactionType;
        this.transactionNameTemplate = builder.transactionNameTemplate;
        this.transactionUserTemplate = builder.transactionUserTemplate;
        this.transactionCustomAttributeTemplates = builder.transactionCustomAttributeTemplatesBuilder.build();
        this.traceStoreThresholdMillis = builder.traceStoreThresholdMillis;
        this.enabledProperty = builder.enabledProperty;
        this.traceEntryEnabledProperty = builder.traceEntryEnabledProperty;
        this.version = builder.version;
    }

    private InstrumentationConfigDto(InstrumentationConfigDto original, String className, String methodName, ImmutableList<String> methodParameterTypes, Optional<String> methodReturnType, ImmutableList<MethodModifier> methodModifiers, CaptureKind captureKind, Optional<String> timerName, Optional<String> traceEntryTemplate, @Nullable Long traceEntryStackThresholdMillis, Optional<Boolean> traceEntryCaptureSelfNested, Optional<String> transactionType, Optional<String> transactionNameTemplate, Optional<String> transactionUserTemplate, ImmutableMap<String, String> transactionCustomAttributeTemplates, @Nullable Long traceStoreThresholdMillis, Optional<String> enabledProperty, Optional<String> traceEntryEnabledProperty, @Nullable String version) {
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
        this.methodReturnType = methodReturnType;
        this.methodModifiers = methodModifiers;
        this.captureKind = captureKind;
        this.timerName = timerName;
        this.traceEntryTemplate = traceEntryTemplate;
        this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
        this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
        this.transactionType = transactionType;
        this.transactionNameTemplate = transactionNameTemplate;
        this.transactionUserTemplate = transactionUserTemplate;
        this.transactionCustomAttributeTemplates = transactionCustomAttributeTemplates;
        this.traceStoreThresholdMillis = traceStoreThresholdMillis;
        this.enabledProperty = enabledProperty;
        this.traceEntryEnabledProperty = traceEntryEnabledProperty;
        this.version = version;
    }

    @Override
    @JsonProperty(value="className")
    public String className() {
        return this.className;
    }

    @Override
    @JsonProperty(value="methodName")
    public String methodName() {
        return this.methodName;
    }

    @Override
    @JsonProperty(value="methodParameterTypes")
    public ImmutableList<String> methodParameterTypes() {
        return this.methodParameterTypes;
    }

    @Override
    @JsonProperty(value="methodReturnType")
    public Optional<String> methodReturnType() {
        return this.methodReturnType;
    }

    @Override
    @JsonProperty(value="methodModifiers")
    public ImmutableList<MethodModifier> methodModifiers() {
        return this.methodModifiers;
    }

    @Override
    @JsonProperty(value="captureKind")
    public CaptureKind captureKind() {
        return this.captureKind;
    }

    @Override
    @JsonProperty(value="timerName")
    public Optional<String> timerName() {
        return this.timerName;
    }

    @Override
    @JsonProperty(value="traceEntryTemplate")
    public Optional<String> traceEntryTemplate() {
        return this.traceEntryTemplate;
    }

    @Override
    @Nullable
    @JsonProperty(value="traceEntryStackThresholdMillis")
    public Long traceEntryStackThresholdMillis() {
        return this.traceEntryStackThresholdMillis;
    }

    @Override
    @JsonProperty(value="traceEntryCaptureSelfNested")
    public Optional<Boolean> traceEntryCaptureSelfNested() {
        return this.traceEntryCaptureSelfNested;
    }

    @Override
    @JsonProperty(value="transactionType")
    public Optional<String> transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionNameTemplate")
    public Optional<String> transactionNameTemplate() {
        return this.transactionNameTemplate;
    }

    @Override
    @JsonProperty(value="transactionUserTemplate")
    public Optional<String> transactionUserTemplate() {
        return this.transactionUserTemplate;
    }

    @JsonProperty(value="transactionCustomAttributeTemplates")
    public ImmutableMap<String, String> transactionCustomAttributeTemplates() {
        return this.transactionCustomAttributeTemplates;
    }

    @Override
    @Nullable
    @JsonProperty(value="traceStoreThresholdMillis")
    public Long traceStoreThresholdMillis() {
        return this.traceStoreThresholdMillis;
    }

    @Override
    @JsonProperty(value="enabledProperty")
    public Optional<String> enabledProperty() {
        return this.enabledProperty;
    }

    @Override
    @JsonProperty(value="traceEntryEnabledProperty")
    public Optional<String> traceEntryEnabledProperty() {
        return this.traceEntryEnabledProperty;
    }

    @Override
    @Nullable
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final InstrumentationConfigDto withClassName(String value) {
        if (this.className == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfigDto(this, newValue, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodName(String value) {
        if (this.methodName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfigDto(this, this.className, newValue, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigDto(this, this.className, this.methodName, newValue, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodParameterTypes(Iterable<String> elements) {
        if (this.methodParameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigDto(this, this.className, this.methodName, newValue, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodReturnType(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, newValue, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodReturnType(Optional<String> optional) {
        if (this.methodReturnType == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, newValue, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodModifiers(MethodModifier ... elements) {
        ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, newValue, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodModifiers(Iterable<? extends MethodModifier> elements) {
        if (this.methodModifiers == elements) {
            return this;
        }
        ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, newValue, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withCaptureKind(CaptureKind value) {
        if (this.captureKind == value) {
            return this;
        }
        CaptureKind newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, newValue, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTimerName(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, newValue, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTimerName(Optional<String> optional) {
        if (this.timerName == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, newValue, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryTemplate(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, newValue, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryTemplate(Optional<String> optional) {
        if (this.traceEntryTemplate == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, newValue, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryStackThresholdMillis(@Nullable Long value) {
        if (this.traceEntryStackThresholdMillis == value) {
            return this;
        }
        Long newValue = value;
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, newValue, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryCaptureSelfNested(boolean value) {
        Optional<Boolean> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, newValue, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryCaptureSelfNested(Optional<Boolean> optional) {
        if (this.traceEntryCaptureSelfNested == optional) {
            return this;
        }
        Optional<Boolean> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, newValue, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionType(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, newValue, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionType(Optional<String> optional) {
        if (this.transactionType == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, newValue, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionNameTemplate(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, newValue, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionNameTemplate(Optional<String> optional) {
        if (this.transactionNameTemplate == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, newValue, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionUserTemplate(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, newValue, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionUserTemplate(Optional<String> optional) {
        if (this.transactionUserTemplate == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, newValue, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
        if (this.transactionCustomAttributeTemplates == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, newValue, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceStoreThresholdMillis(@Nullable Long value) {
        if (this.traceStoreThresholdMillis == value) {
            return this;
        }
        Long newValue = value;
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, newValue, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withEnabledProperty(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, newValue, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withEnabledProperty(Optional<String> optional) {
        if (this.enabledProperty == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, newValue, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryEnabledProperty(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, newValue, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryEnabledProperty(Optional<String> optional) {
        if (this.traceEntryEnabledProperty == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, newValue, this.version);
    }

    public final InstrumentationConfigDto withVersion(@Nullable String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = value;
        return new InstrumentationConfigDto(this, this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof InstrumentationConfigDto && this.equalTo((InstrumentationConfigDto)another);
    }

    private boolean equalTo(InstrumentationConfigDto another) {
        return this.className.equals(another.className) && this.methodName.equals(another.methodName) && this.methodParameterTypes.equals(another.methodParameterTypes) && this.methodReturnType.equals(another.methodReturnType) && this.methodModifiers.equals(another.methodModifiers) && this.captureKind.equals((Object)another.captureKind) && this.timerName.equals(another.timerName) && this.traceEntryTemplate.equals(another.traceEntryTemplate) && Objects.equal(this.traceEntryStackThresholdMillis, another.traceEntryStackThresholdMillis) && this.traceEntryCaptureSelfNested.equals(another.traceEntryCaptureSelfNested) && this.transactionType.equals(another.transactionType) && this.transactionNameTemplate.equals(another.transactionNameTemplate) && this.transactionUserTemplate.equals(another.transactionUserTemplate) && this.transactionCustomAttributeTemplates.equals(another.transactionCustomAttributeTemplates) && Objects.equal(this.traceStoreThresholdMillis, another.traceStoreThresholdMillis) && this.enabledProperty.equals(another.enabledProperty) && this.traceEntryEnabledProperty.equals(another.traceEntryEnabledProperty) && Objects.equal(this.version, another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.className.hashCode();
        h = h * 17 + this.methodName.hashCode();
        h = h * 17 + this.methodParameterTypes.hashCode();
        h = h * 17 + this.methodReturnType.hashCode();
        h = h * 17 + this.methodModifiers.hashCode();
        h = h * 17 + this.captureKind.hashCode();
        h = h * 17 + this.timerName.hashCode();
        h = h * 17 + this.traceEntryTemplate.hashCode();
        h = h * 17 + Objects.hashCode(this.traceEntryStackThresholdMillis);
        h = h * 17 + this.traceEntryCaptureSelfNested.hashCode();
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + this.transactionNameTemplate.hashCode();
        h = h * 17 + this.transactionUserTemplate.hashCode();
        h = h * 17 + this.transactionCustomAttributeTemplates.hashCode();
        h = h * 17 + Objects.hashCode(this.traceStoreThresholdMillis);
        h = h * 17 + this.enabledProperty.hashCode();
        h = h * 17 + this.traceEntryEnabledProperty.hashCode();
        h = h * 17 + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("InstrumentationConfigDto").add("className", this.className).add("methodName", this.methodName).add("methodParameterTypes", this.methodParameterTypes).add("methodReturnType", this.methodReturnType).add("methodModifiers", this.methodModifiers).add("captureKind", (Object)this.captureKind).add("timerName", this.timerName).add("traceEntryTemplate", this.traceEntryTemplate).add("traceEntryStackThresholdMillis", this.traceEntryStackThresholdMillis).add("traceEntryCaptureSelfNested", this.traceEntryCaptureSelfNested).add("transactionType", this.transactionType).add("transactionNameTemplate", this.transactionNameTemplate).add("transactionUserTemplate", this.transactionUserTemplate).add("transactionCustomAttributeTemplates", this.transactionCustomAttributeTemplates).add("traceStoreThresholdMillis", this.traceStoreThresholdMillis).add("enabledProperty", this.enabledProperty).add("traceEntryEnabledProperty", this.traceEntryEnabledProperty).add("version", this.version).toString();
    }

    @JsonCreator
    public static InstrumentationConfigDto fromAllAttributes(@JsonProperty(value="className") @Nullable String className, @JsonProperty(value="methodName") @Nullable String methodName, @JsonProperty(value="methodParameterTypes") @Nullable ImmutableList<String> methodParameterTypes, @JsonProperty(value="methodReturnType") @Nullable Optional<String> methodReturnType, @JsonProperty(value="methodModifiers") @Nullable ImmutableList<MethodModifier> methodModifiers, @JsonProperty(value="captureKind") @Nullable CaptureKind captureKind, @JsonProperty(value="timerName") @Nullable Optional<String> timerName, @JsonProperty(value="traceEntryTemplate") @Nullable Optional<String> traceEntryTemplate, @JsonProperty(value="traceEntryStackThresholdMillis") @Nullable Long traceEntryStackThresholdMillis, @JsonProperty(value="traceEntryCaptureSelfNested") @Nullable Optional<Boolean> traceEntryCaptureSelfNested, @JsonProperty(value="transactionType") @Nullable Optional<String> transactionType, @JsonProperty(value="transactionNameTemplate") @Nullable Optional<String> transactionNameTemplate, @JsonProperty(value="transactionUserTemplate") @Nullable Optional<String> transactionUserTemplate, @JsonProperty(value="transactionCustomAttributeTemplates") @Nullable Map<String, String> transactionCustomAttributeTemplates, @JsonProperty(value="traceStoreThresholdMillis") @Nullable Long traceStoreThresholdMillis, @JsonProperty(value="enabledProperty") @Nullable Optional<String> enabledProperty, @JsonProperty(value="traceEntryEnabledProperty") @Nullable Optional<String> traceEntryEnabledProperty, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = InstrumentationConfigDto.builder();
        if (className != null) {
            builder.className(className);
        }
        if (methodName != null) {
            builder.methodName(methodName);
        }
        if (methodParameterTypes != null) {
            builder.addAllMethodParameterTypes(methodParameterTypes);
        }
        if (methodReturnType != null) {
            builder.methodReturnType(methodReturnType);
        }
        if (methodModifiers != null) {
            builder.addAllMethodModifiers(methodModifiers);
        }
        if (captureKind != null) {
            builder.captureKind(captureKind);
        }
        if (timerName != null) {
            builder.timerName(timerName);
        }
        if (traceEntryTemplate != null) {
            builder.traceEntryTemplate(traceEntryTemplate);
        }
        if (traceEntryStackThresholdMillis != null) {
            builder.traceEntryStackThresholdMillis(traceEntryStackThresholdMillis);
        }
        if (traceEntryCaptureSelfNested != null) {
            builder.traceEntryCaptureSelfNested(traceEntryCaptureSelfNested);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionNameTemplate != null) {
            builder.transactionNameTemplate(transactionNameTemplate);
        }
        if (transactionUserTemplate != null) {
            builder.transactionUserTemplate(transactionUserTemplate);
        }
        if (transactionCustomAttributeTemplates != null) {
            builder.putAllTransactionCustomAttributeTemplates(transactionCustomAttributeTemplates);
        }
        if (traceStoreThresholdMillis != null) {
            builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
        }
        if (enabledProperty != null) {
            builder.enabledProperty(enabledProperty);
        }
        if (traceEntryEnabledProperty != null) {
            builder.traceEntryEnabledProperty(traceEntryEnabledProperty);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static InstrumentationConfigDto copyOf(InstrumentationJsonService.InstrumentationConfigDtoBase instance) {
        if (instance instanceof InstrumentationConfigDto) {
            return (InstrumentationConfigDto)instance;
        }
        return InstrumentationConfigDto.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_CLASS_NAME = 1L;
        private static final long INITIALIZED_BIT_METHOD_NAME = 2L;
        private static final long INITIALIZED_BIT_CAPTURE_KIND = 4L;
        private long initializedBitset;
        @Nullable
        private String className;
        @Nullable
        private String methodName;
        private ImmutableList.Builder<String> methodParameterTypesBuilder = ImmutableList.builder();
        private Optional<String> methodReturnType = Optional.absent();
        private ImmutableList.Builder<MethodModifier> methodModifiersBuilder = ImmutableList.builder();
        @Nullable
        private CaptureKind captureKind;
        private Optional<String> timerName = Optional.absent();
        private Optional<String> traceEntryTemplate = Optional.absent();
        @Nullable
        private Long traceEntryStackThresholdMillis;
        private Optional<Boolean> traceEntryCaptureSelfNested = Optional.absent();
        private Optional<String> transactionType = Optional.absent();
        private Optional<String> transactionNameTemplate = Optional.absent();
        private Optional<String> transactionUserTemplate = Optional.absent();
        private ImmutableMap.Builder<String, String> transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
        @Nullable
        private Long traceStoreThresholdMillis;
        private Optional<String> enabledProperty = Optional.absent();
        private Optional<String> traceEntryEnabledProperty = Optional.absent();
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder from(InstrumentationJsonService.InstrumentationConfigDtoBase instance) {
            String versionValue;
            Optional<String> traceEntryEnabledPropertyOptional;
            Optional<String> enabledPropertyOptional;
            Optional<String> transactionUserTemplateOptional;
            Optional<String> transactionNameTemplateOptional;
            Optional<String> transactionTypeOptional;
            Optional<Boolean> traceEntryCaptureSelfNestedOptional;
            Long traceEntryStackThresholdMillisValue;
            Optional<String> traceEntryTemplateOptional;
            Preconditions.checkNotNull(instance);
            this.className(instance.className());
            this.methodName(instance.methodName());
            this.addAllMethodParameterTypes(instance.methodParameterTypes());
            Optional<String> methodReturnTypeOptional = instance.methodReturnType();
            if (methodReturnTypeOptional.isPresent()) {
                this.methodReturnType(methodReturnTypeOptional);
            }
            this.addAllMethodModifiers(instance.methodModifiers());
            this.captureKind(instance.captureKind());
            Optional<String> timerNameOptional = instance.timerName();
            if (timerNameOptional.isPresent()) {
                this.timerName(timerNameOptional);
            }
            if ((traceEntryTemplateOptional = instance.traceEntryTemplate()).isPresent()) {
                this.traceEntryTemplate(traceEntryTemplateOptional);
            }
            if ((traceEntryStackThresholdMillisValue = instance.traceEntryStackThresholdMillis()) != null) {
                this.traceEntryStackThresholdMillis(traceEntryStackThresholdMillisValue);
            }
            if ((traceEntryCaptureSelfNestedOptional = instance.traceEntryCaptureSelfNested()).isPresent()) {
                this.traceEntryCaptureSelfNested(traceEntryCaptureSelfNestedOptional);
            }
            if ((transactionTypeOptional = instance.transactionType()).isPresent()) {
                this.transactionType(transactionTypeOptional);
            }
            if ((transactionNameTemplateOptional = instance.transactionNameTemplate()).isPresent()) {
                this.transactionNameTemplate(transactionNameTemplateOptional);
            }
            if ((transactionUserTemplateOptional = instance.transactionUserTemplate()).isPresent()) {
                this.transactionUserTemplate(transactionUserTemplateOptional);
            }
            this.putAllTransactionCustomAttributeTemplates(instance.transactionCustomAttributeTemplates());
            Long traceStoreThresholdMillisValue = instance.traceStoreThresholdMillis();
            if (traceStoreThresholdMillisValue != null) {
                this.traceStoreThresholdMillis(traceStoreThresholdMillisValue);
            }
            if ((enabledPropertyOptional = instance.enabledProperty()).isPresent()) {
                this.enabledProperty(enabledPropertyOptional);
            }
            if ((traceEntryEnabledPropertyOptional = instance.traceEntryEnabledProperty()).isPresent()) {
                this.traceEntryEnabledProperty(traceEntryEnabledPropertyOptional);
            }
            if ((versionValue = instance.version()) != null) {
                this.version(versionValue);
            }
            return this;
        }

        public final Builder className(String className) {
            this.className = Preconditions.checkNotNull(className);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder methodName(String methodName) {
            this.methodName = Preconditions.checkNotNull(methodName);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addMethodParameterTypes(String element) {
            this.methodParameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodParameterTypes(String ... elements) {
            this.methodParameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder methodParameterTypes(Iterable<String> elements) {
            this.methodParameterTypesBuilder = ImmutableList.builder();
            return this.addAllMethodParameterTypes(elements);
        }

        public final Builder addAllMethodParameterTypes(Iterable<String> elements) {
            this.methodParameterTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder methodReturnType(String methodReturnType) {
            this.methodReturnType = Optional.of(methodReturnType);
            return this;
        }

        public final Builder methodReturnType(Optional<String> methodReturnType) {
            this.methodReturnType = Preconditions.checkNotNull(methodReturnType);
            return this;
        }

        public final Builder addMethodModifiers(MethodModifier element) {
            this.methodModifiersBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodModifiers(MethodModifier ... elements) {
            this.methodModifiersBuilder.add((Object[])elements);
            return this;
        }

        public final Builder methodModifiers(Iterable<? extends MethodModifier> elements) {
            this.methodModifiersBuilder = ImmutableList.builder();
            return this.addAllMethodModifiers(elements);
        }

        public final Builder addAllMethodModifiers(Iterable<? extends MethodModifier> elements) {
            this.methodModifiersBuilder.addAll(elements);
            return this;
        }

        public final Builder captureKind(CaptureKind captureKind) {
            this.captureKind = Preconditions.checkNotNull(captureKind);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder timerName(String timerName) {
            this.timerName = Optional.of(timerName);
            return this;
        }

        public final Builder timerName(Optional<String> timerName) {
            this.timerName = Preconditions.checkNotNull(timerName);
            return this;
        }

        public final Builder traceEntryTemplate(String traceEntryTemplate) {
            this.traceEntryTemplate = Optional.of(traceEntryTemplate);
            return this;
        }

        public final Builder traceEntryTemplate(Optional<String> traceEntryTemplate) {
            this.traceEntryTemplate = Preconditions.checkNotNull(traceEntryTemplate);
            return this;
        }

        public final Builder traceEntryStackThresholdMillis(@Nullable Long traceEntryStackThresholdMillis) {
            this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
            return this;
        }

        public final Builder traceEntryCaptureSelfNested(boolean traceEntryCaptureSelfNested) {
            this.traceEntryCaptureSelfNested = Optional.of(traceEntryCaptureSelfNested);
            return this;
        }

        public final Builder traceEntryCaptureSelfNested(Optional<Boolean> traceEntryCaptureSelfNested) {
            this.traceEntryCaptureSelfNested = Preconditions.checkNotNull(traceEntryCaptureSelfNested);
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Optional.of(transactionType);
            return this;
        }

        public final Builder transactionType(Optional<String> transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType);
            return this;
        }

        public final Builder transactionNameTemplate(String transactionNameTemplate) {
            this.transactionNameTemplate = Optional.of(transactionNameTemplate);
            return this;
        }

        public final Builder transactionNameTemplate(Optional<String> transactionNameTemplate) {
            this.transactionNameTemplate = Preconditions.checkNotNull(transactionNameTemplate);
            return this;
        }

        public final Builder transactionUserTemplate(String transactionUserTemplate) {
            this.transactionUserTemplate = Optional.of(transactionUserTemplate);
            return this;
        }

        public final Builder transactionUserTemplate(Optional<String> transactionUserTemplate) {
            this.transactionUserTemplate = Preconditions.checkNotNull(transactionUserTemplate);
            return this;
        }

        public final Builder putTransactionCustomAttributeTemplates(String key, String value) {
            this.transactionCustomAttributeTemplatesBuilder.put(key, value);
            return this;
        }

        public final Builder putTransactionCustomAttributeTemplates(Map.Entry<String, ? extends String> entry) {
            this.transactionCustomAttributeTemplatesBuilder.put(entry);
            return this;
        }

        public final Builder transactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
            this.transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
            return this.putAllTransactionCustomAttributeTemplates(entries);
        }

        public final Builder putAllTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
            this.transactionCustomAttributeTemplatesBuilder.putAll(entries);
            return this;
        }

        public final Builder traceStoreThresholdMillis(@Nullable Long traceStoreThresholdMillis) {
            this.traceStoreThresholdMillis = traceStoreThresholdMillis;
            return this;
        }

        public final Builder enabledProperty(String enabledProperty) {
            this.enabledProperty = Optional.of(enabledProperty);
            return this;
        }

        public final Builder enabledProperty(Optional<String> enabledProperty) {
            this.enabledProperty = Preconditions.checkNotNull(enabledProperty);
            return this;
        }

        public final Builder traceEntryEnabledProperty(String traceEntryEnabledProperty) {
            this.traceEntryEnabledProperty = Optional.of(traceEntryEnabledProperty);
            return this;
        }

        public final Builder traceEntryEnabledProperty(Optional<String> traceEntryEnabledProperty) {
            this.traceEntryEnabledProperty = Preconditions.checkNotNull(traceEntryEnabledProperty);
            return this;
        }

        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public InstrumentationConfigDto build() {
            this.checkRequiredAttributes();
            return new InstrumentationConfigDto(this);
        }

        private boolean classNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean methodNameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean captureKindIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            if (!this.methodNameIsSet()) {
                attributes.add("methodName");
            }
            if (!this.captureKindIsSet()) {
                attributes.add("captureKind");
            }
            return "Cannot build InstrumentationConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

